/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr;

import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.spi.RepositoryProvider;

@ThreadSafe
public class RepositoryFactory {
    public static final String PROVIDER_KEY = "org.modeshape.web.jcr.REPOSITORY_PROVIDER";
    private static RepositoryProvider provider;

    private RepositoryFactory() {
    }

    static void initialize(ServletContext context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        String className = context.getInitParameter(PROVIDER_KEY);
        try {
            Class<RepositoryProvider> providerClass = Class.forName(className).asSubclass(RepositoryProvider.class);
            provider = providerClass.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        provider.startup(context);
    }

    public static Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        return provider.getSession(request, repositoryName, workspaceName);
    }

    public static Collection<String> getJcrRepositoryNames() {
        return provider.getJcrRepositoryNames();
    }

    static void shutdown() {
        provider.shutdown();
    }
}

