/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class InclusionExclusionFilenameFilter
implements FilenameFilter {
    private String inclusionPattern = null;
    private String exclusionPattern = null;
    private Pattern inclusion;
    private Pattern exclusion;

    public void setExclusionPattern(String exclusionPattern) {
        this.exclusionPattern = exclusionPattern;
        this.exclusion = exclusionPattern == null ? null : Pattern.compile(exclusionPattern);
    }

    public void setInclusionPattern(String inclusionPattern) {
        this.inclusionPattern = inclusionPattern;
        this.inclusion = inclusionPattern == null ? null : Pattern.compile(inclusionPattern);
    }

    public String getExclusionPattern() {
        return this.exclusionPattern;
    }

    public String getInclusionPattern() {
        return this.inclusionPattern;
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.inclusionPattern == null && this.exclusionPattern == null) {
            return true;
        }
        if (this.inclusionPattern == null && this.exclusionPattern != null) {
            return !this.exclusion.matcher(string).matches();
        }
        if (this.exclusionPattern == null) {
            return this.inclusion.matcher(string).matches();
        }
        return this.inclusion.matcher(string).matches() && !this.exclusion.matcher(string).matches();
    }
}

