/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.modeshape.common.text.QuoteEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.filesystem.BasePropertiesFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;

public class StoreProperties
extends BasePropertiesFactory {
    private static final long serialVersionUID = 1L;
    protected static final String PROPERTY_PATTERN_STRING = "([\\S]+)\\s*[(](\\w+)[)]\\s*([\\[]?)?([^\\]]+)[\\]]?";
    protected static final Pattern PROPERTY_PATTERN = Pattern.compile("([\\S]+)\\s*[(](\\w+)[)]\\s*([\\[]?)?([^\\]]+)[\\]]?");
    protected static final String STRING_VALUE_PATTERN_STRING = "\\\"((((?<=\\\\)\\\")|[^\"])*)\\\"";
    protected static final Pattern STRING_VALUE_PATTERN = Pattern.compile("\\\"((((?<=\\\\)\\\")|[^\"])*)\\\"");
    protected static final String VALUE_PATTERN_STRING = "([^\\s,]+)\\s*[,]*\\s*";
    protected static final Pattern VALUE_PATTERN = Pattern.compile("([^\\s,]+)\\s*[,]*\\s*");
    public static final String DEFAULT_EXTENSION = ".modeshape";
    public static final String DEFAULT_RESOURCE_EXTENSION = ".content.modeshape";
    protected static final Map<Name, Property> NO_PROPERTIES_MAP = Collections.emptyMap();
    private final String extension;
    private final String resourceExtension;
    private String sourceName;
    private TextEncoder encoder = new XmlNameEncoder();
    private TextDecoder decoder = new XmlNameEncoder();
    private QuoteEncoder quoter = new QuoteEncoder();

    public StoreProperties() {
        this.extension = DEFAULT_EXTENSION;
        this.resourceExtension = DEFAULT_RESOURCE_EXTENSION;
    }

    @Override
    public FilenameFilter getFilenameFilter(final FilenameFilter exclusionFilter) {
        final Pattern extensionFilter = Pattern.compile(this.extension.replaceAll("\\.", "\\\\.") + "$");
        final Pattern resourceExtensionFilter = Pattern.compile(this.resourceExtension.replaceAll("\\.", "\\\\.") + "$");
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (extensionFilter.matcher(name).matches()) {
                    return false;
                }
                if (resourceExtensionFilter.matcher(name).matches()) {
                    return false;
                }
                return exclusionFilter == null || exclusionFilter.accept(dir, name);
            }
        };
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public Collection<Property> getDirectoryProperties(ExecutionContext context, Location location, File directory) {
        File parent = directory.getParentFile();
        if (parent == null) {
            return NO_PROPERTIES_COLLECTION;
        }
        return this.load(this.propertiesFileFor(directory), context).values();
    }

    @Override
    public Collection<Property> getFileProperties(ExecutionContext context, Location location, File file) {
        return this.load(this.propertiesFileFor(file), context).values();
    }

    @Override
    public Collection<Property> getResourceProperties(ExecutionContext context, Location location, File file, String mimeType) {
        return this.load(this.propertiesFileForResource(file), context).values();
    }

    @Override
    public Set<Name> recordDirectoryProperties(ExecutionContext context, String sourceName, Location location, File file, Map<Name, Property> properties) throws RepositorySourceException {
        return this.write(this.propertiesFileFor(file), context, properties);
    }

    @Override
    public Set<Name> recordFileProperties(ExecutionContext context, String sourceName, Location location, File file, Map<Name, Property> properties) throws RepositorySourceException {
        return this.write(this.propertiesFileFor(file), context, properties);
    }

    @Override
    public Set<Name> recordResourceProperties(ExecutionContext context, String sourceName, Location location, File file, Map<Name, Property> properties) throws RepositorySourceException {
        return this.write(this.propertiesFileForResource(file), context, properties);
    }

    @Override
    public File propertiesFileForFile(File file) {
        return this.propertiesFileFor(file);
    }

    @Override
    public File propertiesFileForFolder(File folder) {
        return this.propertiesFileFor(folder);
    }

    @Override
    public File propertiesFileForResource(File fileOrDirectory) {
        return new File(fileOrDirectory.getPath() + this.resourceExtension);
    }

    protected File propertiesFileFor(File fileOrDirectory) {
        return new File(fileOrDirectory.getPath() + this.extension);
    }

    protected Map<Name, Property> load(File propertiesFile, ExecutionContext context) throws RepositorySourceException {
        if (!propertiesFile.exists() || !propertiesFile.canRead()) {
            return NO_PROPERTIES_MAP;
        }
        try {
            String content = IoUtil.read((File)propertiesFile);
            ValueFactories factories = context.getValueFactories();
            NamespaceRegistry namespaces = context.getNamespaceRegistry();
            PropertyFactory propFactory = context.getPropertyFactory();
            HashMap<Name, Property> result = new HashMap<Name, Property>();
            for (String line : StringUtil.splitLines((String)content)) {
                Property property = this.parse(line, factories, propFactory, namespaces, result);
                if (property == null) continue;
                result.put(property.getName(), property);
            }
            return result;
        }
        catch (IOException e) {
            throw new RepositorySourceException(this.sourceName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Name> write(File propertiesFile, ExecutionContext context, Map<Name, Property> properties) throws RepositorySourceException {
        if (properties.isEmpty()) {
            if (propertiesFile.exists()) {
                propertiesFile.delete();
            }
            return Collections.emptySet();
        }
        HashSet<Name> names = new HashSet<Name>();
        try {
            ValueFactory strings = context.getValueFactories().getStringFactory();
            FileWriter fileWriter = new FileWriter(propertiesFile);
            try {
                Property uuid;
                Property mixinTypes;
                Property primaryType = properties.get(JcrLexicon.PRIMARY_TYPE);
                if (primaryType != null) {
                    this.write(primaryType, fileWriter, (ValueFactory<String>)strings);
                    names.add(primaryType.getName());
                }
                if ((mixinTypes = properties.get(JcrLexicon.MIXIN_TYPES)) != null) {
                    this.write(mixinTypes, fileWriter, (ValueFactory<String>)strings);
                    names.add(mixinTypes.getName());
                }
                if ((uuid = properties.get(JcrLexicon.UUID)) != null) {
                    this.write(uuid, fileWriter, (ValueFactory<String>)strings);
                    names.add(uuid.getName());
                }
                for (Property property : properties.values()) {
                    if (property == primaryType || property == mixinTypes || property == uuid) continue;
                    this.write(property, fileWriter, (ValueFactory<String>)strings);
                    names.add(property.getName());
                }
            }
            finally {
                ((Writer)fileWriter).close();
            }
        }
        catch (IOException e) {
            throw new RepositorySourceException(this.sourceName, (Throwable)e);
        }
        return names;
    }

    protected void write(Property property, Writer stream, ValueFactory<String> strings) throws IOException {
        String name = (String)strings.create(property.getName());
        stream.append(this.encoder.encode(name));
        if (property.isEmpty()) {
            stream.append('\n');
            stream.flush();
            return;
        }
        stream.append(" (");
        PropertyType type = PropertyType.discoverType((Object)property.getFirstValue());
        stream.append(type.getName().toLowerCase());
        stream.append(") ");
        if (property.isMultiple()) {
            stream.append('[');
        }
        boolean first = true;
        boolean quote = type == PropertyType.STRING;
        for (Object value : property) {
            if (first) {
                first = false;
            } else {
                stream.append(", ");
            }
            String str = null;
            str = value instanceof Binary ? StringUtil.getHexString((byte[])((Binary)value).getBytes()) : (String)strings.create(value);
            if (quote) {
                stream.append('\"');
                stream.append(this.quoter.encode(str));
                stream.append('\"');
                continue;
            }
            stream.append(str);
        }
        if (property.isMultiple()) {
            stream.append(']');
        }
        stream.append('\n');
        stream.flush();
    }

    protected Property parse(String line, ValueFactories factories, PropertyFactory propFactory, NamespaceRegistry namespaces, Map<Name, Property> result) {
        if (line.length() == 0) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == ' ') {
            return null;
        }
        Matcher matcher = PROPERTY_PATTERN.matcher(line);
        NameFactory nameFactory = factories.getNameFactory();
        if (!matcher.matches()) {
            Name name = (Name)nameFactory.create(this.decoder.decode(line));
            return propFactory.create(name, new Object[0]);
        }
        String nameString = this.decoder.decode(matcher.group(1));
        String typeString = matcher.group(2);
        String valuesString = matcher.group(4);
        Name name = null;
        try {
            name = (Name)factories.getNameFactory().create(nameString);
        }
        catch (ValueFormatException e) {
            if (nameString.indexOf(58) < nameString.lastIndexOf(58)) {
                LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
                prefixes.add("jcr");
                for (NamespaceRegistry.Namespace namespace : namespaces.getNamespaces()) {
                    prefixes.add(namespace.getPrefix());
                }
                for (String prefix : prefixes) {
                    int index = nameString.lastIndexOf(prefix + ":");
                    if (index <= 0) continue;
                    name = (Name)nameFactory.create(nameString.substring(0, index));
                    result.put(name, propFactory.create(name, new Object[0]));
                    name = (Name)nameFactory.create(nameString.substring(index));
                }
            }
            throw e;
        }
        PropertyType type = PropertyType.valueFor((String)typeString);
        Pattern pattern = VALUE_PATTERN;
        ValueFactory valueFactory = factories.getValueFactory(type);
        boolean binary = false;
        boolean decode = false;
        if (type == PropertyType.STRING) {
            pattern = STRING_VALUE_PATTERN;
            decode = true;
        } else if (type == PropertyType.BINARY) {
            binary = true;
        }
        Matcher valuesMatcher = pattern.matcher(valuesString);
        ArrayList<Object> values = new ArrayList<Object>();
        while (valuesMatcher.find()) {
            String valueString = valuesMatcher.group(1);
            if (binary) {
                byte[] binaryValue = StringUtil.fromHexString((String)valueString);
                Object value = valueFactory.create(binaryValue);
                values.add(value);
                continue;
            }
            if (decode) {
                valueString = this.quoter.decode(valueString);
            }
            Object value = valueFactory.create(valueString);
            values.add(value);
        }
        if (values.isEmpty()) {
            return null;
        }
        return propFactory.create(name, type, values);
    }
}

