/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.util.FileUtil;
import org.modeshape.test.ModeShapeSingleUseTest;

public class DiskRepositoryTest
extends ModeShapeSingleUseTest {
    private static final String REPOSITORY_NAME = "Repo";
    private static final String DEFAULT_WS_NAME = "default";
    private static final String OTHER_WS_NAME = "otherWorkspace";

    public void beforeEach() throws Exception {
        File repositoryFolder = new File("target/database/ConfigurationTest/files");
        if (repositoryFolder.exists()) {
            Assert.assertTrue((boolean)FileUtil.delete((File)repositoryFolder));
        }
        super.beforeEach();
        this.engine();
    }

    public void afterEach() throws Exception {
        DiskRepositoryTest.closeSessions();
        super.afterEach();
    }

    @Test
    @FixFor(value={"MODE-1298"})
    public void cloneBinaryContentIntoAnotherWorkspaceAndModifyOriginal() throws Exception {
        String firstDocumentPath = this.uploadDocument("diskstore/duke.png");
        String secondDocumentPath = this.uploadDocument("diskstore/nasa.pdf");
        this.cloneDocument(firstDocumentPath);
        this.assertClonedContent(firstDocumentPath, true);
        this.cloneDocument(secondDocumentPath);
        this.assertClonedContent(secondDocumentPath, true);
        this.changeOrDeleteContent(firstDocumentPath, "dummyContent");
        this.assertClonedContent(firstDocumentPath, false);
        this.changeOrDeleteContent(secondDocumentPath, null);
        this.assertClonedContent(secondDocumentPath, false);
        DiskRepositoryTest.closeSessions();
        DiskRepositoryTest.stopEngine();
        this.engine();
        this.assertClonedContent(firstDocumentPath, false);
        this.assertClonedContent(secondDocumentPath, false);
    }

    private void cloneDocument(String documentPath) throws Exception {
        Session otherSession = this.sessionTo(REPOSITORY_NAME, OTHER_WS_NAME);
        otherSession.getWorkspace().clone(DEFAULT_WS_NAME, documentPath, documentPath, true);
        otherSession.logout();
    }

    private void changeOrDeleteContent(String documentPath, String dummyContent) throws Exception {
        Session defaultSession = this.session();
        if (dummyContent != null) {
            Node document = defaultSession.getNode(documentPath);
            Binary updatedDocumentContent = defaultSession.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(dummyContent.getBytes()));
            document.setProperty("jcr:data", updatedDocumentContent);
        } else {
            defaultSession.removeItem(documentPath);
        }
        defaultSession.save();
    }

    private String uploadDocument(String path) throws Exception {
        Session defaultSession = this.session();
        Node document = defaultSession.getRootNode().addNode("document_" + UUID.randomUUID().toString());
        Binary documentContent = defaultSession.getValueFactory().createBinary(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path));
        document.setProperty("jcr:data", documentContent);
        String documentPath = document.getPath();
        defaultSession.save();
        defaultSession.logout();
        return documentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertClonedContent(String documentAbsPath, boolean shouldBeSame) throws RepositoryException {
        long originalSize = 0L;
        Session defaultSession = this.sessionTo(REPOSITORY_NAME, DEFAULT_WS_NAME);
        try {
            Node originalDocument = defaultSession.getNode(documentAbsPath);
            Binary originalBinaryValue = originalDocument.getProperty("jcr:data").getBinary();
            originalSize = originalBinaryValue.getSize();
        }
        catch (PathNotFoundException e) {
        }
        finally {
            defaultSession.logout();
        }
        Session otherSession = this.sessionTo(REPOSITORY_NAME, OTHER_WS_NAME);
        Node clonedDocument = otherSession.getNode(documentAbsPath);
        Binary clonedBinaryValue = clonedDocument.getProperty("jcr:data").getBinary();
        long clonedSize = clonedBinaryValue.getSize();
        otherSession.logout();
        if (shouldBeSame) {
            Assert.assertEquals((long)originalSize, (long)clonedSize);
        } else {
            Assert.assertTrue((originalSize != clonedSize ? 1 : 0) != 0);
        }
    }

    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForDiskStorage.xml";
    }
}

