/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import junit.framework.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.test.ModeShapeUnitTest;

public class InMemoryRepositoryTest
extends ModeShapeUnitTest {
    private JcrEngine engine = null;

    public void afterEach() throws Exception {
        super.afterEach();
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Test
    @FixFor(value={"MODE-1422"})
    public void shouldBeAbleToRemoveNodeWithSNSAfterRemovingIncomingReference() throws Exception {
        this.engine = this.startEngineUsing("memory/configRepositoryReferences.xml");
        Session session = this.engine.getRepository("cimRepo").login();
        Node root = session.getRootNode();
        Node t1 = root.addNode("testNode", "test:test");
        t1.setProperty("myAttribute", "1");
        Node t2 = root.addNode("testNode", "test:test");
        t2.setProperty("myAttribute", "2");
        Node t3 = root.addNode("testNode", "test:test");
        t3.setProperty("myAttribute", "3");
        t1.setProperty("ref", t2);
        t2.setProperty("ref", t1);
        session.save();
        String id1 = t1.getIdentifier();
        t1 = session.getNodeByIdentifier(id1);
        PropertyIterator pi = t1.getReferences();
        while (pi.hasNext()) {
            Property ref = pi.nextProperty();
            ref.remove();
        }
        t1.remove();
        session.save();
    }

    @Test
    @FixFor(value={"MODE-1553"})
    public void shouldStoreJcrUUIDPropertyForReferenceableNodes() throws Exception {
        this.engine = this.startEngineUsing("memory/configRepositoryReferences.xml");
        Session session = this.engine.getRepository("cimRepo").login();
        Node node = session.getRootNode().addNode("test", "test:second");
        node.setProperty("myAttribute", "Well");
        Node node2 = session.getRootNode().addNode("test", "test:test");
        node2.setProperty("myAttribute", "Well");
        node2.setProperty("second", node);
        Node node3 = session.getRootNode().addNode("test", "test:test");
        node3.setProperty("myAttribute", "Well");
        node3.setProperty("second", node);
        ArrayList<Object> refs = new ArrayList<Object>();
        refs.add(session.getValueFactory().createValue(node2, false));
        refs.add(session.getValueFactory().createValue(node3, false));
        node.setProperty("testEntities", refs.toArray(new Value[refs.size()]));
        session.save();
        String stmt = "SELECT a.a AS * FROM [test:test] AS a INNER JOIN [test:second] AS second ON a.second = second.[jcr:uuid]";
        Query q = session.getWorkspace().getQueryManager().createQuery(stmt, "JCR-SQL2");
        QueryResult qr = q.execute();
        Assert.assertEquals((long)qr.getRows().getSize(), (long)2L);
        Property p = node.getProperty("testEntities");
        Value[] values = p.getValues();
        Assert.assertEquals((int)2, (int)values.length);
        Node node4 = session.getRootNode().addNode("test", "test:test");
        node4.setProperty("myAttribute", "testVal");
        node4.setProperty("second", node);
        Node node5 = session.getRootNode().addNode("test", "test:test");
        node5.setProperty("myAttribute", "testVal");
        node5.setProperty("second", node);
        ArrayList<Value> refs2 = new ArrayList<Value>();
        refs2.add(session.getValueFactory().createValue(node4, false));
        refs2.add(session.getValueFactory().createValue(node5, false));
        refs.addAll(refs2);
        p = node.setProperty("testEntities", refs.toArray(new Value[refs.size()]));
        Assert.assertEquals((int)4, (int)p.getValues().length);
        session.save();
        Assert.assertEquals((int)4, (int)node.getProperty("testEntities").getValues().length);
        qr = q.execute();
        Assert.assertEquals((long)4L, (long)qr.getRows().getSize());
    }

    @Test
    @FixFor(value={"MODE-1490"})
    public void shouldAllowMultipleOrderBeforeWithoutSave() throws Exception {
        this.engine = this.startEngineUsing("memory/configEmptyRepository.xml");
        Session session = this.engine.getRepository("testRepo").login();
        int childCount = 2;
        Node parent = session.getRootNode().addNode("parent", "nt:unstructured");
        for (int i = 0; i < childCount; ++i) {
            parent.addNode("Child " + i, "nt:unstructured");
        }
        session.save();
        long childIdx = 0L;
        NodeIterator nodeIterator = parent.getNodes();
        while (nodeIterator.hasNext()) {
            parent.orderBefore("Child " + childIdx, "Child 0");
            ++childIdx;
            nodeIterator.nextNode();
        }
        session.save();
        nodeIterator = parent.getNodes();
        childIdx = nodeIterator.getSize() - 1L;
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            Assert.assertEquals((String)("Child " + childIdx), (String)child.getName());
            --childIdx;
        }
    }
}

