/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.federation;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.test.ModeShapeSingleUseTest;

public class FederationConnectorQueryTest
extends ModeShapeSingleUseTest {
    private static final Credentials SUPERUSER_CREDENTIALS = new SimpleCredentials("superuser", "superuser".toCharArray());
    private Session session;

    public void beforeEach() throws Exception {
        super.beforeEach();
        this.session = this.sessionTo("My repository", "default", SUPERUSER_CREDENTIALS);
    }

    public void afterEach() throws Exception {
        super.afterEach();
    }

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas((String)"security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForFederatedSearch.xml";
    }

    @Test
    @FixFor(value={"MODE-1238"})
    public void shouldUpdateQueryIndex() throws Exception {
        Node root = this.session.getRootNode();
        Assert.assertNotNull((Object)root);
        Node testNode = this.session.itemExists("/inmemory1") ? this.session.getNode("/inmemory1").addNode("testNode", "{http://www.jcp.org/jcr/nt/1.0}unstructured") : root.addNode("/inmemory1", "{http://www.jcp.org/jcr/nt/1.0}unstructured").addNode("testNode", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
        testNode.setProperty("prop", "Hello World");
        this.session.save();
        QueryManager qm = this.session.getWorkspace().getQueryManager();
        Query query = qm.createQuery("select * from [nt:unstructured] where prop = 'Hello World'", "JCR-SQL2");
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        junit.framework.Assert.assertEquals((long)1L, (long)iter.getSize());
        Node foundNode = iter.nextNode();
        junit.framework.Assert.assertEquals((String)testNode.getPath(), (String)foundNode.getPath());
    }
}

