/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.federation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problem;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class FederationIspnConnectorRepositoryTest {
    private static JcrConfiguration configuration;
    private static JcrEngine engine;
    private static List<Session> sessions;
    private boolean print = false;

    @BeforeClass
    public static void beforeAll() throws Exception {
        configuration = new JcrConfiguration();
        configuration.loadFrom("src/test/resources/config/configRepositoryForFederatedInfinispan.xml");
        engine = configuration.build();
        try {
            engine.start(true);
        }
        catch (RuntimeException e) {
            System.err.println("There were problems starting the engine:");
            for (Problem problem : engine.getProblems()) {
                System.err.println(problem);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void afterAll() throws Exception {
        for (Session session : sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        sessions.clear();
        if (engine != null) {
            try {
                engine.shutdown();
            }
            finally {
                engine = null;
            }
        }
    }

    @Before
    public void beforeEach() {
        this.print = true;
    }

    void printNodes(Node node, int indent) throws RepositoryException {
        if (!this.print) {
            return;
        }
        NodeIterator i = node.getNodes();
        while (i.hasNext()) {
            Node child = i.nextNode();
            for (int j = 0; j < indent * 4; ++j) {
                System.out.print(' ');
            }
            System.out.println(child);
            if ("jcr:system".equals(child.getName())) continue;
            this.printNodes(child, indent + 1);
        }
    }

    void print(String msg) {
        if (this.print) {
            System.out.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-1256"})
    public void shouldCreateContent() throws Throwable {
        JcrRepository repository = engine.getRepository("test-inmemory");
        Session session = repository.login("default");
        sessions.add(session);
        this.print = false;
        session.getRootNode().addNode("a");
        session.getRootNode().addNode("a/b");
        session.save();
        this.printNodes(session.getRootNode(), 0);
        session.logout();
        repository = engine.getRepository("test-infinispan");
        session = repository.login("default");
        sessions.add(session);
        session.getRootNode().addNode("x");
        session.getRootNode().addNode("x/y");
        session.getRootNode().addNode("x/z");
        session.save();
        this.printNodes(session.getRootNode(), 0);
        session.logout();
        repository = engine.getRepository("test-federated");
        session = repository.login("default");
        this.print("\nBefore move");
        this.printNodes(session.getRootNode(), 0);
        session.getNode("/jcr:system");
        session.getNode("/inmemory");
        session.getNode("/inmemory/b");
        session.getNode("/infinispan");
        session.getNode("/infinispan/y");
        session.getNode("/infinispan/z");
        session.logout();
        session = repository.login("default");
        session.move("/infinispan/y", "/infinispan/newY");
        this.print("\nAfter move, before save");
        this.printNodes(session.getRootNode(), 0);
        Throwable unexpected = null;
        try {
            session.save();
            this.print("\nAfter move, after save");
            this.printNodes(session.getRootNode(), 0);
        }
        catch (Throwable t) {
            unexpected = t;
        }
        finally {
            session.logout();
        }
        session = repository.login("default");
        session.getNode("/infinispan").addNode("newNode", "nt:unstructured");
        session.save();
        this.print("\nAfter adding '/infinispan/newNode' and saving");
        this.printNodes(session.getRootNode(), 0);
        session.logout();
        if (unexpected != null) {
            throw unexpected;
        }
    }

    static {
        sessions = new ArrayList<Session>();
    }
}

