/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.filesystem;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problem;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrTools;
import org.modeshape.test.integration.filesystem.FileSystemRepositoryWriteTest;

public class FileSystemRepositoryDeleteTest {
    private static final String TEST_REPOSITORY = "Test Repository Source";
    private static final String TEST_WORKSPACE = "defaultWorkspace";
    private JcrConfiguration configuration;
    private JcrEngine engine;
    private List<Session> sessions = new ArrayList<Session>();
    private boolean print = false;
    private JcrTools tools;

    protected Session sessionFrom(JcrEngine engine) throws RepositoryException {
        JcrRepository repository = engine.getRepository(TEST_REPOSITORY);
        Session session = repository.login(TEST_WORKSPACE);
        this.sessions.add(session);
        return session;
    }

    @Before
    public void beforeAll() throws Exception {
        this.print = false;
        FileSystemRepositoryWriteTest.setupFileSystem("target/test/repository/deletefilesystem", TEST_WORKSPACE, "otherWorkspace");
        this.configuration = new JcrConfiguration();
        this.configuration.loadFrom("src/test/resources/config/configRepositoryForPropertyStoreModifiable.xml");
        this.engine = this.configuration.build();
        try {
            this.engine.start();
        }
        catch (RuntimeException e) {
            System.err.println("There were problems starting the engine:");
            for (Problem problem : this.engine.getProblems()) {
                System.err.println(problem);
            }
            throw e;
        }
        this.tools = new JcrTools();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterAll() throws Exception {
        for (Session session : this.sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        this.sessions.clear();
        if (this.engine != null) {
            try {
                this.engine.shutdown();
            }
            finally {
                this.engine = null;
            }
        }
    }

    @Test
    @FixFor(value={"MODE-927"})
    public void testCreateAndDeleteANode() throws Exception {
        Session session = this.sessionFrom(this.engine);
        session.getRootNode().addNode("folderA", "nt:folder");
        session.save();
        this.tools.uploadFile(session, "folderA/log4J.properties", FileSystemRepositoryWriteTest.resourceUrl("log4j.properties"));
        session.save();
        session.getNode("/folderA/log4J.properties").remove();
    }
}

