/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.filesystem;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Future;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.JcrTools;
import org.modeshape.jcr.api.Workspace;
import org.modeshape.test.ModeShapeSingleUseTest;

public class FileSystemRepositoryIntegrationTest
extends ModeShapeSingleUseTest {
    protected static final String README_RESOURCE_PATH = "svn/local_repos/dummy_svn_repos/README.txt";
    protected static final String MODETEST_URL = "http://modeshape.org/test";

    public void beforeEach() throws Exception {
        FileUtil.delete((String)"target/fsRepoWithProps");
        new File("target/fsRepoWithProps/root").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder2").mkdirs();
        super.beforeEach();
    }

    @Test
    public void shouldAllowCreatingReferenceToContentNode() throws Exception {
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        this.addPointableMixin();
        Session session = this.session();
        Node root = session.getRootNode();
        root.addNode("A", "nt:folder");
        Node meta = root.addNode("meta", "nt:folder");
        meta.addMixin("modetest:pointable");
        Node readme = this.uploadFile(README_RESOURCE_PATH, "/A");
        Node content = readme.getNode("jcr:content");
        content.addMixin("mix:referenceable");
        meta.setProperty("contentPointer", content);
        Node referenced = meta.getProperty("contentPointer").getNode();
        Assert.assertThat((Object)referenced.getPath(), (Matcher)Is.is((Object)content.getPath()));
        Assert.assertThat((Object)referenced, (Matcher)Is.is((Object)content));
        session.save();
        this.logout();
        session = this.session();
        root = session.getRootNode();
        meta = root.getNode("meta");
        content = root.getNode("A/README.txt/jcr:content");
        referenced = meta.getProperty("contentPointer").getNode();
        Assert.assertThat((Object)referenced.getPath(), (Matcher)Is.is((Object)content.getPath()));
        Assert.assertThat((Object)referenced, (Matcher)Is.is((Object)content));
    }

    @Test
    @FixFor(value={"MODE-1281"})
    public void shouldAllowCreatingVersionableNodes() throws Exception {
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        Session session = this.session();
        Node root = session.getRootNode();
        root.addNode("A", "nt:folder");
        Node meta = root.addNode("meta", "nt:folder");
        meta.addMixin("mix:versionable");
        session.save();
        session.getWorkspace().getVersionManager().checkin(meta.getPath());
        this.logout();
        session = this.session();
        root = session.getRootNode();
        meta = root.getNode("meta");
        Property predecessors = meta.getProperty("jcr:predecessors");
        Assert.assertThat((Object)predecessors.isMultiple(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)predecessors.getValues().length, (Matcher)Is.is((Object)0));
    }

    @Test
    @FixFor(value={"MODE-1221"})
    public void shouldFindAllNodesWhenQueryingContent() throws Exception {
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        Session session = this.session();
        Node root = session.getRootNode();
        root.addNode("A", "nt:folder");
        root.addNode("meta", "nt:folder");
        Node readme = this.uploadFile(README_RESOURCE_PATH, "/A");
        Node content = readme.getNode("jcr:content");
        content.addMixin("mix:referenceable");
        session.save();
        this.logout();
        session = this.session();
        this.printQuery("SELECT * FROM [nt:base]", 7L, Collections.emptyMap());
    }

    @Test(expected=RepositoryException.class)
    @FixFor(value={"MODE-1249"})
    public void shouldThrowExceptionIfPathExceedsMaxLength() throws Exception {
        this.startEngineUsing("config/configRepositoryForFileSystemPropValidation.xml");
        Session session = this.session();
        Node root = session.getRootNode();
        root.addNode("A", "nt:folder");
        root.addNode("meta", "nt:folder");
        Node readme = this.uploadFile(README_RESOURCE_PATH, "/A");
        Node content = readme.getNode("jcr:content");
        content.addMixin("mix:referenceable");
        session.save();
        this.logout();
    }

    @Test
    @FixFor(value={"MODE-1263"})
    public void shouldIncludeExistingContent() throws Exception {
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        Session session = this.session();
        session.getRootNode().addNode("NewFolder", "nt:folder");
        session.save();
        this.printQuery("SELECT * FROM [nt:base]", 4L, Collections.emptyMap());
        this.logout();
    }

    @Test
    @FixFor(value={"MODE-1269"})
    public void shouldAllowReindexingAllContent() throws Exception {
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        Session session = this.session();
        Workspace workspace = (Workspace)session.getWorkspace();
        workspace.reindex();
        this.printQuery("SELECT * FROM [nt:base]", 3L, Collections.emptyMap());
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1/file.txt").createNewFile();
        this.printQuery("SELECT * FROM [nt:base]", 3L, Collections.emptyMap());
        workspace.reindex();
        this.printQuery("SELECT * FROM [nt:base]", 6L, Collections.emptyMap());
        this.logout();
    }

    @Test
    @FixFor(value={"MODE-1269"})
    public void shouldAllowReindexingAllContentAsynchronously() throws Exception {
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        Session session = this.session();
        Workspace workspace = (Workspace)session.getWorkspace();
        Future future = workspace.reindexAsync();
        Assert.assertThat(future.get(), (Matcher)Is.is((Object)true));
        this.printQuery("SELECT * FROM [nt:base]", 3L, Collections.emptyMap());
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1/file.txt").createNewFile();
        this.printQuery("SELECT * FROM [nt:base]", 3L, Collections.emptyMap());
        future = workspace.reindexAsync();
        Assert.assertThat(future.get(), (Matcher)Is.is((Object)true));
        this.printQuery("SELECT * FROM [nt:base]", 6L, Collections.emptyMap());
        this.logout();
    }

    @Test
    @FixFor(value={"MODE-1269"})
    public void shouldAllowReindexingSubgraph() throws Exception {
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/file.txt").createNewFile();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder2").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1/file.txt").createNewFile();
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        Session session = this.session();
        Workspace workspace = (Workspace)session.getWorkspace();
        workspace.reindex("/folder1");
        this.printQuery("SELECT * FROM [nt:base] ORDER BY [jcr:path]", 9L, Collections.emptyMap());
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder3").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder3/file3.txt").createNewFile();
        this.printQuery("SELECT * FROM [nt:base] ORDER BY [jcr:path]", 9L, Collections.emptyMap());
        workspace.reindex("/folder1");
        this.printQuery("SELECT * FROM [nt:base] ORDER BY [jcr:path]", 12L, Collections.emptyMap());
        File newName = new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder4");
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder3").renameTo(newName);
        this.printQuery("SELECT * FROM [nt:base] ORDER BY [jcr:path]", 12L, Collections.emptyMap());
        workspace.reindex("/folder1");
        this.printQuery("SELECT * FROM [nt:base] ORDER BY [jcr:path]", 12L, Collections.emptyMap());
        this.logout();
    }

    @Test
    @FixFor(value={"MODE-1269"})
    public void shouldAllowReindexingSubgraphAsynchronously() throws Exception {
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/file.txt").createNewFile();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder2").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder1/file.txt").createNewFile();
        this.startEngineUsing("config/configRepositoryForFileSystemWithExtraProperties.xml");
        Session session = this.session();
        Workspace workspace = (Workspace)session.getWorkspace();
        Future future = workspace.reindexAsync("/folder1");
        Assert.assertThat(future.get(), (Matcher)Is.is((Object)true));
        this.printQuery("SELECT * FROM [nt:base]", 9L, Collections.emptyMap());
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder3").mkdirs();
        new File("target/fsRepoWithProps/root/defaultWorkspace/folder1/subfolder3/file3.txt").createNewFile();
        this.printQuery("SELECT * FROM [nt:base]", 9L, Collections.emptyMap());
        future = workspace.reindexAsync("/folder1");
        Assert.assertThat(future.get(), (Matcher)Is.is((Object)true));
        this.printQuery("SELECT * FROM [nt:base]", 12L, Collections.emptyMap());
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-1483"})
    public void shouldRemoveExtraFilesCreatedWhenStoringAdditionalProperties() throws Exception {
        File repositoryRoot = new File("./target/fileSystemSource");
        try {
            if (!repositoryRoot.exists() || !repositoryRoot.isDirectory()) {
                Assert.assertTrue((boolean)repositoryRoot.mkdir());
            }
            this.startEngineUsing("config/configRepositoryForFileSystem_MODE1483.xml");
            Session session = this.session();
            JcrTools jcrTools = new JcrTools();
            String resourcePath = "filesystem/workspace1/TestFile.txt";
            Node fileUnderRoot = jcrTools.uploadFile(session, "test.file", ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath));
            Node folder = this.session().getRootNode().addNode("folder", "nt:folder");
            jcrTools.uploadFile(session, "/folder/file1", ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath));
            jcrTools.uploadFile(session, "/folder/file2", ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath));
            session.save();
            fileUnderRoot = session.getNode("/test.file");
            jcrTools.removeAllChildren(fileUnderRoot);
            PropertyIterator pIt = fileUnderRoot.getProperties();
            while (pIt.hasNext()) {
                Property property = pIt.nextProperty();
                property.remove();
            }
            fileUnderRoot.remove();
            folder.remove();
            session.save();
            File workspaceRoot = new File("./target/fileSystemSource/" + session.getWorkspace().getName());
            Assert.assertTrue((workspaceRoot.list().length == 0 ? 1 : 0) != 0);
        }
        finally {
            FileUtil.delete((File)repositoryRoot);
        }
    }

    protected void registryNamespaceIfMissing(String prefix, String url) throws RepositoryException {
        NamespaceRegistry registry = this.session().getWorkspace().getNamespaceRegistry();
        try {
            registry.getURI(prefix);
        }
        catch (NamespaceException e) {
            registry.registerNamespace(prefix, url);
        }
    }

    protected void addPointableMixin() throws RepositoryException {
        this.registryNamespaceIfMissing("modetest", MODETEST_URL);
        String typeName = "modetest:pointable";
        NodeTypeManager mgr = this.session().getWorkspace().getNodeTypeManager();
        try {
            mgr.getNodeType(typeName);
        }
        catch (NoSuchNodeTypeException e) {
            PropertyDefinitionTemplate anySinglePropertyDefn = mgr.createPropertyDefinitionTemplate();
            anySinglePropertyDefn.setName("*");
            anySinglePropertyDefn.setRequiredType(9);
            anySinglePropertyDefn.setMultiple(false);
            NodeTypeTemplate type = mgr.createNodeTypeTemplate();
            type.setName(typeName);
            type.setMixin(true);
            type.getPropertyDefinitionTemplates().add(anySinglePropertyDefn);
            mgr.registerNodeType((NodeTypeDefinition)type, false);
        }
    }
}

