/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.infinispan;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.test.ModeShapeSingleUseTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Ignored because it takes way too long. If needed in the context of a bug, activate it")
public class InfinispanNonClusteredTest
extends ModeShapeSingleUseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanNonClusteredTest.class);
    private static final int FILES_COUNT = 50;
    private static final int MAX_THREADS = 150;
    private static final int THREADS_INCREMENT = 10;
    private static final int REPEAT_COUNT_PER_THREAD = 5;
    private static final long WAIT_AFTER_OPERATION_MILLIS = 10L;
    private static final Random RANDOM = new Random();
    private ExecutorService executorService;

    public void beforeEach() throws Exception {
        super.beforeEach();
        this.executorService = Executors.newCachedThreadPool();
    }

    public void afterEach() throws Exception {
        super.afterEach();
        this.executorService.shutdownNow();
    }

    @Test
    @FixFor(value={"MODE-1403"})
    public void shouldPerformMultiThreadedReadCopy() throws Exception {
        this.addFilesToRepository(50);
        int iterationsNr = 15;
        int threadsPerBatch = 1;
        CopyRandomFileOperation copyRandomFileOperation = new CopyRandomFileOperation(5);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        for (int i = 0; i < iterationsNr; ++i) {
            List<CopyRandomFileOperation> jobs = this.jobsList(threadsPerBatch, copyRandomFileOperation);
            List futures = this.executorService.invokeAll(jobs);
            for (Future future : futures) {
                future.get();
            }
            threadsPerBatch += 10;
        }
        stopwatch.stop();
        LOGGER.debug("Total duration: {}", (Object)stopwatch.getTotalDuration().getDurationInSeconds());
    }

    private <T extends Callable<?>> List<T> jobsList(int elementsCount, T job) {
        ArrayList<T> result = new ArrayList<T>(elementsCount);
        for (int i = 0; i < elementsCount; ++i) {
            result.add(job);
        }
        return result;
    }

    private void addFilesToRepository(int count) throws RepositoryException {
        Session session = this.sessionTo(null, null);
        for (int i = 0; i < count; ++i) {
            this.addFileWithContent(session, "file_" + i, null);
        }
        session.save();
        session.logout();
    }

    private void addFileWithContent(Session session, String filepath, InputStream contentStream) throws RepositoryException {
        Node fileContent = session.getRootNode().addNode(filepath).addNode("jcr:content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        if (contentStream == null) {
            contentStream = new ByteArrayInputStream("test_content".getBytes());
        }
        fileContent.setProperty("jcr:data", session.getValueFactory().createBinary(contentStream));
    }

    protected String getPathToDefaultConfiguration() {
        return "infinispan/configRepositoryNonClustered.xml";
    }

    private class CopyRandomFileOperation
    implements Callable<Void> {
        private int repeatCount;

        private CopyRandomFileOperation(int repeatCount) {
            this.repeatCount = repeatCount;
        }

        @Override
        public Void call() throws Exception {
            String threadName = Thread.currentThread().getName();
            Session session = InfinispanNonClusteredTest.this.sessionTo(null, null);
            for (int i = 0; i < this.repeatCount; ++i) {
                LOGGER.debug("{} iteration: {}", (Object)threadName, (Object)i);
                int fileIndex = RANDOM.nextInt(50);
                Node fileContent = session.getNode("/file_" + fileIndex + "/jcr:content");
                Binary contentStream = fileContent.getProperty("jcr:data").getBinary();
                Assert.assertNotNull((Object)contentStream);
                InfinispanNonClusteredTest.this.addFileWithContent(session, "file_" + i + "_copy", contentStream.getStream());
                session.save();
                Thread.sleep(10L);
            }
            session.logout();
            return null;
        }
    }
}

