/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class TextSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForTextSequencing.xml";
    }

    @Test
    public void shouldSequenceDelimitedTextFile() throws Exception {
        this.uploadFile("sequencers/text/delimitedFile.csv", "/files/");
        String path = "/sequenced/delimitedFile.csv";
        Node rootNode = this.waitUntilSequencedNodeIsAvailable(path, "nt:unstructured", new String[0]);
        String[] expectedColumnValues = new String[]{"foo", "bar", "baz"};
        for (int rowIdx = 0; rowIdx < 6; ++rowIdx) {
            this.assertRowWithColumns(path, rowIdx, expectedColumnValues);
        }
        this.printOutput(rootNode);
    }

    private void printOutput(Node rootNode) throws RepositoryException {
        this.printSubgraph(rootNode);
    }

    private void assertRowWithColumns(String rootPath, int rowIndex, String[] columnData) throws Exception {
        String rowPath = rootPath + "/text:row[" + (rowIndex + 1) + "]";
        this.assertNode(rowPath, "nt:unstructured", new String[]{"mode:derived"});
        for (int i = 0; i < columnData.length; ++i) {
            String columnPath = rowPath + "/text:column[" + (i + 1) + "]";
            Node column = this.assertNode(columnPath, "nt:unstructured", new String[]{"text:column"});
            this.assertSingleValueProperty(column, "text:data", columnData[i]);
        }
    }
}

