/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class DdlSequencer2IntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForDdlSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    @FixFor(value={"MODE-1073"})
    public void shouldNotCreateExtraIntermediateNodesWhenUploadingAndSequencingMultipleFiles() throws Exception {
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/create_schema.ddl", "/files/a/b");
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/grant_test_statements.ddl", "/files/a/b");
        this.waitUntilSequencedNodeIsAvailable("/files", "nt:folder", new String[]{"mode:publishArea"});
        this.assertNode("/files/a", "nt:folder", new String[0]);
        this.assertNode("/files/a/b", "nt:folder", new String[0]);
        this.assertNode("/files/a/b/create_schema.ddl", "nt:file", new String[0]);
        this.assertNode("/files/a/b/create_schema.ddl/jcr:content", "nt:resource", new String[0]);
        this.assertNode("/files/a/b/grant_test_statements.ddl");
        this.assertNode("/files/a/b/grant_test_statements.ddl/jcr:content", "nt:resource", new String[0]);
        this.assertNode("/sequenced/ddl", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/ddl/a", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/ddl/a/b", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/ddl/a/b/create_schema.ddl");
        this.assertNode("/sequenced/ddl/a/b/grant_test_statements.ddl");
        this.assertNoNode("/sequenced/ddl[2]");
        this.assertNoNode("/sequenced/ddl/a[2]");
        this.assertNoNode("/sequenced/ddl/a/b[2]");
    }
}

