/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.svn;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public class SvnAndJcrIntegrationTest {
    private JcrEngine engine;
    private Session session;

    @Before
    public void beforeEach() throws Exception {
        String repositoryUrl = "http://anonsvn.jboss.org/repos/dna/";
        Object[] predefinedWorkspaceNames = new String[]{"trunk/dna-common/src/main/java/org/jboss/dna/common/xml"};
        String svnRepositorySource = "svnRepositorySource";
        String repositoryName = "svnRepository";
        JcrConfiguration configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("svnRepositorySource").usingClass(SvnRepositorySource.class)).setProperty("password", "")).setProperty("username", "anonymous")).setProperty("repositoryRootUrl", "http://anonsvn.jboss.org/repos/dna/")).setProperty("predefinedWorkspaceNames", predefinedWorkspaceNames)).setProperty("defaultWorkspaceName", (String)predefinedWorkspaceNames[0])).setProperty("creatingWorkspacesAllowed", false);
        configuration.repository("svnRepository").setSource("svnRepositorySource").setOption(JcrRepository.Option.QUERY_EXECUTION_ENABLED, "true");
        configuration.save();
        this.engine = configuration.build();
        this.engine.start();
        this.session = this.engine.getRepository("svnRepository").login();
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Test
    public void shouldIterateOverChildrenOfRoot() throws Exception {
        System.out.println("Getting the root node and it's children ...");
        NodeIterator nodeIterator = this.session.getRootNode().getNodes();
        while (nodeIterator.hasNext()) {
            System.out.println(nodeIterator.nextNode());
        }
        Assert.assertThat((Object)this.session.getRootNode().getNode("XmlCharacters.java"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldProvideAccessToJcrDataNodeUnderFileNode() throws Exception {
        System.out.println("Getting /package-info.java/jcr:content and then walking its properties ...");
        Node resourceNodeOfPomFile = this.session.getRootNode().getNode("package-info.java/jcr:content");
        Assert.assertThat((Object)resourceNodeOfPomFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        PropertyIterator iter = resourceNodeOfPomFile.getProperties();
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }
}

