/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.UUID;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.TestEnvironment;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.WritableConnectorTest;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ReferentialIntegrityException;

public class JpaConnectorWritingTest
extends WritableConnectorTest {
    private boolean isReferentialIntegrityEnforced = false;

    protected RepositorySource setUpSource() {
        JpaSource source = TestEnvironment.configureJpaSource("Test Repository", (Object)this);
        source.setLargeValueSizeInBytes(100L);
        source.setReferentialIntegrityEnforced(this.isReferentialIntegrityEnforced);
        source.setCompressData(true);
        return source;
    }

    protected void initializeContent(Graph graph) {
        if (!graph.getWorkspaces().contains("default")) {
            graph.createWorkspace().named("default");
        } else {
            graph.useWorkspace("default");
        }
    }

    @Test(expected=ReferentialIntegrityException.class)
    public void shouldNotCopyChildrenBetweenWorkspacesAndRemoveExistingNodesWithSameUuidIfSpecifiedIfReferentialIntegrityIsViolated() throws Exception {
        if (!this.isReferentialIntegrityEnforced) {
            throw new ReferentialIntegrityException(Location.create((UUID)UUID.randomUUID()), new Reference[0]);
        }
        String defaultWorkspaceName = this.graph.getCurrentWorkspaceName();
        String workspaceName = "copyChildrenSource";
        this.tryCreatingAWorkspaceNamed(workspaceName);
        this.graph.useWorkspace(workspaceName);
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, System.out, null);
        this.graph.useWorkspace(defaultWorkspaceName);
        this.graph.create("/newUuids").and();
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1").fromWorkspace(workspaceName)).as(this.name("node1"))).into("/newUuids")).replacingExistingNodesWithSameUuids();
        this.graph.create("/newUuids/node1/shouldBeRemoved").and();
        this.graph.create("/refererringNode").and();
        ((Graph.SetValuesTo)this.graph.set("refProp").on("/refererringNode")).to(this.graph.getNodeAt("/newUuids/node1/shouldBeRemoved"));
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1").fromWorkspace(workspaceName)).as(this.name("otherNode"))).into("/newUuids")).replacingExistingNodesWithSameUuids();
    }

    @Test
    @FixFor(value={"MODE-1071", "MODE-1066"})
    public void shouldSuccessfullyCollectGarbageOnePassAfterCreatingContentButNotDeletingAnyNodes() {
        String workspaceName = "copyChildrenSource";
        this.tryCreatingAWorkspaceNamed(workspaceName);
        this.graph.useWorkspace(workspaceName);
        String initialPath = "";
        int depth = 4;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 10;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.useLargeValues = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, System.out, null);
        int passes = 1;
        this.collectGarbage(passes);
    }

    @Test
    @FixFor(value={"MODE-1071", "MODE-1066"})
    public void shouldSuccessfullyCollectGarbageMultiplePassesAfterCreatingContentAndDeletingSome() {
        String workspaceName = "copyChildrenSource";
        this.tryCreatingAWorkspaceNamed(workspaceName);
        this.graph.useWorkspace(workspaceName);
        String initialPath = "";
        int depth = 4;
        int numChildrenPerNode = 6;
        int numPropertiesPerNode = 10;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.useLargeValues = true;
        this.useUniqueLargeValues = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, System.out, null);
        this.collectGarbage(1);
        this.graph.delete("/node2").and();
        int passes = 3;
        this.collectGarbage(passes);
    }
}

