/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.i18n.I18n;
import org.modeshape.connector.store.jpa.JpaConnectorI18n;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.Model;
import org.modeshape.graph.connector.RepositoryConnection;

public class ModelTest {
    private String validName;
    private I18n validDescription;
    private I18n validDescription2;
    private Model model1;
    private Model model2;
    private Model model3;
    @Mock
    private RepositoryConnection connection;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.validName = "Concrete Model";
        this.validDescription = JpaConnectorI18n.basicModelDescription;
        this.validDescription2 = JpaConnectorI18n.connectorName;
        this.model1 = new ConcreteModel(this.validName, this.validDescription);
        this.model2 = new ConcreteModel(this.validName, this.validDescription2);
        this.model3 = new ConcreteModel(this.validName + " ", this.validDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNameInConstructor() {
        new ConcreteModel(null, this.validDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyNameInConstructor() {
        new ConcreteModel("", this.validDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullDescriptionInConstructor() {
        new ConcreteModel(this.validName, null);
    }

    @Test
    public void shouldNotTrimName() {
        Assert.assertThat((Object)this.model3.getName(), (Matcher)Is.is((Object)(this.validName + " ")));
    }

    @Test
    public void shouldConsiderTwoModelsEqualIfTheyHaveTheSameName() {
        Assert.assertThat((Object)this.model1, (Matcher)Is.is((Object)this.model2));
    }

    @Test
    public void shouldConsiderTwoModelsNotEqualIfTheyHaveDifferentNames() {
        Assert.assertThat((Object)this.model1, (Matcher)Is.is((Matcher)IsNot.not((Object)this.model3)));
        Assert.assertThat((Object)this.model2, (Matcher)Is.is((Matcher)IsNot.not((Object)this.model3)));
    }

    protected class ConcreteModel
    extends Model {
        protected ConcreteModel(String name, I18n description) {
            super(name, description);
        }

        public Class<?>[] getEntityClasses() {
            return new Class[0];
        }

        public RepositoryConnection createConnection(JpaSource source) {
            return ModelTest.this.connection;
        }
    }
}

