/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.util;

import java.util.LinkedList;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.connector.store.jpa.util.RequestProcessorCache;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

public class RequestProcessorCacheTest {
    private RequestProcessorCache cache;
    private PathFactory pathFactory;
    private NameFactory nameFactory;
    private NamespaceRegistry namespaces;
    private Location location;
    private Location[] children;
    private LinkedList<Location> childrenList;
    private Location location2;
    private Location[] children2;
    private LinkedList<Location> childrenList2;
    private Long workspaceId;

    @Before
    public void beforeEach() {
        ExecutionContext context = new ExecutionContext();
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.nameFactory = context.getValueFactories().getNameFactory();
        this.namespaces = context.getNamespaceRegistry();
        this.cache = new RequestProcessorCache(this.pathFactory);
        this.workspaceId = 10L;
        Path parent = (Path)this.pathFactory.create("/a/b/c");
        this.location = Location.create((Path)parent, (UUID)UUID.randomUUID());
        this.children = new Location[]{Location.create((Path)this.pathFactory.create(parent, "d1"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, "d2"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, "d3"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, "d4"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("e"), 1), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("e"), 2), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("e"), 3), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("e"), 4), (UUID)UUID.randomUUID())};
        this.childrenList = new LinkedList();
        for (Location loc : this.children) {
            this.childrenList.add(loc);
        }
        parent = (Path)this.pathFactory.create("/a/b/c/e[2]");
        this.location2 = Location.create((Path)parent, (UUID)this.children[5].getUuid());
        this.children2 = new Location[]{Location.create((Path)this.pathFactory.create(parent, "f1"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, "f2"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, "f3"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, "f4"), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("g"), 1), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("g"), 2), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("g"), 3), (UUID)UUID.randomUUID()), Location.create((Path)this.pathFactory.create(parent, this.name("g"), 4), (UUID)UUID.randomUUID())};
        this.childrenList2 = new LinkedList();
        for (Location loc : this.children2) {
            this.childrenList2.add(loc);
        }
    }

    protected Path path(String name) {
        return (Path)this.pathFactory.create(name);
    }

    protected Name name(String name) {
        return (Name)this.nameFactory.create(name);
    }

    @Test
    public void shouldNotFindLocationForPathWhenEmpty() {
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindLocationForNullPath() {
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldFindLocationForPathAfterAdding() {
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.cache.addNewNode(this.workspaceId, this.location);
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.location)));
    }

    @Test
    public void shouldNotFindChildrenForPathEvenAfterLocationForSamePathIsAdded() {
        this.cache.addNewNode(this.workspaceId, this.location);
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.location)));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindChildrenForPathWhenEmpty() {
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindChildrenForNullPath() {
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldFindChildrenForPathAfterChildrenAreSet() {
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.cache.setAllChildren(this.workspaceId, this.location.getPath(), this.childrenList);
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsSame.sameInstance(this.childrenList)));
    }

    @Test
    public void shouldRemoveChildrenForPathIfSuppliedListIsNull() {
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.cache.setAllChildren(this.workspaceId, this.location.getPath(), this.childrenList);
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsSame.sameInstance(this.childrenList)));
        this.cache.setAllChildren(this.workspaceId, this.location.getPath(), null);
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldSetEmptyChildrenForPathIfSuppliedListIsEmpty() {
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        LinkedList emptyList = new LinkedList();
        this.cache.setAllChildren(this.workspaceId, this.location.getPath(), emptyList);
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Matcher)IsSame.sameInstance(emptyList)));
    }

    @Test
    public void shouldUpdateCacheWhenNodeIsMoved() {
        Location oldLocation = this.location2;
        Location newLocation = Location.create((Path)((Path)this.pathFactory.create("/a/b/c/d3/e[1]")));
        Assert.assertThat((Object)oldLocation.getPath().getString(this.namespaces), (Matcher)Is.is((Object)"/a/b/c/e[2]"));
        Assert.assertThat((Object)newLocation.getPath().getString(this.namespaces), (Matcher)Is.is((Object)"/a/b/c/d3/e"));
        this.cache.addNewNode(this.workspaceId, this.location);
        this.cache.addNewNode(this.workspaceId, this.location2);
        for (Location loc : this.children) {
            this.cache.addNewNode(this.workspaceId, loc);
        }
        for (Location loc : this.children2) {
            this.cache.addNewNode(this.workspaceId, loc);
        }
        this.cache.addNewNode(this.workspaceId, this.location);
        this.cache.addNewNode(this.workspaceId, this.location2);
        this.cache.setAllChildren(this.workspaceId, this.location.getPath(), this.childrenList);
        this.cache.setAllChildren(this.workspaceId, this.location2.getPath(), this.childrenList2);
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location2.getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children2));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, oldLocation.getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children2));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[5].getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children2));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Object)this.location));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location2.getPath()), (Matcher)Is.is((Object)this.location2));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, oldLocation.getPath()), (Matcher)Is.is((Object)oldLocation));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Object)this.children[0]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Object)this.children[1]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Object)this.children[2]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Object)this.children[3]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Object)this.children[4]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[5].getPath()), (Matcher)Is.is((Object)this.children[5]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Object)this.children[6]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[7].getPath()), (Matcher)Is.is((Object)this.children[7]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[0].getPath()), (Matcher)Is.is((Object)this.children2[0]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Object)this.children2[1]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Object)this.children2[2]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Object)this.children2[3]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Object)this.children2[4]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Object)this.children2[5]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Object)this.children2[6]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Object)this.children2[7]));
        Assert.assertThat((Object)this.cache.moveNode(this.workspaceId, oldLocation, -1, newLocation), (Matcher)Is.is((Object)true));
        LinkedList afterRemoval = this.cache.getAllChildren(this.workspaceId, this.location.getPath());
        Assert.assertThat(afterRemoval.get(0), (Matcher)Is.is((Object)this.children[0]));
        Assert.assertThat(afterRemoval.get(1), (Matcher)Is.is((Object)this.children[1]));
        Assert.assertThat(afterRemoval.get(2), (Matcher)Is.is((Object)this.children[2]));
        Assert.assertThat(afterRemoval.get(3), (Matcher)Is.is((Object)this.children[3]));
        Assert.assertThat(afterRemoval.get(4), (Matcher)Is.is((Object)this.children[4]));
        Assert.assertThat(afterRemoval.get(5), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat(afterRemoval.get(6), (Matcher)Is.is((Object)this.children[7].with(this.path("/a/b/c/e[3]"))));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location2.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, oldLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Object)this.location));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location2.getPath()), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, oldLocation.getPath()), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Object)this.children[0]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Object)this.children[1]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Object)this.children[2]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Object)this.children[3]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Object)this.children[4]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[5].getPath()), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Object)this.children[7].with(this.path("/a/b/c/e[3]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldUpdateCacheWhenNodeIsRemoved() {
        Location oldLocation = this.location2;
        Location newLocation = Location.create((Path)((Path)this.pathFactory.create("/a/b/c/d3/e[1]")));
        Assert.assertThat((Object)oldLocation.getPath().getString(this.namespaces), (Matcher)Is.is((Object)"/a/b/c/e[2]"));
        Assert.assertThat((Object)newLocation.getPath().getString(this.namespaces), (Matcher)Is.is((Object)"/a/b/c/d3/e"));
        this.cache.addNewNode(this.workspaceId, this.location);
        this.cache.addNewNode(this.workspaceId, this.location2);
        for (Location loc : this.children) {
            this.cache.addNewNode(this.workspaceId, loc);
        }
        for (Location loc : this.children2) {
            this.cache.addNewNode(this.workspaceId, loc);
        }
        this.cache.addNewNode(this.workspaceId, this.location);
        this.cache.addNewNode(this.workspaceId, this.location2);
        this.cache.setAllChildren(this.workspaceId, this.location.getPath(), this.childrenList);
        this.cache.setAllChildren(this.workspaceId, this.location2.getPath(), this.childrenList2);
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location.getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location2.getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children2));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, oldLocation.getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children2));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[5].getPath()), (Matcher)JUnitMatchers.hasItems((Object[])this.children2));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Object)this.location));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location2.getPath()), (Matcher)Is.is((Object)this.location2));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, oldLocation.getPath()), (Matcher)Is.is((Object)oldLocation));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Object)this.children[0]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Object)this.children[1]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Object)this.children[2]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Object)this.children[3]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Object)this.children[4]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[5].getPath()), (Matcher)Is.is((Object)this.children[5]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Object)this.children[6]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[7].getPath()), (Matcher)Is.is((Object)this.children[7]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[0].getPath()), (Matcher)Is.is((Object)this.children2[0]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Object)this.children2[1]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Object)this.children2[2]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Object)this.children2[3]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Object)this.children2[4]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Object)this.children2[5]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Object)this.children2[6]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Object)this.children2[7]));
        LinkedList<Location> locationsToRemove = new LinkedList<Location>();
        locationsToRemove.add(this.location2);
        for (Location childLocation : this.children2) {
            locationsToRemove.add(childLocation);
        }
        locationsToRemove.add(Location.create((Path)this.pathFactory.create(this.children2[6].getPath(), "m1")));
        locationsToRemove.add(Location.create((Path)this.pathFactory.create(this.children2[6].getPath(), "m2")));
        locationsToRemove.add(Location.create((Path)this.pathFactory.create(this.children2[6].getPath(), "m3")));
        Assert.assertThat((Object)this.cache.removeBranch(this.workspaceId, locationsToRemove), (Matcher)Is.is((Object)true));
        LinkedList afterRemoval = this.cache.getAllChildren(this.workspaceId, this.location.getPath());
        Assert.assertThat(afterRemoval.get(0), (Matcher)Is.is((Object)this.children[0]));
        Assert.assertThat(afterRemoval.get(1), (Matcher)Is.is((Object)this.children[1]));
        Assert.assertThat(afterRemoval.get(2), (Matcher)Is.is((Object)this.children[2]));
        Assert.assertThat(afterRemoval.get(3), (Matcher)Is.is((Object)this.children[3]));
        Assert.assertThat(afterRemoval.get(4), (Matcher)Is.is((Object)this.children[4]));
        Assert.assertThat(afterRemoval.get(5), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat(afterRemoval.get(6), (Matcher)Is.is((Object)this.children[7].with(this.path("/a/b/c/e[3]"))));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.location2.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, oldLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getAllChildren(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location.getPath()), (Matcher)Is.is((Object)this.location));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.location2.getPath()), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, oldLocation.getPath()), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, newLocation.getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[0].getPath()), (Matcher)Is.is((Object)this.children[0]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[1].getPath()), (Matcher)Is.is((Object)this.children[1]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[2].getPath()), (Matcher)Is.is((Object)this.children[2]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[3].getPath()), (Matcher)Is.is((Object)this.children[3]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[4].getPath()), (Matcher)Is.is((Object)this.children[4]));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[5].getPath()), (Matcher)Is.is((Object)this.children[6].with(this.path("/a/b/c/e[2]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[6].getPath()), (Matcher)Is.is((Object)this.children[7].with(this.path("/a/b/c/e[3]"))));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[0].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[1].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[2].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[3].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[4].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[5].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[6].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.cache.getLocationFor(this.workspaceId, this.children2[7].getPath()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }
}

