/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.SecureHash;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.store.jpa.util.Serializer;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactories;

public class SerializerTest {
    private Serializer serializer;
    private ExecutionContext context;
    private LargeValuesHolder largeValues;
    private PropertyFactory propertyFactory;
    private ValueFactories valueFactories;
    private Serializer.ReferenceValues references;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.propertyFactory = this.context.getPropertyFactory();
        this.valueFactories = this.context.getValueFactories();
        this.serializer = new Serializer(this.context, false);
        this.largeValues = new LargeValuesHolder();
        this.references = Serializer.NO_REFERENCES_VALUES;
    }

    @Test
    public void shouldSerializeAndDeserializeLongProperty() throws Exception {
        Property prop = this.createProperty("p1", new Long(1L));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeIntegerProperty() throws Exception {
        Property prop = this.createProperty("p1", new Integer(1));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeShortProperty() throws Exception {
        Property prop = this.createProperty("p1", new Short(1));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeFloatProperty() throws Exception {
        Property prop = this.createProperty("p1", new Float(1.0f));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeDoubleProperty() throws Exception {
        Property prop = this.createProperty("p1", new Double(1.0));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeBooleanProperty() throws Exception {
        Property prop = this.createProperty("p1", new Boolean(true));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeNameProperty() throws Exception {
        Property prop = this.createProperty("p1", this.valueFactories.getNameFactory().create("something"));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializePathProperty() throws Exception {
        Property prop = this.createProperty("p1", this.valueFactories.getPathFactory().create("/a/b/c/something"));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeDateTimeProperty() throws Exception {
        Property prop = this.createProperty("p1", this.valueFactories.getDateFactory().createUtc());
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
        prop = this.createProperty("p1", this.valueFactories.getDateFactory().create());
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeUuidProperty() throws Exception {
        Property prop = this.createProperty("p1", UUID.randomUUID());
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeUriProperty() throws Exception {
        Property prop = this.createProperty("p1", new URI("http://example.com"));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeReferenceProperty() throws Exception {
        UUID uuid = UUID.randomUUID();
        Property prop = this.createProperty("p1", this.valueFactories.getReferenceFactory().create(uuid.toString()));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeBigDecimalProperty() throws Exception {
        Property prop = this.createProperty("p1", this.valueFactories.getDecimalFactory().create("1.0123455243284347375478525485466895512"));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeSmallBinaryProperty() throws Exception {
        String value = "v1";
        Property prop = this.createProperty("p1", this.valueFactories.getBinaryFactory().create(value));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeLargeBinaryProperty() throws Exception {
        String value = "really really long string that will be converted to a binary value and tested like that";
        Property prop = this.createProperty("p1", this.valueFactories.getBinaryFactory().create(value));
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldSerializeAndDeserializeSmallStringProperty() throws Exception {
        Property prop = this.createProperty("p1", "v1");
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSerializeAndDeserializeLargeStringProperty() throws Exception {
        String value = "v234567890123456789012345678901234567890";
        Property prop = this.createProperty("p1", value);
        this.assertSerializableAndDeserializable(this.serializer, prop);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.largeValues.get((String)value).value, (Matcher)Is.is((Object)value));
    }

    @Test
    public void shouldSerializeAndDeserializeSmallAndLargeStringProperty() throws Exception {
        Property prop1 = this.createProperty("p1", "v1");
        String value = "v234567890123456789012345678901234567890";
        Property prop2 = this.createProperty("p2", value);
        Property prop3 = this.createProperty("p3", "v2");
        Property prop4 = this.createProperty("p4", new String(value));
        this.assertSerializableAndDeserializable(this.serializer, prop1, prop2, prop3, prop4);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldSerializeAndDeserializeMixtureOfSmallAndLargeProperties() throws Exception {
        Property prop1 = this.createProperty("p1", "v1");
        String value = "v234567890123456789012345678901234567890";
        Property prop2 = this.createProperty("p2", value);
        Property prop3 = this.createProperty("p3", "v2");
        Property prop4 = this.createProperty("p4", new String(value));
        Property prop5 = this.createProperty("p5", this.valueFactories.getBinaryFactory().create("something"));
        String binaryValue = "really really long string that will be converted to a binary value and tested like that";
        Property prop6 = this.createProperty("p6", this.valueFactories.getBinaryFactory().create(binaryValue));
        UUID uuid7 = UUID.randomUUID();
        Reference ref7 = (Reference)this.valueFactories.getReferenceFactory().create(uuid7);
        Property prop7 = this.createProperty("p7", ref7);
        UUID uuid8 = UUID.randomUUID();
        Reference ref8 = (Reference)this.valueFactories.getReferenceFactory().create(uuid8);
        Property prop8 = this.createProperty("p8", ref8);
        this.assertSerializableAndDeserializable(this.serializer, prop1, prop2, prop3, prop4, prop5, prop6, prop7, prop8);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldReserializePropertiesWithUpdates() throws Exception {
        Property prop1 = this.createProperty("p1", "v1");
        String value = "v234567890123456789012345678901234567890";
        Property prop2 = this.createProperty("p2", value);
        Property prop3 = this.createProperty("p3", "v2");
        Property prop4 = this.createProperty("p4", new String(value));
        Property prop5 = this.createProperty("p5", this.valueFactories.getBinaryFactory().create("something"));
        String binaryValueStr = "really really long string that will be converted to a binary value and tested like that";
        Binary binaryValue = (Binary)this.valueFactories.getBinaryFactory().create(binaryValueStr);
        Property prop6 = this.createProperty("p6", binaryValue);
        UUID uuid7 = UUID.randomUUID();
        Reference ref7 = (Reference)this.valueFactories.getReferenceFactory().create(uuid7);
        Property prop7 = this.createProperty("p7", ref7);
        UUID uuid8 = UUID.randomUUID();
        Reference ref8 = (Reference)this.valueFactories.getReferenceFactory().create(uuid8);
        Property prop8 = this.createProperty("p8", ref8);
        Property prop2b = this.createProperty("p2", new Object[0]);
        Property prop3b = this.createProperty("p3", "v3");
        String binaryValueStr2 = binaryValueStr + " but modified";
        Binary binaryValue2 = (Binary)this.valueFactories.getBinaryFactory().create(binaryValueStr2);
        Property prop6b = this.createProperty("p6", binaryValue2);
        Property[] initial = new Property[]{prop1, prop2, prop3, prop4, prop5, prop6, prop7, prop8};
        Property[] updated = new Property[]{prop2b, prop3b, prop6b};
        Name[] deleted = new Name[]{};
        SkippedLargeValues removedLargeValues = new SkippedLargeValues();
        this.assertReserializable(this.serializer, removedLargeValues, initial, updated, deleted);
        Assert.assertThat((Object)this.largeValues.getCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)removedLargeValues.getCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.largeValues.get(this.serializer.computeHash(value)), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.largeValues.get(binaryValue2), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.largeValues.get(binaryValue2), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)removedLargeValues.isSkipped(binaryValue), (Matcher)Is.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAdjustReferences() throws Exception {
        Property prop1 = this.createProperty("p1", "v1");
        String value = "v234567890123456789012345678901234567890";
        Property prop2 = this.createProperty("p2", value);
        Property prop3 = this.createProperty("p3", "v2");
        Property prop4 = this.createProperty("p4", new String(value));
        Property prop5 = this.createProperty("p5", this.valueFactories.getBinaryFactory().create("something"));
        String binaryValueStr = "really really long string that will be converted to a binary value and tested like that";
        Binary binaryValue = (Binary)this.valueFactories.getBinaryFactory().create(binaryValueStr);
        Property prop6 = this.createProperty("p6", binaryValue);
        UUID uuid7 = UUID.randomUUID();
        Reference ref7 = (Reference)this.valueFactories.getReferenceFactory().create(uuid7);
        Property prop7 = this.createProperty("p7", ref7);
        UUID uuid8 = UUID.randomUUID();
        Reference ref8 = (Reference)this.valueFactories.getReferenceFactory().create(uuid8);
        Property prop8 = this.createProperty("p8", ref8);
        Object[] props = new Property[]{prop1, prop2, prop3, prop4, prop5, prop6, prop7, prop8};
        byte[] content = this.serialize(this.serializer, (Property[])props);
        List<Property> properties = this.deserialize(this.serializer, content);
        Assert.assertThat(properties, (Matcher)JUnitMatchers.hasItems((Object[])props));
        UUID newUuid7 = UUID.randomUUID();
        HashMap<String, String> oldToNewUuids = new HashMap<String, String>();
        oldToNewUuids.put(uuid7.toString(), newUuid7.toString());
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        ObjectInputStream ois = new ObjectInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            this.serializer.adjustReferenceProperties(ois, oos, oldToNewUuids);
        }
        finally {
            baos.close();
            oos.close();
        }
        byte[] newContent = baos.toByteArray();
        properties = this.deserialize(this.serializer, newContent);
        Reference newRef7 = (Reference)this.valueFactories.getReferenceFactory().create(newUuid7);
        Property newProp7 = this.createProperty("p7", newRef7);
        Object[] newProps = new Property[]{prop1, prop2, prop3, prop4, prop5, prop6, newProp7, prop8};
        Assert.assertThat(properties, (Matcher)JUnitMatchers.hasItems((Object[])newProps));
    }

    protected Property createProperty(String name, Object ... values) {
        return this.propertyFactory.create((Name)this.valueFactories.getNameFactory().create(name), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSerializableAndDeserializable(Serializer serializer, Property ... properties) throws IOException, ClassNotFoundException {
        for (Property property : properties) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                serializer.serializeProperty(oos, property, (Serializer.LargeValues)this.largeValues, this.references);
            }
            finally {
                oos.close();
            }
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Property copy = null;
            try {
                copy = serializer.deserializeProperty(ois, (Serializer.LargeValues)this.largeValues);
            }
            finally {
                ois.close();
            }
            Assert.assertThat((Object)copy, (Matcher)Is.is((Object)property));
        }
        List<Property> propertyList = Arrays.asList(properties);
        List<Object> outputProperties = new ArrayList(propertyList.size());
        byte[] bytes = this.serialize(serializer, propertyList.toArray(new Property[propertyList.size()]));
        outputProperties = this.deserialize(serializer, bytes);
        Assert.assertThat((Object)outputProperties.size(), (Matcher)Is.is((Object)propertyList.size()));
        Assert.assertThat(outputProperties, (Matcher)JUnitMatchers.hasItems((Object[])propertyList.toArray(new Property[propertyList.size()])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(Serializer serializer, Property ... originalProperties) throws IOException {
        List<Property> initialProps = Arrays.asList(originalProperties);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            serializer.serializeProperties(oos, initialProps.size(), initialProps, (Serializer.LargeValues)this.largeValues, this.references);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Property> deserialize(Serializer serializer, byte[] content) throws IOException, ClassNotFoundException {
        ArrayList<Property> afterProperties = new ArrayList<Property>();
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            serializer.deserializeAllProperties(ois, afterProperties, (Serializer.LargeValues)this.largeValues);
        }
        finally {
            ois.close();
        }
        return afterProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertReserializable(Serializer serializer, Serializer.LargeValues removedLargeValues, Property[] originalProperties, Property[] updatedProperties, Name[] removedProperties) throws IOException, ClassNotFoundException {
        HashSet<Name> propertiesThatStay = new HashSet<Name>();
        HashSet<Property> propertiesThatAreDeleted = new HashSet<Property>();
        HashSet<Name> propertiesThatAreNew = new HashSet<Name>();
        for (Property property : originalProperties) {
            propertiesThatStay.add(property.getName());
        }
        for (Property property : updatedProperties) {
            if (!propertiesThatStay.add(property.getName())) continue;
            propertiesThatAreNew.add(property.getName());
        }
        for (Property property : removedProperties) {
            propertiesThatAreDeleted.add(property);
            propertiesThatStay.remove(property);
            Assert.assertThat((Object)propertiesThatAreNew.contains(property), (Matcher)Is.is((Object)false));
        }
        byte[] bytes = this.serialize(serializer, originalProperties);
        HashMap<Name, Property> updatedProps = new HashMap<Name, Property>();
        for (Property property : updatedProperties) {
            updatedProps.put(property.getName(), property);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        HashSet createdProperties = new HashSet();
        try {
            serializer.reserializeProperties(objectInputStream, oos, updatedProps, (Serializer.LargeValues)this.largeValues, removedLargeValues, createdProperties, this.references);
        }
        finally {
            oos.close();
            objectInputStream.close();
        }
        List<Property> afterProperties = this.deserialize(serializer, baos.toByteArray());
        HashSet<Name> namesAfter = new HashSet<Name>();
        for (Property property : afterProperties) {
            namesAfter.add(property.getName());
        }
        Assert.assertThat((Object)afterProperties.size(), (Matcher)Is.is((Object)propertiesThatStay.size()));
        Assert.assertThat(namesAfter, (Matcher)Is.is(propertiesThatStay));
        for (Name name : propertiesThatAreDeleted) {
            Assert.assertThat((Object)namesAfter.contains(name), (Matcher)Is.is((Object)false));
        }
        Assert.assertThat(createdProperties, (Matcher)Is.is(propertiesThatAreNew));
    }

    protected class LargeValuesHolder
    implements Serializer.LargeValues {
        private int minimumSize = 20;
        private final Map<String, LargeValue> largeValuesByHexHash = new HashMap<String, LargeValue>();

        public long getMinimumSize() {
            return this.minimumSize;
        }

        public void setMinimumSize(int minimumSize) {
            CheckArg.isPositive((int)minimumSize, (String)"minimumSize");
            this.minimumSize = minimumSize;
        }

        public int getCount() {
            return this.largeValuesByHexHash.size();
        }

        public Object read(ValueFactories valueFactories, byte[] hash, long length) {
            LargeValue largeValue = this.get(hash);
            return largeValue != null ? largeValue.value : null;
        }

        public LargeValue get(String obj) throws NoSuchAlgorithmException {
            byte[] hash = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])obj.getBytes());
            return this.get(hash);
        }

        public LargeValue get(Binary obj) {
            return this.get(obj.getHash());
        }

        public LargeValue get(byte[] hash) {
            String hexHash = StringUtil.getHexString((byte[])hash);
            return this.largeValuesByHexHash.get(hexHash);
        }

        public void write(byte[] hash, long length, PropertyType type, Object value) {
            String hexHash = StringUtil.getHexString((byte[])hash);
            this.largeValuesByHexHash.put(hexHash, new LargeValue(hash, length, type, value));
        }

        protected class LargeValue {
            protected final byte[] hash;
            protected final long length;
            protected final PropertyType type;
            protected final Object value;

            protected LargeValue(byte[] hash, long length, PropertyType type, Object value) {
                assert (hash != null);
                assert (length > 0L);
                assert (type != null);
                assert (value != null);
                this.hash = hash;
                this.length = length;
                this.type = type;
                this.value = value;
            }
        }
    }

    protected class SkippedLargeValues
    implements Serializer.LargeValues {
        private int minimumSize = 20;
        private Set<String> skippedKeys = new HashSet<String>();

        public long getMinimumSize() {
            return this.minimumSize;
        }

        public Object read(ValueFactories valueFactories, byte[] hash, long length) {
            String key = StringUtil.getHexString((byte[])hash);
            return this.skippedKeys.add(key);
        }

        public void write(byte[] hash, long length, PropertyType type, Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean isSkipped(Binary binary) {
            String key = StringUtil.getHexString((byte[])binary.getHash());
            return this.isSkipped(key);
        }

        public boolean isSkipped(String key) {
            return this.skippedKeys.contains(key);
        }

        public int getCount() {
            return this.skippedKeys.size();
        }
    }
}

