/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.component;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.component.ClassLoaderFactory;

@Immutable
public class StandardClassLoaderFactory
implements ClassLoaderFactory {
    private final ClassLoader delegate;
    private final boolean useCurrentThreadContextClassLoader;

    public StandardClassLoaderFactory() {
        this(true, null);
    }

    public StandardClassLoaderFactory(ClassLoader delegate) {
        this(true, delegate);
    }

    public StandardClassLoaderFactory(boolean useCurrentThreadContextClassLoader, ClassLoader delegate) {
        this.delegate = delegate != null ? delegate : this.getClass().getClassLoader();
        this.useCurrentThreadContextClassLoader = useCurrentThreadContextClassLoader;
    }

    @Override
    public ClassLoader getClassLoader(String ... classpath) {
        ClassLoader result = null;
        if (this.useCurrentThreadContextClassLoader) {
            result = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        if (result == null) {
            result = this.delegate;
        }
        return result;
    }
}

