/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrResultSet;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.delegate.RepositoryDelegate;

class JcrStatement
implements Statement {
    private final JcrConnection connection;
    private ResultSet results;
    private boolean closed;
    private SQLWarning warning;
    private int rowLimit = -1;
    private int fetchDirection = 1000;
    private boolean poolable;
    private int moreResults = 0;
    private String sqlLanguage = "JCR-SQL2";

    JcrStatement(JcrConnection connection) {
        this.connection = connection;
        assert (this.connection != null);
    }

    JcrConnection connection() {
        return this.connection;
    }

    public void setJcrSqlLanguage(String jcrSQL) {
        this.sqlLanguage = jcrSQL != null ? jcrSQL : "JCR-SQL2";
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.notClosed();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.notClosed();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.notClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.notClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException(JdbcLocalI18n.invalidArgument.text(direction, "1000, 1001, 1002"));
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.notClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.notClosed();
        if (max < 0) {
            throw new SQLException(JdbcLocalI18n.argumentMayNotBeNegative.text("max", max));
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.notClosed();
        return this.rowLimit == -1 ? 0 : this.rowLimit;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.notClosed();
        if (max < 0) {
            throw new SQLException(JdbcLocalI18n.argumentMayNotBeNegative.text("max", max));
        }
        this.rowLimit = max;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.notClosed();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.notClosed();
        if (seconds < 0) {
            throw new SQLException(JdbcLocalI18n.argumentMayNotBeNegative.text("seconds", seconds));
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.notClosed();
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.notClosed();
        this.poolable = poolable;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.notClosed();
        return this.connection;
    }

    @Override
    public void cancel() throws SQLException {
        this.notClosed();
        this.close();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.notClosed();
        this.warning = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.notClosed();
        return this.warning;
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.connection.isClosed();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.connection.getRepositoryDelegate().closeStatement();
        }
    }

    protected final void notClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(JdbcLocalI18n.statementIsClosed.text(new Object[0]));
        }
    }

    protected final void noUpdates() throws SQLException {
        throw new SQLException(JdbcLocalI18n.updatesNotSupported.text(new Object[0]));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.notClosed();
        this.noUpdates();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.notClosed();
        this.noUpdates();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.notClosed();
        this.noUpdates();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.notClosed();
        this.noUpdates();
        return 0;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.notClosed();
        return -1;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.notClosed();
        this.noUpdates();
        return null;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.notClosed();
        this.warning = null;
        this.moreResults = 0;
        try {
            String jcrSql2 = this.connection.nativeSQL(sql);
            QueryResult jcrResults = this.getJcrRepositoryDelegate().execute(jcrSql2, this.sqlLanguage);
            this.results = new JcrResultSet(this, jcrResults, null);
            this.moreResults = 1;
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
        return true;
    }

    protected RepositoryDelegate getJcrRepositoryDelegate() {
        return this.connection.getRepositoryDelegate();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        return this.getResultSet();
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return new JcrResultSet();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.notClosed();
        return this.moreResults > 0;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.notClosed();
        if (current != 3 && current != 1 && current != 2) {
            throw new SQLException(JdbcLocalI18n.invalidArgument.text(current, "3, 1, 2"));
        }
        if (2 != current) {
            this.results = null;
        }
        if (this.moreResults > 0) {
            --this.moreResults;
        }
        return this.moreResults > 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.notClosed();
        return this.results;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.notClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.notClosed();
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.notClosed();
        return 1004;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.notClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(JdbcLocalI18n.classDoesNotImplementInterface.text(Statement.class.getSimpleName(), iface.getName()));
        }
        return iface.cast(this);
    }
}

