/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.BasicPath;

@Immutable
class CorrespondenceId {
    private static final Path NO_PATH = BasicPath.SELF_PATH;
    private final String referenceableId;
    private final Path relativePath;
    private final int hc;

    public CorrespondenceId(String referenceableId) {
        this(referenceableId, NO_PATH);
    }

    public CorrespondenceId(String referenceableId, Path relativePath) {
        CheckArg.isNotNull((Object)referenceableId, (String)"referenceableId");
        CheckArg.isNotNull((Object)relativePath, (String)"relativePath");
        assert (!relativePath.isAbsolute());
        this.referenceableId = referenceableId;
        this.relativePath = relativePath;
        this.hc = HashCode.compute((Object[])new Object[]{this.referenceableId, this.relativePath});
    }

    public String getReferenceableId() {
        return this.referenceableId;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CorrespondenceId) {
            CorrespondenceId that = (CorrespondenceId)obj;
            return this.referenceableId.equals(that.referenceableId) && this.relativePath.equals(that.relativePath);
        }
        return false;
    }
}

