/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.disk.DiskConnectorI18n;
import org.modeshape.connector.disk.DiskNode;
import org.modeshape.connector.disk.DiskRepository;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.AbstractNodeCachingRepositorySource;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Connection;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.cache.NodeCachePolicy;
import org.modeshape.graph.observe.Observer;

@ThreadSafe
public class DiskSource
extends AbstractNodeCachingRepositorySource<UUID, DiskNode>
implements ObjectFactory {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME_OF_DEFAULT_WORKSPACE = "default";
    public static final boolean DEFAULT_UPDATES_ALLOWED = true;
    public static final String DEFAULT_REPOSITORY_ROOT_PATH = "/tmp";
    public static final boolean DEFAULT_LOCK_FILE_USED = false;
    private static final int DEFAULT_LARGE_VALUE_SIZE_IN_BYTES = 8192;
    private static final String DEFAULT_LARGE_VALUE_PATH = "largeValues";
    private static final String ROOT_NODE_UUID = "rootNodeUuid";
    private static final String SOURCE_NAME = "sourceName";
    private static final String CACHE_POLICY = "cachePolicy";
    private static final String RETRY_LIMIT = "retryLimit";
    private static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    private static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    private static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    private static final String UPDATES_ALLOWED = "updatesAllowed";
    private static final String REPOSITORY_ROOT_PATH = "repositoryRootPath";
    private static final String LOCK_FILE_USED = "lockFileUsed";
    private static final String LARGE_VALUE_SIZE_IN_BYTES = "largeValueSizeInBytes";
    private static final String LARGE_VALUE_PATH = "largeValuePath";
    @Description(i18n=DiskConnectorI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=DiskConnectorI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=DiskConnectorI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private volatile String defaultWorkspace;
    @Description(i18n=DiskConnectorI18n.class, value="predefinedWorkspaceNamesPropertyDescription")
    @Label(i18n=DiskConnectorI18n.class, value="predefinedWorkspaceNamesPropertyLabel")
    @Category(i18n=DiskConnectorI18n.class, value="predefinedWorkspaceNamesPropertyCategory")
    private volatile String[] predefinedWorkspaces = new String[0];
    @Description(i18n=DiskConnectorI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=DiskConnectorI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=DiskConnectorI18n.class, value="updatesAllowedPropertyCategory")
    private volatile boolean updatesAllowed = true;
    @Description(i18n=DiskConnectorI18n.class, value="repositoryRootPathPropertyDescription")
    @Label(i18n=DiskConnectorI18n.class, value="repositoryRootPathPropertyLabel")
    @Category(i18n=DiskConnectorI18n.class, value="repositoryRootPathPropertyCategory")
    private volatile String repositoryRootPath = "/tmp";
    @Description(i18n=DiskConnectorI18n.class, value="lockFileUsedPropertyDescription")
    @Label(i18n=DiskConnectorI18n.class, value="lockFileUsedPropertyLabel")
    @Category(i18n=DiskConnectorI18n.class, value="lockFileUsedPropertyCategory")
    private volatile boolean lockFileUsed = false;
    @Description(i18n=DiskConnectorI18n.class, value="largeValueSizeInBytesPropertyDescription")
    @Label(i18n=DiskConnectorI18n.class, value="largeValueSizeInBytesPropertyLabel")
    @Category(i18n=DiskConnectorI18n.class, value="largeValueSizeInBytesPropertyCategory")
    private volatile long largeValueSizeInBytes = 8192L;
    @Description(i18n=DiskConnectorI18n.class, value="largeValuePathPropertyDescription")
    @Label(i18n=DiskConnectorI18n.class, value="largeValuePathPropertyLabel")
    @Category(i18n=DiskConnectorI18n.class, value="largeValuePathPropertyCategory")
    private volatile String largeValuePath = "largeValues";
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, true, false, true, true);
    private transient DiskRepository repository;
    private transient Context jndiContext;
    private transient RepositoryContext repositoryContext;

    public String getRepositoryRootPath() {
        return this.repositoryRootPath;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public synchronized void setRepositoryRootPath(String repositoryRootPath) {
        if (repositoryRootPath == null) {
            repositoryRootPath = DEFAULT_REPOSITORY_ROOT_PATH;
        }
        this.repositoryRootPath = repositoryRootPath;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public synchronized void setDefaultWorkspaceName(String nameOfDefaultWorkspace) {
        this.defaultWorkspace = nameOfDefaultWorkspace != null ? nameOfDefaultWorkspace : DEFAULT_NAME_OF_DEFAULT_WORKSPACE;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        if (predefinedWorkspaceNames != null && predefinedWorkspaceNames.length == 1) {
            predefinedWorkspaceNames = predefinedWorkspaceNames[0].split("\\s*,\\s*");
        }
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    public long getLargeValueSizeInBytes() {
        return this.largeValueSizeInBytes;
    }

    public void setLargeValueSizeInBytes(long largeValueSizeInBytes) {
        if (largeValueSizeInBytes < 0L) {
            largeValueSizeInBytes = 8192L;
        }
        this.largeValueSizeInBytes = largeValueSizeInBytes;
    }

    public String getLargeValuePath() {
        return this.largeValuePath;
    }

    public void setLargeValuePath(String largeValuePath) {
        if (largeValuePath == null) {
            largeValuePath = DEFAULT_LARGE_VALUE_PATH;
        }
        this.largeValuePath = largeValuePath;
    }

    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(true, this.capabilities.supportsUpdates(), false, allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    public synchronized void close() {
    }

    protected Observer getObserver() {
        return this.repositoryContext != null ? this.repositoryContext.getObserver() : null;
    }

    protected synchronized Context getContext() {
        return this.jndiContext;
    }

    protected synchronized void setContext(Context context) {
        this.jndiContext = context;
    }

    public boolean areUpdatesAllowed() {
        return this.updatesAllowed;
    }

    public void setUpdatesAllowed(boolean updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
    }

    public boolean isLockFileUsed() {
        return this.lockFileUsed;
    }

    public void setLockFileUsed(boolean lockFileUsed) {
        this.lockFileUsed = lockFileUsed;
    }

    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.getName() == null) {
            I18n msg = DiskConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.repository == null) {
            this.repository = new DiskRepository(this);
        }
        return new Connection((BaseRepositorySource)this, (Repository)this.repository);
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String managerClassName = this.getClass().getName();
        Reference ref = new Reference(className, managerClassName, null);
        ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuid().toString()));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(UPDATES_ALLOWED, String.valueOf(this.areUpdatesAllowed())));
        ref.add(new StringRefAddr(REPOSITORY_ROOT_PATH, String.valueOf(this.getRepositoryRootPath())));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        ref.add(new StringRefAddr(LOCK_FILE_USED, Boolean.toString(this.isLockFileUsed())));
        ref.add(new StringRefAddr(LARGE_VALUE_SIZE_IN_BYTES, String.valueOf(this.largeValueSizeInBytes)));
        ref.add(new StringRefAddr(LARGE_VALUE_PATH, this.largeValuePath));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(CACHE_POLICY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = DiskConnectorI18n.errorSerializingCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        this.addNodeCachePolicyReference(ref);
        return ref;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DiskSource) {
            DiskSource that = (DiskSource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.getName()});
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String rootNodeUuidString = (String)values.get(ROOT_NODE_UUID);
            Object defaultCachePolicy = values.get(CACHE_POLICY);
            Object nodeCachePolicy = values.get("nodeCachePolicy");
            String retryLimit = (String)values.get(RETRY_LIMIT);
            String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
            String createWorkspaces = (String)values.get(ALLOW_CREATING_WORKSPACES);
            String updatesAllowed = (String)values.get(UPDATES_ALLOWED);
            String repositoryRootPath = (String)values.get(REPOSITORY_ROOT_PATH);
            String lockFileUsed = (String)values.get(LOCK_FILE_USED);
            String largeValuePath = (String)values.get(LARGE_VALUE_PATH);
            String largeValueSizeInBytes = (String)values.get(LARGE_VALUE_SIZE_IN_BYTES);
            String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            DiskSource source = new DiskSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuidString != null) {
                source.setRootNodeUuid(rootNodeUuidString);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (nodeCachePolicy instanceof NodeCachePolicy) {
                source.setNodeCachePolicy((NodeCachePolicy)nodeCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            if (defaultWorkspace != null) {
                source.setDefaultWorkspaceName(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (updatesAllowed != null) {
                source.setUpdatesAllowed(Boolean.valueOf(updatesAllowed));
            }
            if (repositoryRootPath != null) {
                source.setRepositoryRootPath(repositoryRootPath);
            }
            if (lockFileUsed != null) {
                source.setLockFileUsed(Boolean.valueOf(lockFileUsed));
            }
            if (largeValuePath != null) {
                source.setLargeValuePath(largeValuePath);
            }
            if (largeValueSizeInBytes != null) {
                source.setLargeValueSizeInBytes(Long.valueOf(largeValueSizeInBytes));
            }
            return source;
        }
        return null;
    }
}

