/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDRepeatableFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDParser;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.HashMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.SizeMeasuringInputStream;
import org.modeshape.common.util.SizeMeasuringReader;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.sramp.SrampLexicon;
import org.modeshape.sequencer.xsd.XsdI18n;
import org.modeshape.sequencer.xsd.XsdLexicon;
import org.modeshape.sequencer.xsd.XsdResolvers;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@NotThreadSafe
public class XsdReader {
    public static final String UNBOUNDED = "unbounded";
    protected final SequencerOutput output;
    protected final StreamSequencerContext context;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final Map<Path, Multimap<Name, Integer>> namesByParentPath = new HashMap<Path, Multimap<Name, Integer>>();
    protected final XsdResolvers resolvers;
    protected List<ResolveFuture> resolveFutures = new LinkedList<ResolveFuture>();

    public XsdReader(SequencerOutput output, StreamSequencerContext context, XsdResolvers resolvers) {
        this.output = output;
        this.context = context;
        this.resolvers = resolvers != null ? resolvers : new XsdResolvers();
    }

    public XsdReader(SequencerOutput output, StreamSequencerContext context) {
        this(output, context, null);
    }

    public XsdResolvers getResolvers() {
        return this.resolvers;
    }

    public StreamSequencerContext getContext() {
        return this.context;
    }

    public void read(String xsdContent, Path docPath) {
        this.read(new InputSource(new StringReader(xsdContent)), docPath);
    }

    public void read(InputStream stream, Path docPath) {
        this.read(new InputSource(stream), docPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void read(InputSource source, Path docPath) {
        block48: {
            String location;
            InputStream stream;
            Reader reader;
            block47: {
                block46: {
                    this.logger.trace("Processing XSD '{0}'", new Object[]{this.string(docPath)});
                    reader = null;
                    stream = null;
                    HashMap options = new HashMap();
                    XSDParser parser = new XSDParser(options);
                    AtomicLong contentSize = new AtomicLong();
                    if (source.getCharacterStream() != null) {
                        reader = new SizeMeasuringReader(source.getCharacterStream(), contentSize);
                        source = new InputSource(reader);
                    } else {
                        stream = new SizeMeasuringInputStream(source.getByteStream(), contentSize);
                        source = new InputSource(stream);
                    }
                    parser.parse(source);
                    String encoding = parser.getEncoding();
                    String mimeType = this.context.getMimeType();
                    XSDSchema schema = parser.getSchema();
                    this.process(schema, encoding, mimeType, contentSize.get(), docPath);
                    if ($assertionsDisabled || reader != null && stream == null || reader == null && stream != null) break block46;
                    throw new AssertionError();
                }
                if (reader == null) break block47;
                reader.close();
            }
            try {
                if (stream != null) {
                    stream.close();
                }
                break block48;
            }
            catch (Exception e) {
                location = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                this.context.getProblems().addError((Throwable)e, XsdI18n.errorClosingXsdFile, new Object[]{location, e.getMessage()});
            }
            break block48;
            catch (Exception e) {
                try {
                    location = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                    this.context.getProblems().addError((Throwable)e, XsdI18n.errorClosingXsdFile, new Object[]{location, e.getMessage()});
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e2) {
                        String location2 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                        this.context.getProblems().addError((Throwable)e2, XsdI18n.errorClosingXsdFile, new Object[]{location2, e2.getMessage()});
                    }
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block48;
                }
                catch (Exception e3) {
                    location = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                    this.context.getProblems().addError((Throwable)e3, XsdI18n.errorClosingXsdFile, new Object[]{location, e3.getMessage()});
                }
                break block48;
            }
            catch (Exception e) {
                String location3;
                block50: {
                    block49: {
                        try {
                            location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                            this.context.getProblems().addError((Throwable)e, XsdI18n.errorReadingXsdFile, new Object[]{location3, e.getMessage()});
                            if ($assertionsDisabled || reader != null && stream == null || reader == null && stream != null) break block49;
                        }
                        catch (Throwable throwable) {
                            block52: {
                                block51: {
                                    assert (reader != null && stream == null || reader == null && stream != null);
                                    if (reader == null) break block51;
                                    reader.close();
                                }
                                try {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                    break block52;
                                }
                                catch (Exception e4) {
                                    String location4 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                    this.context.getProblems().addError((Throwable)e4, XsdI18n.errorClosingXsdFile, new Object[]{location4, e4.getMessage()});
                                }
                                break block52;
                                catch (Exception e5) {
                                    String location5;
                                    try {
                                        location5 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                        this.context.getProblems().addError((Throwable)e5, XsdI18n.errorClosingXsdFile, new Object[]{location5, e5.getMessage()});
                                    }
                                    catch (Throwable throwable2) {
                                        try {
                                            if (stream != null) {
                                                stream.close();
                                            }
                                        }
                                        catch (Exception e6) {
                                            String location6 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                            this.context.getProblems().addError((Throwable)e6, XsdI18n.errorClosingXsdFile, new Object[]{location6, e6.getMessage()});
                                        }
                                        throw throwable2;
                                    }
                                    try {
                                        if (stream != null) {
                                            stream.close();
                                        }
                                    }
                                    catch (Exception e7) {
                                        location5 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                        this.context.getProblems().addError((Throwable)e7, XsdI18n.errorClosingXsdFile, new Object[]{location5, e7.getMessage()});
                                    }
                                }
                            }
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    if (reader == null) break block50;
                    reader.close();
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e8) {
                    location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                    this.context.getProblems().addError((Throwable)e8, XsdI18n.errorClosingXsdFile, new Object[]{location3, e8.getMessage()});
                }
                catch (Exception e9) {
                    try {
                        location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                        this.context.getProblems().addError((Throwable)e9, XsdI18n.errorClosingXsdFile, new Object[]{location3, e9.getMessage()});
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (Exception e10) {
                            String location7 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                            this.context.getProblems().addError((Throwable)e10, XsdI18n.errorClosingXsdFile, new Object[]{location7, e10.getMessage()});
                        }
                        throw throwable;
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e11) {
                        location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                        this.context.getProblems().addError((Throwable)e11, XsdI18n.errorClosingXsdFile, new Object[]{location3, e11.getMessage()});
                    }
                }
            }
        }
    }

    protected Path process(XSDSchema schema, String encoding, String mimeType, long contentSize, Path path) {
        assert (schema != null);
        this.logger.trace("Target namespace: '{0}'", new Object[]{schema.getTargetNamespace()});
        this.output.setProperty(path, SrampLexicon.CONTENT_TYPE, new Object[]{"application/xsd"});
        if (encoding != null) {
            this.output.setProperty(path, SrampLexicon.CONTENT_ENCODING, new Object[]{encoding});
        }
        this.output.setProperty(path, SrampLexicon.CONTENT_SIZE, new Object[]{contentSize});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.SCHEMA_DOCUMENT});
        this.output.setProperty(path, JcrLexicon.UUID, new Object[]{UUID.randomUUID()});
        EList annotations = schema.getAnnotations();
        this.process((Iterable<XSDAnnotation>)annotations, path);
        this.processNonSchemaAttributes((XSDConcreteComponent)schema, path);
        for (EObject obj : schema.eContents()) {
            if (obj instanceof XSDSimpleTypeDefinition) {
                this.process((XSDSimpleTypeDefinition)obj, path);
                continue;
            }
            if (obj instanceof XSDComplexTypeDefinition) {
                this.process((XSDComplexTypeDefinition)obj, path);
                continue;
            }
            if (obj instanceof XSDElementDeclaration) {
                this.process((XSDElementDeclaration)obj, path);
                continue;
            }
            if (obj instanceof XSDAttributeDeclaration) {
                this.process((XSDAttributeDeclaration)obj, path, false);
                continue;
            }
            if (obj instanceof XSDImport) {
                this.process((XSDImport)obj, path);
                continue;
            }
            if (obj instanceof XSDInclude) {
                this.process((XSDInclude)obj, path);
                continue;
            }
            if (obj instanceof XSDRedefine) {
                this.process((XSDRedefine)obj, path);
                continue;
            }
            if (obj instanceof XSDAttributeGroupDefinition) {
                this.process((XSDAttributeGroupDefinition)obj, path);
                continue;
            }
            if (!(obj instanceof XSDAnnotation)) continue;
        }
        this.resolveReferences();
        return path;
    }

    protected Path process(XSDImport xsdImport, Path parentPath) {
        this.logger.trace("Import: '{0}' with location '{1}' ", new Object[]{xsdImport.getNamespace(), xsdImport.getSchemaLocation()});
        Path path = this.nextPath(parentPath, XsdLexicon.IMPORT);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.IMPORT});
        this.output.setProperty(path, XsdLexicon.NAMESPACE, new Object[]{xsdImport.getNamespace()});
        this.output.setProperty(path, XsdLexicon.SCHEMA_LOCATION, new Object[]{xsdImport.getSchemaLocation()});
        this.processNonSchemaAttributes((XSDConcreteComponent)xsdImport, path);
        return path;
    }

    protected Path process(XSDInclude xsdInclude, Path parentPath) {
        this.logger.trace("Include: '{0}' ", new Object[]{xsdInclude.getSchemaLocation()});
        Path path = this.nextPath(parentPath, XsdLexicon.INCLUDE);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.INCLUDE});
        this.output.setProperty(path, XsdLexicon.SCHEMA_LOCATION, new Object[]{xsdInclude.getSchemaLocation()});
        this.processNonSchemaAttributes((XSDConcreteComponent)xsdInclude, path);
        return path;
    }

    protected Path process(XSDRedefine redefine, Path parentPath) {
        this.logger.trace("Include: '{0}' ", new Object[]{redefine.getSchemaLocation()});
        Path path = this.nextPath(parentPath, XsdLexicon.REDEFINE);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.REDEFINE});
        this.output.setProperty(path, XsdLexicon.SCHEMA_LOCATION, new Object[]{redefine.getSchemaLocation()});
        this.processNonSchemaAttributes((XSDConcreteComponent)redefine, path);
        return path;
    }

    protected Path process(XSDSimpleTypeDefinition type, Path parentPath) {
        boolean isAnonymous = type.getName() == null;
        Name nodeName = isAnonymous ? XsdLexicon.SIMPLE_TYPE : this.name(type.getName());
        this.logger.trace("Simple type: '{0}' in ns '{1}' ", new Object[]{type.getName(), type.getTargetNamespace()});
        Path path = this.nextPath(parentPath, nodeName);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.SIMPLE_TYPE_DEFINITION});
        this.output.setProperty(path, XsdLexicon.NAMESPACE, new Object[]{type.getTargetNamespace()});
        if (!isAnonymous) {
            this.output.setProperty(path, XsdLexicon.NC_NAME, new Object[]{type.getName()});
            UUID uuid = this.setUuid(path);
            this.resolvers.get(XsdResolvers.SymbolSpace.TYPE_DEFINITIONS).register(type.getTargetNamespace(), type.getName(), path, uuid);
        }
        this.processFacetsOf(type, path, type.getBaseType());
        this.processNonSchemaAttributes((XSDConcreteComponent)type, path);
        return path;
    }

    protected Path processFacetsOf(XSDSimpleTypeDefinition type, Path path, XSDTypeDefinition baseType) {
        if (baseType == null) {
            baseType = type.getBaseType();
        }
        if (baseType == type) {
            baseType = type.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
        }
        if (baseType != null) {
            this.output.setProperty(path, XsdLexicon.BASE_TYPE_NAME, new Object[]{baseType.getName()});
            this.output.setProperty(path, XsdLexicon.BASE_TYPE_NAMESPACE, new Object[]{baseType.getTargetNamespace()});
            this.setReference(path, XsdLexicon.BASE_TYPE_REFERENCE, XsdResolvers.SymbolSpace.TYPE_DEFINITIONS, baseType.getTargetNamespace(), baseType.getName());
        }
        this.process((XSDFacet)type.getEffectiveMaxLengthFacet(), path, XsdLexicon.MAX_LENGTH, PropertyType.LONG);
        this.process((XSDFacet)type.getMaxLengthFacet(), path, XsdLexicon.MAX_LENGTH, PropertyType.LONG);
        this.process((XSDFacet)type.getEffectiveMinLengthFacet(), path, XsdLexicon.MIN_LENGTH, PropertyType.LONG);
        this.process((XSDFacet)type.getMinLengthFacet(), path, XsdLexicon.MIN_LENGTH, PropertyType.LONG);
        this.process((XSDFacet)type.getEffectiveMaxFacet(), path, XsdLexicon.MAX_VALUE_EXCLUSIVE, PropertyType.LONG);
        this.process((XSDFacet)type.getMaxExclusiveFacet(), path, XsdLexicon.MAX_VALUE_EXCLUSIVE, PropertyType.LONG);
        this.process((XSDFacet)type.getEffectiveMinFacet(), path, XsdLexicon.MIN_VALUE_EXCLUSIVE, PropertyType.LONG);
        this.process((XSDFacet)type.getMinExclusiveFacet(), path, XsdLexicon.MIN_VALUE_EXCLUSIVE, PropertyType.LONG);
        this.process((XSDFacet)type.getMaxInclusiveFacet(), path, XsdLexicon.MAX_VALUE_INCLUSIVE, PropertyType.LONG);
        this.process((XSDFacet)type.getMinInclusiveFacet(), path, XsdLexicon.MIN_VALUE_INCLUSIVE, PropertyType.LONG);
        this.process((XSDFacet)type.getEffectiveTotalDigitsFacet(), path, XsdLexicon.TOTAL_DIGITS, PropertyType.LONG);
        this.process((XSDFacet)type.getTotalDigitsFacet(), path, XsdLexicon.TOTAL_DIGITS, PropertyType.LONG);
        this.process((XSDFacet)type.getEffectiveFractionDigitsFacet(), path, XsdLexicon.FRACTION_DIGITS, PropertyType.LONG);
        this.process((XSDFacet)type.getFractionDigitsFacet(), path, XsdLexicon.FRACTION_DIGITS, PropertyType.LONG);
        this.process((XSDFacet)type.getEffectiveWhiteSpaceFacet(), path, XsdLexicon.WHITESPACE, PropertyType.STRING);
        this.process((XSDFacet)type.getWhiteSpaceFacet(), path, XsdLexicon.WHITESPACE, PropertyType.STRING);
        this.process((XSDFacet)type.getEffectivePatternFacet(), path, XsdLexicon.PATTERN, PropertyType.STRING);
        EList patternFacets = type.getPatternFacets();
        this.process((Iterable)patternFacets, path, XsdLexicon.PATTERN, PropertyType.STRING);
        this.process((XSDFacet)type.getEffectiveEnumerationFacet(), path, XsdLexicon.ENUMERATED_VALUES, PropertyType.STRING);
        EList enumFacets = type.getEnumerationFacets();
        this.process((Iterable)enumFacets, path, XsdLexicon.ENUMERATED_VALUES, PropertyType.STRING);
        EList finalFacets2 = type.getFinal();
        this.processEnumerators((Iterable)finalFacets2, path, XsdLexicon.FINAL);
        this.process(type.getAnnotation(), path);
        return path;
    }

    protected Path process(XSDComplexTypeDefinition type, Path parentPath) {
        XSDTypeDefinition baseType;
        this.logger.trace("Complex type: '{0}' in ns '{1}' ", new Object[]{type.getName(), type.getTargetNamespace()});
        boolean isAnonymous = type.getName() == null;
        Name nodeName = isAnonymous ? XsdLexicon.COMPLEX_TYPE : this.name(type.getName());
        Path path = this.nextPath(parentPath, nodeName);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.COMPLEX_TYPE_DEFINITION});
        this.output.setProperty(path, XsdLexicon.NAMESPACE, new Object[]{type.getTargetNamespace()});
        if (!isAnonymous) {
            this.output.setProperty(path, XsdLexicon.NC_NAME, new Object[]{type.getName()});
            UUID uuid = this.setUuid(path);
            this.resolvers.get(XsdResolvers.SymbolSpace.TYPE_DEFINITIONS).register(type.getTargetNamespace(), type.getName(), path, uuid);
        }
        if ((baseType = type.getBaseType()) == type) {
            baseType = type.getSchema().getSchemaForSchema().resolveComplexTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
        }
        if (baseType != null) {
            this.output.setProperty(path, XsdLexicon.BASE_TYPE_NAME, new Object[]{baseType.getName()});
            this.output.setProperty(path, XsdLexicon.BASE_TYPE_NAMESPACE, new Object[]{baseType.getTargetNamespace()});
        }
        this.output.setProperty(path, XsdLexicon.ABSTRACT, new Object[]{type.isAbstract()});
        this.output.setProperty(path, XsdLexicon.MIXED, new Object[]{type.isMixed()});
        EList blocks = type.getBlock();
        this.processEnumerators((Iterable)blocks, path, XsdLexicon.BLOCK);
        EList finalFacets = type.getFinal();
        this.processEnumerators((Iterable)finalFacets, path, XsdLexicon.FINAL);
        this.process(type.getContent(), path);
        this.process(type.getAnnotation(), path);
        this.processNonSchemaAttributes((XSDConcreteComponent)type, path);
        return path;
    }

    protected Path process(XSDElementDeclaration decl, Path parentPath) {
        if (decl == null) {
            return null;
        }
        this.logger.trace("Element declaration: '{0}' in ns '{1}' ", new Object[]{decl.getName(), decl.getTargetNamespace()});
        Path path = null;
        if (decl.getName() != null) {
            this.logger.trace("Element declaration: '{0}' in ns '{1}' ", new Object[]{decl.getName(), decl.getTargetNamespace()});
            path = this.nextPath(parentPath, this.name(decl.getName()));
            this.output.setProperty(path, XsdLexicon.NC_NAME, new Object[]{decl.getName()});
            this.output.setProperty(path, XsdLexicon.NAMESPACE, new Object[]{decl.getTargetNamespace()});
        } else {
            assert (decl.isFeatureReference()) : "expected element reference";
            XSDElementDeclaration resolved = decl.getResolvedElementDeclaration();
            this.logger.trace("Element reference to '{0}' in ns '{1}' ", new Object[]{resolved.getName(), resolved.getTargetNamespace()});
            path = this.nextPath(parentPath, this.name(resolved.getName()));
            this.output.setProperty(path, XsdLexicon.REF_NAME, new Object[]{resolved.getName()});
            this.output.setProperty(path, XsdLexicon.REF_NAMESPACE, new Object[]{resolved.getTargetNamespace()});
            this.setReference(path, XsdLexicon.REF, XsdResolvers.SymbolSpace.ELEMENT_DECLARATION, resolved.getTargetNamespace(), resolved.getName());
        }
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.ELEMENT_DECLARATION});
        if (decl.isGlobal()) {
            UUID uuid = this.setUuid(path);
            this.resolvers.get(XsdResolvers.SymbolSpace.ELEMENT_DECLARATION).register(decl.getTargetNamespace(), decl.getName(), path, uuid);
        }
        this.output.setProperty(path, XsdLexicon.ABSTRACT, new Object[]{decl.isAbstract()});
        this.output.setProperty(path, XsdLexicon.NILLABLE, new Object[]{decl.isNillable()});
        XSDTypeDefinition type = decl.getType();
        if (type != null) {
            this.output.setProperty(path, XsdLexicon.TYPE_NAME, new Object[]{type.getName()});
            this.output.setProperty(path, XsdLexicon.TYPE_NAMESPACE, new Object[]{type.getTargetNamespace()});
            this.setReference(path, XsdLexicon.TYPE_REFERENCE, XsdResolvers.SymbolSpace.TYPE_DEFINITIONS, type.getTargetNamespace(), type.getName());
        }
        if (decl.getAnonymousTypeDefinition() == type) {
            if (type instanceof XSDComplexTypeDefinition) {
                this.process((XSDComplexTypeDefinition)type, path);
            } else if (type instanceof XSDSimpleTypeDefinition) {
                this.process((XSDSimpleTypeDefinition)type, path);
            }
        }
        this.processEnumerator(decl.getForm(), path, XsdLexicon.FORM);
        EList finals = decl.getLexicalFinal();
        this.processEnumerators((Iterable)finals, path, XsdLexicon.FINAL);
        EList blocks = decl.getBlock();
        this.processEnumerators((Iterable)blocks, path, XsdLexicon.BLOCK);
        this.process(decl.getAnnotation(), path);
        this.processNonSchemaAttributes((XSDConcreteComponent)type, path);
        return path;
    }

    protected Path process(XSDAttributeDeclaration decl, Path parentPath, boolean isUse) {
        XSDTypeDefinition type;
        if (decl == null) {
            return null;
        }
        this.logger.trace("Attribute declaration: '{0}' in ns '{1}' ", new Object[]{decl.getName(), decl.getTargetNamespace()});
        Path path = this.nextPath(parentPath, this.name(decl.getName()));
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.ATTRIBUTE_DECLARATION});
        this.output.setProperty(path, XsdLexicon.NC_NAME, new Object[]{decl.getName()});
        this.output.setProperty(path, XsdLexicon.NAMESPACE, new Object[]{decl.getTargetNamespace()});
        if (decl.isGlobal() && !isUse) {
            UUID uuid = this.setUuid(path);
            this.resolvers.get(XsdResolvers.SymbolSpace.ATTRIBUTE_DECLARATIONS).register(decl.getTargetNamespace(), decl.getName(), path, uuid);
        }
        if ((type = decl.getType()) != null) {
            this.output.setProperty(path, XsdLexicon.TYPE_NAME, new Object[]{type.getName()});
            this.output.setProperty(path, XsdLexicon.TYPE_NAMESPACE, new Object[]{type.getTargetNamespace()});
        }
        this.process(decl.getAnnotation(), path);
        this.processNonSchemaAttributes((XSDConcreteComponent)type, path);
        return path;
    }

    protected Path process(XSDComplexTypeContent content, Path parentPath) {
        EList attributeUses;
        EList attributeGroupContents;
        if (content == null) {
            return null;
        }
        XSDComplexTypeDefinition owner = (XSDComplexTypeDefinition)content.eContainer();
        Path resultPath = null;
        if (content instanceof XSDParticle) {
            resultPath = this.process((XSDParticle)content, parentPath);
        } else if (content instanceof XSDSimpleTypeDefinition) {
            Path simpleContentPath = this.nextPath(parentPath, XsdLexicon.SIMPLE_CONTENT);
            this.output.setProperty(simpleContentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.SIMPLE_CONTENT});
            this.processFacetsOf((XSDSimpleTypeDefinition)content, simpleContentPath, owner.getBaseTypeDefinition());
            resultPath = simpleContentPath;
        }
        XSDDerivationMethod method = owner.getDerivationMethod();
        if (method != null) {
            this.output.setProperty(parentPath, XsdLexicon.METHOD, new Object[]{method.getLiteral()});
        }
        if ((attributeGroupContents = owner.getAttributeContents()) != null) {
            for (XSDAttributeGroupContent attributeGroup : attributeGroupContents) {
                this.process(attributeGroup, parentPath);
            }
        }
        if ((attributeUses = owner.getAttributeUses()) != null) {
            for (XSDAttributeUse attributeUse : attributeUses) {
                this.process(attributeUse, parentPath);
            }
        }
        XSDWildcard wildcard = owner.getAttributeWildcard();
        this.process(wildcard, parentPath);
        this.processNonSchemaAttributes((XSDConcreteComponent)owner, parentPath);
        return resultPath;
    }

    protected Path process(XSDParticle content, Path parentPath) {
        if (content == null) {
            return null;
        }
        XSDParticleContent particle = content.getContent();
        Path path = null;
        if (particle instanceof XSDModelGroupDefinition) {
            path = this.process((XSDModelGroupDefinition)particle, parentPath);
        } else if (particle instanceof XSDElementDeclaration) {
            path = this.process((XSDElementDeclaration)particle, parentPath);
        } else if (particle instanceof XSDModelGroup) {
            path = this.process((XSDModelGroup)particle, parentPath);
        } else if (particle instanceof XSDWildcard) {
            path = this.process((XSDWildcard)particle, parentPath);
        }
        if (path != null) {
            long minOccurs = content.getMinOccurs();
            long maxOccurs = content.getMaxOccurs();
            this.output.setProperty(path, XsdLexicon.MIN_OCCURS, new Object[]{minOccurs});
            if (maxOccurs >= 0L) {
                this.output.setProperty(path, XsdLexicon.MAX_OCCURS, new Object[]{maxOccurs});
            }
        }
        return path;
    }

    protected Path process(XSDModelGroupDefinition defn, Path parentPath) {
        if (defn == null) {
            return null;
        }
        XSDModelGroup group = defn.getModelGroup();
        this.processNonSchemaAttributes((XSDConcreteComponent)defn, parentPath);
        return this.process(group, parentPath);
    }

    protected Path process(XSDModelGroup group, Path parentPath) {
        if (group == null) {
            return null;
        }
        XSDCompositor compositor = group.getCompositor();
        Name primaryTypeName = null;
        switch (compositor.getValue()) {
            case 0: {
                primaryTypeName = XsdLexicon.ALL;
                break;
            }
            case 1: {
                primaryTypeName = XsdLexicon.CHOICE;
                break;
            }
            case 2: {
                primaryTypeName = XsdLexicon.SEQUENCE;
                break;
            }
            default: {
                assert (false) : "should not get here";
                break;
            }
        }
        assert (primaryTypeName != null);
        Path path = this.nextPath(parentPath, primaryTypeName);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{primaryTypeName});
        EList particles = group.getParticles();
        for (XSDParticle particle : particles) {
            this.process(particle, path);
        }
        this.processNonSchemaAttributes((XSDConcreteComponent)group, path);
        return path;
    }

    protected Path process(XSDAttributeGroupContent content, Path parentPath) {
        if (content == null) {
            return null;
        }
        if (content instanceof XSDAttributeGroupDefinition) {
            return this.process((XSDAttributeGroupDefinition)content, parentPath);
        }
        if (content instanceof XSDAttributeUse) {
            return this.process((XSDAttributeUse)content, parentPath);
        }
        assert (false) : "should not get here";
        return null;
    }

    protected Path process(XSDAttributeGroupDefinition defn, Path parentPath) {
        if (defn == null) {
            return null;
        }
        Path path = null;
        if (defn.isAttributeGroupDefinitionReference()) {
            XSDAttributeGroupDefinition resolved = defn.getResolvedAttributeGroupDefinition();
            this.logger.trace("Attribute Group definition (ref): '{0}' in ns '{1}' ", new Object[]{resolved.getName(), resolved.getTargetNamespace()});
            path = this.nextPath(parentPath, this.name(resolved.getName()));
            this.output.setProperty(path, XsdLexicon.REF_NAME, new Object[]{resolved.getName()});
            this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.ATTRIBUTE_GROUP});
            this.setReference(path, XsdLexicon.REF, XsdResolvers.SymbolSpace.ATTRIBUTE_GROUP_DEFINITIONS, resolved.getTargetNamespace(), resolved.getName());
        } else {
            this.logger.trace("Attribute Group definition: '{0}' in ns '{1}' ", new Object[]{defn.getName(), defn.getTargetNamespace()});
            path = this.nextPath(parentPath, this.name(defn.getName()));
            UUID uuid = this.setUuid(path);
            this.resolvers.get(XsdResolvers.SymbolSpace.ATTRIBUTE_GROUP_DEFINITIONS).register(defn.getTargetNamespace(), defn.getName(), path, uuid);
            this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.ATTRIBUTE_GROUP});
            this.output.setProperty(path, XsdLexicon.NC_NAME, new Object[]{defn.getName()});
            this.output.setProperty(path, XsdLexicon.NAMESPACE, new Object[]{defn.getTargetNamespace()});
            for (Object child : defn.getContents()) {
                if (child instanceof XSDAttributeUse) {
                    this.process((XSDAttributeUse)child, path);
                    continue;
                }
                if (!(child instanceof XSDWildcard)) continue;
                this.process((XSDWildcard)child, path);
            }
        }
        this.process(defn.getAnnotation(), path);
        this.processNonSchemaAttributes((XSDConcreteComponent)defn, path);
        return path;
    }

    protected Path process(XSDWildcard wildcard, Path parentPath) {
        if (wildcard == null) {
            return null;
        }
        this.logger.trace("Any Attribute", new Object[0]);
        Path path = this.nextPath(parentPath, XsdLexicon.ANY_ATTRIBUTE);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{XsdLexicon.ANY_ATTRIBUTE});
        EList nsConstraints = wildcard.getNamespaceConstraint();
        if (nsConstraints != null && !nsConstraints.isEmpty()) {
            HashSet<String> values = new HashSet<String>();
            for (String nsConstraint : nsConstraints) {
                if (nsConstraint == null || (nsConstraint = nsConstraint.trim()).length() == 0) continue;
                values.add(nsConstraint);
            }
            if (!values.isEmpty()) {
                this.output.setProperty(path, XsdLexicon.NAMESPACE, values.toArray(new Object[values.size()]));
            }
        }
        if (wildcard.getProcessContents() != null) {
            XSDProcessContents processContents = wildcard.getProcessContents();
            this.output.setProperty(path, XsdLexicon.PROCESS_CONTENTS, new Object[]{processContents.getLiteral()});
        }
        this.process(wildcard.getAnnotation(), path);
        this.processNonSchemaAttributes((XSDConcreteComponent)wildcard, path);
        return path;
    }

    protected Path process(XSDAttributeUse use, Path parentPath) {
        Path path = this.process(use.getAttributeDeclaration(), parentPath, true);
        if (use.getUse() != null) {
            this.output.setProperty(path, XsdLexicon.USE, new Object[]{use.getUse().getLiteral()});
        }
        this.processNonSchemaAttributes((XSDConcreteComponent)use, path);
        return path;
    }

    protected Path processNonSchemaAttributes(XSDConcreteComponent component, Path path) {
        if (component == null) {
            return null;
        }
        Element element = component.getElement();
        if (element == null) {
            return null;
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return null;
        }
        int len = attributes.getLength();
        for (int i = 0; i != len; ++i) {
            String namespaceUri;
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() != 2 || "http://www.w3.org/2001/XMLSchema".equals(namespaceUri = attribute.getNamespaceURI())) continue;
            String localName = attribute.getLocalName();
            String value = attribute.getNodeValue();
            if (value == null) continue;
            if (namespaceUri != null) {
                this.prefixForNamespace(namespaceUri, attribute.getPrefix());
                this.output.setProperty(path, this.name(namespaceUri, localName), new Object[]{value});
                continue;
            }
            this.output.setProperty(path, this.name(localName), new Object[]{value});
        }
        return path;
    }

    protected String prefixForNamespace(String namespaceUri, String defaultPrefix) {
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        String prefix = registry.getPrefixForNamespaceUri(namespaceUri, false);
        if (prefix == null) {
            if (defaultPrefix == null) {
                prefix = registry.getPrefixForNamespaceUri(namespaceUri, true);
            } else {
                int counter = 2;
                String proposedPrefix = defaultPrefix;
                while (registry.getNamespaceForPrefix(proposedPrefix) != null) {
                    proposedPrefix = defaultPrefix + counter++;
                }
                prefix = registry.register(proposedPrefix, namespaceUri);
            }
        }
        return prefix;
    }

    protected Path process(XSDAnnotation annotation, Path path) {
        if (annotation != null) {
            StringBuilder sb = new StringBuilder();
            for (Object obj : annotation.getUserInformation()) {
                String content;
                Element element = (Element)obj;
                if (!element.getLocalName().equals("documentation") || (content = element.getTextContent()) == null) continue;
                sb.append(content);
            }
            if (sb.length() != 0) {
                String content = sb.toString();
                if ((content = content.trim()).length() != 0) {
                    this.output.setProperty(path, SrampLexicon.DESCRIPTION, new Object[]{content});
                }
            }
        }
        return path;
    }

    protected Path process(Iterable<XSDAnnotation> annotations, Path path) {
        if (annotations != null) {
            StringBuilder sb = new StringBuilder();
            for (XSDAnnotation annotation : annotations) {
                for (Object obj : annotation.getUserInformation()) {
                    String content;
                    Element element = (Element)obj;
                    if (!element.getLocalName().equals("documentation") || (content = element.getTextContent()) == null) continue;
                    sb.append(content);
                }
                sb.append("\n");
            }
            if (sb.length() != 0) {
                String content = sb.toString();
                if ((content = content.trim()).length() != 0) {
                    this.output.setProperty(path, SrampLexicon.DESCRIPTION, new Object[]{content});
                }
            }
        }
        return path;
    }

    protected void process(XSDFacet facet, Path path, Name propertyName, PropertyType type) {
        if (facet != null) {
            String lexicalValue = facet.getLexicalValue();
            if (lexicalValue != null) {
                Object value = this.context.getValueFactories().getValueFactory(type).create(facet.getLexicalValue());
                this.output.setProperty(path, propertyName, new Object[]{value});
            } else if (facet instanceof XSDRepeatableFacet) {
                HashSet<String> values = new HashSet<String>();
                EList facetValues = null;
                if (facet instanceof XSDPatternFacet) {
                    facetValues = ((XSDPatternFacet)facet).getValue();
                } else if (facet instanceof XSDEnumerationFacet) {
                    facetValues = ((XSDEnumerationFacet)facet).getValue();
                }
                if (facetValues != null && !facetValues.isEmpty()) {
                    for (Object enumValue : facetValues) {
                        values.add(this.string(enumValue));
                    }
                }
                if (!values.isEmpty()) {
                    this.output.setProperty(path, propertyName, values.toArray(new Object[values.size()]));
                }
            }
        }
    }

    protected <Facet extends XSDFacet> void process(Iterable<Facet> facets, Path path, Name propertyName, PropertyType type) {
        if (facets != null) {
            HashSet<String> values = new HashSet<String>();
            for (XSDFacet facet : facets) {
                String lexicalValue = facet.getLexicalValue();
                if (lexicalValue != null) {
                    values.add(this.string(facet.getLexicalValue()));
                    continue;
                }
                if (!(facet instanceof XSDRepeatableFacet)) continue;
                EList facetValues = null;
                if (facet instanceof XSDPatternFacet) {
                    facetValues = ((XSDPatternFacet)facet).getValue();
                } else if (facet instanceof XSDEnumerationFacet) {
                    facetValues = ((XSDEnumerationFacet)facet).getValue();
                }
                if (facetValues == null || facetValues.isEmpty()) continue;
                for (Object enumValue : facetValues) {
                    values.add(this.string(enumValue));
                }
            }
            if (!values.isEmpty()) {
                this.output.setProperty(path, propertyName, values.toArray(new Object[values.size()]));
            }
        }
    }

    protected <Enumerator extends AbstractEnumerator> void processEnumerators(Iterable<Enumerator> enumerators, Path path, Name propertyName) {
        if (enumerators != null) {
            HashSet<String> values = new HashSet<String>();
            for (AbstractEnumerator enumValue : enumerators) {
                String value = enumValue.getLiteral();
                if (value == null) continue;
                values.add(value);
            }
            if (!values.isEmpty()) {
                this.output.setProperty(path, propertyName, values.toArray(new Object[values.size()]));
            }
        }
    }

    protected <Enumerator extends AbstractEnumerator> void processEnumerator(Enumerator enumerator, Path path, Name propertyName) {
        String value;
        if (enumerator != null && (value = enumerator.getLiteral()) != null) {
            this.output.setProperty(path, propertyName, new Object[]{value});
        }
    }

    protected Path nextPath(Path parentPath, Name name) {
        HashMultimap names = this.namesByParentPath.get(parentPath);
        int sns = 1;
        if (names == null) {
            names = HashMultimap.create();
            names.put((Object)name, (Object)sns);
            this.namesByParentPath.put(parentPath, (Multimap<Name, Integer>)names);
        } else {
            sns = names.get((Object)name).size() + 1;
            names.put((Object)name, (Object)1);
        }
        return this.context.getValueFactories().getPathFactory().create(parentPath, name, sns);
    }

    protected Path path(Path parentPath, Name segment) {
        return this.context.getValueFactories().getPathFactory().create(parentPath, new Name[]{segment});
    }

    protected Path path(Path parentPath, String segment) {
        return this.context.getValueFactories().getPathFactory().create(parentPath, segment);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Name name(String namespaceUri, String name) {
        return this.context.getValueFactories().getNameFactory().create(namespaceUri, name);
    }

    protected String string(Object value) {
        return (String)this.context.getValueFactories().getStringFactory().create(value);
    }

    protected UUID setUuid(Path path) {
        UUID uuid = this.context.getValueFactories().getUuidFactory().create();
        this.output.setProperty(path, JcrLexicon.UUID, new Object[]{uuid});
        return uuid;
    }

    public void resolveReferences() {
        if (this.resolveFutures.isEmpty()) {
            return;
        }
        List<ResolveFuture> futures = this.resolveFutures;
        this.resolveFutures = new LinkedList<ResolveFuture>();
        for (ResolveFuture future : futures) {
            future.resolve();
        }
    }

    protected UUID setReference(Path path, Name propertyName, XsdResolvers.SymbolSpace kind, String namespace, String name) {
        UUID typeUuid = this.resolvers.get(kind).lookup(namespace, name);
        if (typeUuid != null) {
            this.output.setProperty(path, propertyName, new Object[]{typeUuid});
        } else {
            this.resolveFutures.add(new ResolveFuture(path, propertyName, kind, namespace, name));
        }
        return typeUuid;
    }

    protected class ResolveFuture {
        private final Path path;
        private final Name propertyName;
        private final XsdResolvers.SymbolSpace refKind;
        private final String refNamespace;
        private final String refName;

        protected ResolveFuture(Path path, Name propertyName, XsdResolvers.SymbolSpace kind, String namespace, String name) {
            this.path = path;
            this.propertyName = propertyName;
            this.refKind = kind;
            this.refNamespace = namespace;
            this.refName = name;
        }

        protected UUID resolve() {
            return XsdReader.this.setReference(this.path, this.propertyName, this.refKind, this.refNamespace, this.refName);
        }
    }
}

