/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jcr;

import javax.naming.Context;
import org.mockito.Mockito;
import org.modeshape.connector.jcr.JcrConnectorTestUtil;
import org.modeshape.connector.jcr.JcrRepositorySource;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.WorkspaceConnectorTest;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class JcrConnectorNoCreateWorkspaceTest
extends WorkspaceConnectorTest {
    private static JcrEngine engine;
    private static Context jndiContext;

    protected RepositorySource setUpSource() throws Exception {
        String carRepositoryJndiName = "cars repository in jndi";
        String aircraftRepositoryJndiName = "aircraft repository in jndi";
        if (engine == null) {
            engine = JcrConnectorTestUtil.loadEngine();
            JcrRepository carsRepository = engine.getRepository("Cars");
            JcrRepository aircraftRepository = engine.getRepository("Aircraft");
            jndiContext = (Context)Mockito.mock(Context.class);
            Mockito.when((Object)jndiContext.lookup("cars repository in jndi")).thenReturn((Object)carsRepository);
            Mockito.when((Object)jndiContext.lookup("aircraft repository in jndi")).thenReturn((Object)aircraftRepository);
        }
        JcrRepositorySource source = new JcrRepositorySource();
        source.setName("Test Repository");
        source.setRepositoryJndiName("cars repository in jndi");
        source.setUsername("superuser");
        source.setPassword("superuser");
        source.setContext(jndiContext);
        return source;
    }

    protected void initializeContent(Graph graph) throws Exception {
    }

    protected String[] generateInvalidNamesForNewWorkspaces() {
        return new String[]{"trains", "ships"};
    }

    protected String[] generateValidNamesForNewWorkspaces() {
        return new String[0];
    }
}

