/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hibernate.ejb.Ejb3Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.connector.store.jpa.model.common.NamespaceEntity;
import org.modeshape.connector.store.jpa.model.simple.LargeValueEntity;
import org.modeshape.connector.store.jpa.model.simple.NodeEntity;
import org.modeshape.connector.store.jpa.model.simple.SimpleModel;
import org.modeshape.connector.store.jpa.model.simple.SubgraphQuery;
import org.modeshape.graph.property.PropertyType;

public class NodeEntityTest {
    private static final Boolean SHOW_SQL = false;
    private static final Boolean USE_CACHE = false;
    private EntityManagerFactory factory;
    private EntityManager manager;
    private SimpleModel model;

    @Before
    public void beforeEach() throws Exception {
        this.model = new SimpleModel();
        Ejb3Configuration configurator = new Ejb3Configuration();
        for (Class clazz : this.model.getEntityClasses()) {
            configurator.addAnnotatedClass(clazz);
        }
        configurator.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        configurator.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        configurator.setProperty("hibernate.connection.username", "sa");
        configurator.setProperty("hibernate.connection.password", "");
        configurator.setProperty("hibernate.connection.url", "jdbc:hsqldb:mem:.");
        configurator.setProperty("hibernate.show_sql", SHOW_SQL.toString());
        configurator.setProperty("hibernate.format_sql", "true");
        configurator.setProperty("hibernate.use_sql_comments", "true");
        configurator.setProperty("hibernate.hbm2ddl.auto", "create");
        if (USE_CACHE.booleanValue()) {
            configurator.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
        } else {
            configurator.setProperty("hibernate.cache.use_second_level_cache", "false");
        }
        this.factory = configurator.buildEntityManagerFactory();
        this.manager = this.factory.createEntityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        try {
            if (this.manager != null) {
                this.manager.close();
            }
        }
        finally {
            this.manager = null;
            if (this.factory != null) {
                try {
                    this.factory.close();
                }
                finally {
                    this.factory = null;
                }
            }
        }
    }

    @Test
    public void shouldSaveAndReloadNode() {
        String rootUuid = UUID.randomUUID().toString();
        long workspaceId = 1L;
        this.manager.getTransaction().begin();
        NamespaceEntity namespace = new NamespaceEntity("");
        this.manager.persist((Object)namespace);
        NodeEntity root = new NodeEntity(0L, null, rootUuid, workspaceId, 1, namespace, "root");
        LargeValueEntity largeValue = LargeValueEntity.create((byte[])"This is a nonsense string that I am typing.".getBytes(), (PropertyType)PropertyType.STRING, (boolean)false);
        root.getLargeValues().add(largeValue);
        this.manager.persist((Object)root);
        this.manager.persist((Object)largeValue);
        int NUM_CHILDREN = 10;
        for (int i = 0; i < 10; ++i) {
            NodeEntity child = new NodeEntity(0L, root, UUID.randomUUID().toString(), workspaceId, 1, namespace, "child" + i);
            root.addChild(child);
            this.manager.persist((Object)child);
        }
        this.manager.getTransaction().commit();
        this.manager.close();
        this.manager = this.factory.createEntityManager();
        Query query = this.manager.createNamedQuery("NodeEntity.findByNodeUuid");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("nodeUuidString", (Object)rootUuid);
        NodeEntity newRoot = (NodeEntity)query.getSingleResult();
        Assert.assertThat((Object)newRoot, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)newRoot, (Matcher)Is.is((Object)root));
        Assert.assertThat((Object)newRoot.getChildren().size(), (Matcher)Is.is((Object)10));
        for (int i = 0; i < 10; ++i) {
            Assert.assertThat((Object)((NodeEntity)newRoot.getChildren().get(i)).getChildName(), (Matcher)Is.is((Object)("child" + i)));
        }
        root.getLargeValues().size();
    }

    @Test
    public void shouldDeleteRecursively() {
        String rootUuid = UUID.randomUUID().toString();
        long workspaceId = 1L;
        this.manager.getTransaction().begin();
        NamespaceEntity namespace = new NamespaceEntity("");
        this.manager.persist((Object)namespace);
        NodeEntity root = new NodeEntity(0L, null, rootUuid, workspaceId, 1, namespace, "root");
        this.manager.persist((Object)root);
        int DEPTH = 10;
        NodeEntity parent = root;
        for (int i = 0; i < 10; ++i) {
            NodeEntity child = new NodeEntity(0L, parent, UUID.randomUUID().toString(), workspaceId, 1, namespace, "child" + i);
            root.addChild(child);
            this.manager.persist((Object)child);
            parent = child;
        }
        this.manager.getTransaction().commit();
        this.manager.close();
        this.manager = this.factory.createEntityManager();
        this.manager.getTransaction().begin();
        SubgraphQuery subgraph = SubgraphQuery.create((EntityManager)this.manager, (Long)workspaceId, (UUID)UUID.fromString(rootUuid), (int)0);
        subgraph.deleteSubgraph(true);
        subgraph.close();
        int count = (Integer)this.manager.createNativeQuery("SELECT count(*) FROM mode_simple_node").getSingleResult();
        Assert.assertThat((Object)count, (Matcher)Is.is((Object)0));
        this.manager.getTransaction().commit();
    }
}

