/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.jpa;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.jcr.Credentials;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.test.ModeShapeUnitTest;

public class JcrRepositoryWithJpaSourceTest
extends ModeShapeUnitTest {
    private JcrEngine engine;
    private Repository repository;
    private Session session;
    private Credentials credentials;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas((String)"security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() throws Exception {
        URL configUrl = ((Object)((Object)this)).getClass().getResource("/tck/simple-jpa/configRepository.xml");
        String workspaceName = "otherWorkspace";
        assert (configUrl != null);
        JcrConfiguration config = new JcrConfiguration();
        config.loadFrom(configUrl);
        this.engine = config.build();
        this.engine.start();
        this.credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        this.repository = this.engine.getRepository("Test Repository Source");
        assert (this.repository != null);
        this.session = this.repository.login(this.credentials, "otherWorkspace");
        assert (this.session != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        block12: {
            if (this.engine != null) {
                try {
                    if (this.session == null) break block12;
                    try {
                        this.session.logout();
                    }
                    finally {
                        this.session = null;
                    }
                }
                finally {
                    this.repository = null;
                    try {
                        this.engine.shutdown();
                    }
                    finally {
                        this.engine = null;
                    }
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToRemoveNodeThatExists_Mode691() throws RepositoryException {
        Node root = this.session.getRootNode();
        Node a = root.addNode("a");
        Node b = a.addNode("b");
        Node c = b.addNode("c");
        Node d1 = c.addNode("d_one");
        Node d2 = c.addNode("d_two");
        this.session.save();
        root = this.session.getRootNode();
        String pathToNode = "a/b";
        Assert.assertThat((Object)root.hasNode(pathToNode), (Matcher)Is.is((Object)true));
        Node nodeToDelete = root.getNode(pathToNode);
        nodeToDelete.remove();
        this.session.save();
        root = this.session.getRootNode();
        Assert.assertThat((Object)root.hasNode(pathToNode), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowCreatingWorkspaces() throws Exception {
        String workspaceName = "MyNewWorkspace";
        Session jcrSession = this.repository.login();
        Workspace defaultWorkspace = jcrSession.getWorkspace();
        defaultWorkspace.createWorkspace(workspaceName);
        this.assertAccessibleWorkspace(defaultWorkspace, workspaceName);
        jcrSession.logout();
        Session session2 = this.repository.login(workspaceName);
        session2.logout();
    }

    @Test
    @FixFor(value={"MODE-1066"})
    public void shouldReimportContentThatWasJustDeletedInPriorSave() throws Exception {
        this.registerNodeTypes("io/cars.cnd", this.session);
        this.session.getRootNode().addNode("workArea");
        this.session.save();
        InputStream stream = this.resourceStream("io/cars-system-view.xml");
        this.session.importXML("/workArea", stream, 3);
        this.session.save();
        this.session.getNode("/workArea/Cars").remove();
        this.session.save();
        stream = this.resourceStream("io/cars-system-view.xml");
        this.session.importXML("/workArea", stream, 3);
        this.session.save();
    }

    @Test
    @FixFor(value={"MODE-1066"})
    public void shouldReimportContentThatWasJustDeletedInSameSave() throws Exception {
        this.registerNodeTypes("io/cars.cnd", this.session);
        this.session.getRootNode().addNode("workArea");
        this.session.save();
        for (int i = 0; i != 3; ++i) {
            InputStream stream = this.resourceStream("io/cars-system-view.xml");
            this.session.importXML("/workArea", stream, 3);
            this.session.getNode("/workArea/Cars").remove();
        }
        this.session.save();
    }

    @Test
    @FixFor(value={"MODE-1066"})
    public void shouldReimportContentWithUuidsThatWasJustDeletedInPriorSave() throws Exception {
        this.registerNodeTypes("io/cars.cnd", this.session);
        this.session.getRootNode().addNode("workArea");
        this.session.save();
        InputStream stream = this.resourceStream("io/cars-system-view-with-uuids.xml");
        this.session.importXML("/workArea", stream, 3);
        this.session.save();
        this.session.getNode("/workArea/Cars").remove();
        this.session.save();
        stream = this.resourceStream("io/cars-system-view-with-uuids.xml");
        this.session.importXML("/workArea", stream, 3);
        this.session.save();
    }

    @Test
    @FixFor(value={"MODE-1066"})
    public void shouldReimportContentWithUuidsThatWasJustDeletedInSameSave() throws Exception {
        this.registerNodeTypes("io/cars.cnd", this.session);
        this.session.getRootNode().addNode("workArea");
        this.session.save();
        for (int i = 0; i != 3; ++i) {
            InputStream stream = this.resourceStream("io/cars-system-view-with-uuids.xml");
            this.session.importXML("/workArea", stream, 3);
            this.session.getNode("/workArea/Cars").remove();
        }
        this.session.save();
    }

    @Test
    @FixFor(value={"MODE-1241"})
    public void shouldBeAbleToCreateBinaryProperty() throws Exception {
        String fileMime = "application/octet-stream";
        GregorianCalendar lastModified = new GregorianCalendar(2010, 12, 2, 8, 30);
        Node root = this.session.getRootNode();
        Node file = root.addNode("createfile.mode", "nt:file");
        Node content = file.addNode("jcr:content", "nt:resource");
        File f = new File("./src/test/resources/test.txt");
        if (!f.exists()) {
            throw new Exception("File " + f.getAbsolutePath() + " is not found");
        }
        System.out.println("FILE: " + f.getAbsolutePath());
        FileInputStream is = new FileInputStream(f);
        content.setProperty("jcr:data", this.session.getValueFactory().createBinary((InputStream)is));
        content.setProperty("jcr:mimeType", fileMime);
        content.setProperty("jcr:encoding", "");
        content.setProperty("jcr:lastModified", (Calendar)lastModified);
        this.session.save();
    }

    @Test
    @FixFor(value={"MODE-1421"})
    public void removeItemAfterRegisteringSessionNamespace() throws Exception {
        NamespaceRegistry namespaceRegistry = this.session.getWorkspace().getNamespaceRegistry();
        namespaceRegistry.registerNamespace("rh", "http://www.redhat.com");
        this.session.setNamespacePrefix("rh", "http://www.redhat.com");
        Assert.assertNotNull((Object)namespaceRegistry.getURI("rh"));
        Node rootNode = this.session.getRootNode();
        rootNode.addNode("folder", "nt:folder");
        this.session.save();
        this.session.removeItem("/folder");
        this.session.save();
    }

    @Test
    @Ignore(value="Ignored atm because it doesn't reproduce the issue and takes quite a bit of time to run")
    @FixFor(value={"MODE-1470"})
    public void jpaEntityShouldNotHaveNullId() throws Exception {
        int nodesCount = 100;
        Session session = this.repository.login(this.credentials);
        for (int i = 0; i < 100; ++i) {
            session.getRootNode().addNode("foo" + i);
        }
        session.save();
        int repeatCount = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Callable<Void> modifierTask = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Random rand = new Random();
                Session session = JcrRepositoryWithJpaSourceTest.this.repository.login(JcrRepositoryWithJpaSourceTest.this.credentials);
                for (int i = 0; i < 100; ++i) {
                    int nodeSuffix = rand.nextInt(100);
                    try {
                        Node foo = session.getNode("/foo" + nodeSuffix);
                        Thread.sleep(rand.nextInt(500));
                        foo.addNode("bar");
                        session.save();
                        continue;
                    }
                    catch (RepositoryException pnf) {
                        // empty catch block
                    }
                }
                session.logout();
                return null;
            }
        };
        Callable<Void> removerTask = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Random rand = new Random();
                Session session = JcrRepositoryWithJpaSourceTest.this.repository.login(JcrRepositoryWithJpaSourceTest.this.credentials);
                for (int i = 0; i < 100; ++i) {
                    int nodeSuffix = rand.nextInt(100);
                    try {
                        session.getNode("/foo" + nodeSuffix).remove();
                        session.save();
                        continue;
                    }
                    catch (PathNotFoundException pnf) {
                        // empty catch block
                    }
                }
                session.logout();
                return null;
            }
        };
        Future<Void> modifierResult = executorService.submit(modifierTask);
        Future<Void> removerResult = executorService.submit(removerTask);
        modifierResult.get();
        removerResult.get();
    }

    protected void registerNodeTypes(String pathToCndResourceFile, Session session) throws IOException, RepositoryException {
        CndNodeTypeReader reader = new CndNodeTypeReader(session);
        reader.read(pathToCndResourceFile);
        if (!reader.getProblems().isEmpty()) {
            System.err.println(reader.getProblems());
            Assert.fail((String)("Error loading the CND file at '" + pathToCndResourceFile + "'"));
        } else {
            boolean allowUpdate = false;
            session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), allowUpdate);
        }
    }

    protected InputStream resourceStream(String resourcePath) {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return stream;
    }

    protected void assertAccessibleWorkspace(Session session, String workspaceName) throws Exception {
        this.assertAccessibleWorkspace(session.getWorkspace(), workspaceName);
    }

    protected void assertAccessibleWorkspace(Workspace workspace, String workspaceName) throws Exception {
        this.assertContains(workspace.getAccessibleWorkspaceNames(), workspaceName);
    }

    protected void assertContains(String[] actuals, String ... expected) {
        for (String expect : expected) {
            if (expect == null) continue;
            boolean found = false;
            for (String actual : actuals) {
                if (!expect.equals(actual)) continue;
                found = true;
                break;
            }
            Assert.assertThat((String)("Did not find '" + expect + "' in the actuals: " + actuals), (Object)found, (Matcher)Is.is((Object)true));
        }
    }
}

