/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import javax.jcr.Node;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.test.ModeShapeUnitTest;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class XmlSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForXmlSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("xhtml", "http://www.w3.org/1999/xhtml");
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("mathml", "http://www.w3.org/1998/Math/MathML");
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("svg", "http://www.w3.org/2000/svg");
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void generateSequencerOutputForXmlSequencerChapterOfReferenceGuide() throws Exception {
        this.uploadFile("docForReferenceGuide.xml", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xml", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldSequenceXmlFile() throws Exception {
        this.uploadFile("jcr-import-test.xml", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xml", "nt:unstructured", new String[0]));
        String path = "/sequenced/xml/jcr-import-test.xml";
        Node xml = this.assertNode(path, "modexml:document", new String[]{"mode:derived"});
        this.printSubgraph(xml);
        this.printQuery("SELECT * FROM [modexml:document]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'xhtml:head'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'xhtml:title'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'svg:ellipse'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'svg:rect'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'xhtml:p'", 2L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:elementContent]", 13L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    public void shouldSequenceXmlFileBelowSequencedPath() throws Exception {
        this.uploadFile("jcr-import-test.xml", "/files/a/b");
        String path = "/sequenced/xml/a/b/jcr-import-test.xml";
        Node xml = this.waitUntilSequencedNodeIsAvailable(path, "modexml:document", new String[]{"mode:derived"});
        this.printSubgraph(xml);
        this.printQuery("SELECT * FROM [modexml:document]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'xhtml:head'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'xhtml:title'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'svg:ellipse'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'svg:rect'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:element] WHERE NAME() = 'xhtml:p'", 2L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [modexml:elementContent]", 13L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    @FixFor(value={"MODE-981"})
    public void shouldSequence2XmlFiles2() throws Exception {
        this.uploadFile("docWithComments.xml", "/files/");
        this.waitUntilSequencedNodeIsAvailable("/sequenced/xml/docWithComments.xml", "modexml:document", new String[]{"mode:derived"});
        this.printQuery("SELECT * FROM [nt:base] ORDER BY [jcr:path]", 17L, new ModeShapeUnitTest.Variable[0]);
        this.uploadFile("docWithComments2.xml", "/files/");
        this.waitUntilSequencedNodeIsAvailable("/sequenced/xml/docWithComments2.xml", "modexml:document", new String[]{"mode:derived"});
        this.printQuery("SELECT * FROM [nt:base]  ORDER BY [jcr:path]", 30L, new ModeShapeUnitTest.Variable[0]);
        this.printSubgraph(this.assertNode("/sequenced/xml", "nt:unstructured", new String[0]));
        this.uploadFile("docWithComments.xml", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xml", "nt:unstructured", new String[0]));
    }
}

