/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class XsdSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForXsdSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("sramp", "http://s-ramp.org/xmlns/2010/s-ramp");
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void generateSequencerOutputForStockQuoteSchema() throws Exception {
        this.uploadFile("sequencers/xsd/stockQuote.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForStockQuoteWithDefaultNamespaceSchema() throws Exception {
        this.uploadFile("sequencers/xsd/stockQuoteWithDefaultNamespace.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForPurchaseOrderSchema() throws Exception {
        this.uploadFile("sequencers/xsd/po.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3Schema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3CustodySchema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3custody.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3PolicyInstanceParametersSchema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3policy_instanceParms.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3PolicySchema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3policy.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3ReplicationSchema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3replication.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3SubscriptionListenerSchema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3subscriptionListener.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3ValueSetSchema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3valueset.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForUddiV3ValueSetCachingSchema() throws Exception {
        this.uploadFile("sequencers/xsd/uddi_v3valuesetcaching.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter01Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter01.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter03EnvSchema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter03env.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter03OrdSchema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter03ord.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter03ProdSchema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter03prod.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter03Prod2Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter03prod2.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter04CustSchema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter04cust.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter04Ord1Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter04ord1.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter04Ord2Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter04ord2.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter04ProdSchema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter04prod.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter05OrdSchema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter05ord.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter05ProdSchema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter05prod.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter07Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter07.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter08Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter08.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter09Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter09.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter11Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter11.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter13Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter13.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter014Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter14.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter015Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter15.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter016Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter16.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }

    @Test
    public void generateSequencerOutputForDefinitiveChapter017Schema() throws Exception {
        this.uploadFile("sequencers/xsd/definitiveXmlSchema/chapter17.xsd", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/xsd", "nt:unstructured", new String[0]));
    }
}

