/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl.dialect.postgres;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.ddl.AbstractDdlIntegrationTest;

public class PostgresDdlSequencerIntegrationTest
extends AbstractDdlIntegrationTest {
    private static final String RESOURCE_FOLDER = "org/modeshape/test/integration/sequencer/ddl//dialect/postgres/";

    @Override
    protected void addCustomConfiguration() {
        this.config.repository("ddlRepository").addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/dialect/postgres/PostgresDdl.cnd")).registerNamespace("postgresddl", "http://www.modeshape.org/ddl/postgres/1.0");
    }

    @Test
    public void shouldSequencePostgresDdlFile() throws Exception {
        this.uploadFile(RESOURCE_FOLDER, "postgres_test_statements.ddl");
        this.waitUntilSequencedNodesIs(1);
        Node ddlsNode = this.getStatementsContainer();
        NodeIterator iter = ddlsNode.getNodes();
        while (iter.hasNext()) {
            Node ddlNode = iter.nextNode();
            long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
            Assert.assertEquals((long)numStatements, (long)106L);
            this.verifyNodeType(ddlNode, "increment", "postgresddl:createFunctionStatement");
            this.verifyNode(ddlNode, "increment", "ddl:expression");
            this.verifyNodeType(ddlNode, "increment", "ddl:creatable");
            this.verifyNodeType(ddlNode, "increment", "postgresddl:functionOperand");
            this.verifyNode(ddlNode, "increment", "ddl:startLineNumber", 214);
            this.verifyNode(ddlNode, "increment", "ddl:startCharIndex", 7604);
            this.verifyNodeType(ddlNode, "my_function", "postgresddl:commentOnStatement");
            this.verifyNode(ddlNode, "my_function", "ddl:expression");
            this.verifyNodeType(ddlNode, "my_function", "postgresddl:commentOperand");
            this.verifyNode(ddlNode, "my_function", "ddl:startLineNumber", 44);
            this.verifyNode(ddlNode, "my_function", "ddl:startCharIndex", 1573);
            this.verifyNode(ddlNode, "my_function", "postgresddl:comment", "'Returns Roman Numeral'");
            Node alterTableNode = this.findNode(ddlNode, "foreign_companies", "postgresddl:alterTableStatement");
            Assert.assertNotNull((Object)alterTableNode);
            Node renameColNode = this.findNode(alterTableNode, "address", "postgresddl:renamedColumn");
            Assert.assertNotNull((Object)renameColNode);
            this.verifySingleValueProperty(renameColNode, "ddl:newName", "city");
            Node grantNode = this.findNode(ddlNode, "divideByTwo", "postgresddl:grantOnFunctionStatement");
            Assert.assertNotNull((Object)grantNode);
            Node parameter_1 = this.findNode(grantNode, "numerator", "postgresddl:functionParameter");
            Assert.assertNotNull((Object)parameter_1);
            this.verifySingleValueProperty(parameter_1, "ddl:datatypeName", "int");
        }
    }
}

