/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.io.InputStream;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.msoffice.MSOfficeMetadataSequencer;

public class MSOfficeMetadataSequencerTest {
    private MSOfficeMetadataSequencer sequencer;
    private InputStream input;
    private MockSequencerOutput output;
    private ExecutionContext context;
    private StreamSequencerContext sequencingContext;

    @Before
    public void beforeEach() throws Exception {
        this.sequencer = new MSOfficeMetadataSequencer();
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("msoffice", "http://www.modeshape.org/msoffice/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.context.getNamespaceRegistry().register("mix", "http://www.jcp.org/jcr/mix/1.0");
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.input != null) {
            try {
                this.input.close();
            }
            finally {
                this.input = null;
            }
        }
    }

    protected InputStream getTestDocument(String resourcePath) {
        InputStream result = this.getClass().getResourceAsStream("/" + resourcePath);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return result;
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithOneLine() {
        this.input = this.getTestDocument("word.doc");
        Path inputPath = (Path)this.context.getValueFactories().getPathFactory().create("/files/word.doc");
        HashSet props = new HashSet();
        String mimeType = "application/msword";
        this.sequencingContext = new StreamSequencerContext(this.context, inputPath, props, mimeType, (Problems)new SimpleProblems());
        this.output = new MockSequencerOutput(this.sequencingContext);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.sequencingContext);
        if (this.sequencingContext.getProblems().hasProblems()) {
            System.out.println("Problems sequencing \"word.doc\"");
        }
        Assert.assertThat((Object)this.sequencingContext.getProblems().hasProblems(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.output.getProperty("word.doc/msoffice:metadata", "msoffice:author").getFirstValue(), (Matcher)Is.is((Object)"Michael Trezzi"));
    }
}

