/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.classfile.metadata;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Graph;
import org.modeshape.sequencer.classfile.ClassFileSequencer;
import org.modeshape.sequencer.classfile.MockEnum;
import org.modeshape.sequencer.classfile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.classfile.metadata.ClassFileMetadataReader;
import org.modeshape.sequencer.classfile.metadata.ClassMetadata;
import org.modeshape.sequencer.classfile.metadata.EnumMetadata;
import org.modeshape.sequencer.classfile.metadata.FieldMetadata;
import org.modeshape.sequencer.classfile.metadata.MethodMetadata;
import org.modeshape.sequencer.classfile.metadata.Visibility;

public class ClassFileMetadataReaderTest {
    private InputStream input;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.input != null) {
            try {
                this.input.close();
            }
            finally {
                this.input = null;
            }
        }
    }

    @Test
    public void shouldReadJavaLangObject() throws Exception {
        this.compareMetadataToClass(Object.class);
    }

    @Test
    public void shouldReadJavaLangString() throws Exception {
        this.compareMetadataToClass(String.class);
    }

    @Test
    public void shouldReadOrgJbossDnaGraph() throws Exception {
        this.compareMetadataToClass(Graph.class);
    }

    @Test
    public void shouldReadOrgJbossDnaSequencerClassfileClassFileSequencer() throws Exception {
        this.compareMetadataToClass(ClassFileSequencer.class);
    }

    @Test
    public void shouldReadEnum() throws Exception {
        String resourceName = "/" + MockEnum.class.getName().replace('.', '/') + ".class";
        this.input = this.getClass().getResourceAsStream(resourceName);
        ClassMetadata cmd = ClassFileMetadataReader.instance((InputStream)this.input);
        Assert.assertThat((Object)cmd, (Matcher)IsInstanceOf.instanceOf(EnumMetadata.class));
        EnumMetadata emd = (EnumMetadata)cmd;
        List<String> enumValues = Arrays.asList("VALUE_A", "VALUE_B", "VALUE_C");
        Assert.assertThat((Object)emd.getValues(), (Matcher)Is.is(enumValues));
        for (FieldMetadata fmd : emd.getFields()) {
            Assert.assertThat((Object)fmd.getName(), (Matcher)IsNot.not((Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Is.is((Object)"VALUE_A"), Is.is((Object)"VALUE_B"), Is.is((Object)"VALUE_C")})));
        }
    }

    private void compareMetadataToClass(Class<?> clazz) throws Exception {
        String resourceName = "/" + clazz.getName().replace('.', '/') + ".class";
        this.input = this.getClass().getResourceAsStream(resourceName);
        ClassMetadata cmd = ClassFileMetadataReader.instance((InputStream)this.input);
        Assert.assertThat((Object)cmd.getClassName(), (Matcher)Is.is((Object)clazz.getName()));
        if (clazz.getSuperclass() == null) {
            Assert.assertThat((Object)cmd.getSuperclassName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        } else {
            Assert.assertThat((Object)cmd.getSuperclassName(), (Matcher)Is.is((Object)clazz.getSuperclass().getName()));
        }
        String[] clazzInterfaces = new String[clazz.getInterfaces().length];
        for (int i = 0; i < clazz.getInterfaces().length; ++i) {
            clazzInterfaces[i] = clazz.getInterfaces()[i].getName();
        }
        Assert.assertThat((Object)cmd.getInterfaces(), (Matcher)Is.is((Object)clazzInterfaces));
        Assert.assertThat((Object)cmd.isEnumeration(), (Matcher)Is.is((Object)clazz.isEnum()));
        Assert.assertThat((Object)cmd.getVisibility(), (Matcher)Is.is((Object)this.visibilityFor(clazz.getModifiers())));
        Assert.assertThat((Object)cmd.isInterface(), (Matcher)Is.is((Object)Modifier.isInterface(clazz.getModifiers())));
        Assert.assertThat((Object)cmd.isAbstract(), (Matcher)Is.is((Object)Modifier.isAbstract(clazz.getModifiers())));
        Assert.assertThat((Object)cmd.getAnnotations().size(), (Matcher)Is.is((Object)clazz.getDeclaredAnnotations().length));
        for (AnnotationMetadata amd : cmd.getAnnotations()) {
            Class<?> annotationClass = Class.forName(amd.getAnnotationClassName());
            Object annotation = clazz.getAnnotation(annotationClass);
            Assert.assertThat(annotation, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
        this.checkFields(cmd, clazz);
        this.checkMethods(cmd, clazz);
        this.checkConstructors(cmd, clazz);
    }

    private void checkFields(ClassMetadata cmd, Class<?> clazz) throws Exception {
        HashMap<FieldKey, Field> clazzFields = new HashMap<FieldKey, Field>();
        HashMap<FieldKey, FieldMetadata> metaFields = new HashMap<FieldKey, FieldMetadata>();
        for (Field field : clazz.getDeclaredFields()) {
            clazzFields.put(new FieldKey(field), field);
        }
        for (FieldMetadata fieldMetadata : cmd.getFields()) {
            metaFields.put(new FieldKey(fieldMetadata), fieldMetadata);
        }
        Assert.assertThat((Object)metaFields.size(), (Matcher)Is.is((Object)clazzFields.size()));
        Assert.assertThat(metaFields.keySet(), (Matcher)Is.is(clazzFields.keySet()));
        for (Map.Entry entry : metaFields.entrySet()) {
            Field clazzField = (Field)clazzFields.get(entry.getKey());
            FieldMetadata metaField = (FieldMetadata)entry.getValue();
            assert (clazzField != null);
            String metaName = metaField.getTypeName().replace('$', '.');
            String clazzName = clazzField.getType().getCanonicalName();
            Assert.assertThat((Object)metaName, (Matcher)Is.is((Object)clazzName));
            Assert.assertThat((Object)metaField.getVisibility(), (Matcher)Is.is((Object)this.visibilityFor(clazzField.getModifiers())));
            Assert.assertThat((Object)metaField.isFinal(), (Matcher)Is.is((Object)Modifier.isFinal(clazzField.getModifiers())));
            Assert.assertThat((Object)metaField.isStatic(), (Matcher)Is.is((Object)Modifier.isStatic(clazzField.getModifiers())));
            Assert.assertThat((Object)metaField.getAnnotations().size(), (Matcher)Is.is((Object)clazzField.getDeclaredAnnotations().length));
            for (AnnotationMetadata amd : metaField.getAnnotations()) {
                Class<?> annotationClass = Class.forName(amd.getAnnotationClassName());
                Object annotation = clazz.getAnnotation(annotationClass);
                Assert.assertThat(annotation, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            }
        }
    }

    private void checkMethods(ClassMetadata cmd, Class<?> clazz) throws Exception {
        HashMap<MethodKey, Method> clazzMethods = new HashMap<MethodKey, Method>();
        HashMap<MethodKey, MethodMetadata> metaMethods = new HashMap<MethodKey, MethodMetadata>();
        for (Method field : clazz.getDeclaredMethods()) {
            clazzMethods.put(new MethodKey(field), field);
        }
        for (MethodMetadata methodMetadata : cmd.getMethods()) {
            metaMethods.put(new MethodKey(methodMetadata), methodMetadata);
        }
        Assert.assertThat((Object)metaMethods.size(), (Matcher)Is.is((Object)clazzMethods.size()));
        Assert.assertThat(metaMethods.keySet(), (Matcher)Is.is(clazzMethods.keySet()));
        for (Map.Entry entry : metaMethods.entrySet()) {
            Method clazzMethod = (Method)clazzMethods.get(entry.getKey());
            MethodMetadata metaMethod = (MethodMetadata)entry.getValue();
            assert (clazzMethod != null);
            String metaName = metaMethod.getReturnType().replace('$', '.');
            String clazzName = clazzMethod.getReturnType().getCanonicalName();
            Assert.assertThat((Object)metaName, (Matcher)Is.is((Object)clazzName));
            Assert.assertThat((Object)metaMethod.getVisibility(), (Matcher)Is.is((Object)this.visibilityFor(clazzMethod.getModifiers())));
            Assert.assertThat((Object)metaMethod.isFinal(), (Matcher)Is.is((Object)Modifier.isFinal(clazzMethod.getModifiers())));
            Assert.assertThat((Object)metaMethod.isStatic(), (Matcher)Is.is((Object)Modifier.isStatic(clazzMethod.getModifiers())));
            Assert.assertThat((Object)metaMethod.getAnnotations().size(), (Matcher)Is.is((Object)clazzMethod.getDeclaredAnnotations().length));
        }
    }

    private void checkConstructors(ClassMetadata cmd, Class<?> clazz) throws Exception {
        HashMap clazzCtors = new HashMap();
        HashMap<MethodKey, MethodMetadata> metaCtors = new HashMap<MethodKey, MethodMetadata>();
        for (Constructor<?> field : clazz.getDeclaredConstructors()) {
            clazzCtors.put(new MethodKey(field), field);
        }
        for (MethodMetadata methodMetadata : cmd.getConstructors()) {
            metaCtors.put(new MethodKey(methodMetadata), methodMetadata);
        }
        Assert.assertThat((Object)metaCtors.size(), (Matcher)Is.is((Object)clazzCtors.size()));
        Assert.assertThat(metaCtors.keySet(), (Matcher)Is.is(clazzCtors.keySet()));
        for (Map.Entry entry : metaCtors.entrySet()) {
            Constructor clazzCtor = (Constructor)clazzCtors.get(entry.getKey());
            MethodMetadata metaCtor = (MethodMetadata)entry.getValue();
            assert (clazzCtor != null);
            Assert.assertThat((Object)metaCtor.getVisibility(), (Matcher)Is.is((Object)this.visibilityFor(clazzCtor.getModifiers())));
            Assert.assertThat((Object)metaCtor.isFinal(), (Matcher)Is.is((Object)Modifier.isFinal(clazzCtor.getModifiers())));
            Assert.assertThat((Object)metaCtor.isStatic(), (Matcher)Is.is((Object)Modifier.isStatic(clazzCtor.getModifiers())));
            Assert.assertThat((Object)metaCtor.getAnnotations().size(), (Matcher)Is.is((Object)clazzCtor.getDeclaredAnnotations().length));
        }
    }

    private Visibility visibilityFor(int modifier) {
        if (Modifier.isPublic(modifier)) {
            return Visibility.PUBLIC;
        }
        if (Modifier.isProtected(modifier)) {
            return Visibility.PROTECTED;
        }
        if (Modifier.isPrivate(modifier)) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE;
    }

    private class MethodKey {
        private final String name;
        private final List<String> parameters;

        private MethodKey(Method method) {
            this.name = method.getName();
            this.parameters = new ArrayList<String>();
            for (Class<?> parameter : method.getParameterTypes()) {
                this.parameters.add(parameter.getCanonicalName());
            }
        }

        private MethodKey(Constructor<?> ctor) {
            this.name = ctor.getName();
            this.parameters = new ArrayList<String>();
            for (Class<?> parameter : ctor.getParameterTypes()) {
                this.parameters.add(parameter.getCanonicalName());
            }
        }

        private MethodKey(MethodMetadata method) {
            this.name = method.getName();
            this.parameters = method.getParameters();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            return this.name.equals(other.name) && ((Object)this.parameters).equals(other.parameters);
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.name, this.parameters});
        }

        public String toString() {
            return this.name + "(" + this.parameters + ")";
        }
    }

    private class FieldKey {
        private final String name;

        private FieldKey(Field field) {
            this.name = field.getName();
        }

        private FieldKey(FieldMetadata field) {
            this.name = field.getName();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FieldKey)) {
                return false;
            }
            return this.name.equals(((FieldKey)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

