/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Properties;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.Main;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class RemoteInfinispanTestHelper {
    protected static final int PORT = 11311;
    protected static final int TIMEOUT = 0;
    private static EmbeddedCacheManager cacheManager = null;
    private static HotRodServer server = null;
    private static int count = 0;

    public static synchronized HotRodServer createServer() throws IOException {
        ++count;
        if (server == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.loaders().addCacheLoader().cacheLoader((CacheLoader)new DummyInMemoryCacheStore());
            cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
            cacheManager.defineConfiguration("cars", builder.build());
            cacheManager.defineConfiguration("aircraft", builder.build());
            cacheManager.defineConfiguration("remowritable", builder.build());
            cacheManager.defineConfiguration("default", builder.build());
            cacheManager.defineConfiguration("copyChildrenSource", builder.build());
            server = new HotRodServer();
            String hostAddress = RemoteInfinispanTestHelper.hostAddress();
            String hostPort = Integer.toString(RemoteInfinispanTestHelper.hostPort());
            String timeoutStr = Integer.toString(0);
            Properties props = new Properties();
            props.setProperty(Main.PROP_KEY_HOST(), hostAddress);
            props.setProperty(Main.PROP_KEY_PORT(), hostPort);
            props.setProperty(Main.PROP_KEY_IDLE_TIMEOUT(), timeoutStr);
            props.setProperty(Main.PROP_KEY_PROXY_HOST(), hostAddress);
            props.setProperty(Main.PROP_KEY_PROXY_PORT(), hostPort);
            server.start(props, cacheManager);
        }
        return server;
    }

    public static int hostPort() {
        return 11311;
    }

    public static String hostAddress() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet4Address) {
                return "127.0.0.1";
            }
            return "::1";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void releaseServer() {
        if (--count <= 0) {
            try {
                if (server != null) {
                    server.stop();
                }
                server = null;
            }
            catch (Throwable throwable) {
                server = null;
                TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
                throw throwable;
            }
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
        }
    }
}

