/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.LongValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class LongValueFactoryTest {
    private LongValueFactory factory;
    private StringValueFactory stringFactory;

    @Before
    public void setUp() throws Exception {
        this.stringFactory = new StringValueFactory((NamespaceRegistry)new SimpleNamespaceRegistry(), Path.URL_DECODER, Path.URL_ENCODER);
        this.factory = new LongValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromBooleanValue() {
        this.factory.create(true);
    }

    @Test
    public void shouldCreateLongFromString() {
        Assert.assertThat((Object)this.factory.create("1"), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.factory.create("-10"), (Matcher)Is.is((Object)-10L));
        Assert.assertThat((Object)this.factory.create("100000101"), (Matcher)Is.is((Object)100000101L));
    }

    @Test
    public void shouldCreateLongFromStringRegardlessOfLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.factory.create("  1  "), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.factory.create("  -10  "), (Matcher)Is.is((Object)-10L));
        Assert.assertThat((Object)this.factory.create("  100000101  "), (Matcher)Is.is((Object)100000101L));
    }

    @Test
    public void shouldNotCreateLongFromIntegerValue() {
        Assert.assertThat((Object)this.factory.create(1), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldNotCreateLongFromLongValue() {
        Assert.assertThat((Object)this.factory.create(1L), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldNotCreateLongFromFloatValue() {
        Assert.assertThat((Object)this.factory.create(1.0f), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.factory.create(1.023f), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.factory.create(1.923f), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldNotCreateLongFromDoubleValue() {
        Assert.assertThat((Object)this.factory.create(1.0122), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldCreateLongFromBigDecimal() {
        BigDecimal value = new BigDecimal(100);
        Assert.assertThat((Object)this.factory.create(value), (Matcher)Is.is((Object)value.longValue()));
    }

    @Test
    public void shouldCreateLongFromDate() {
        Date value = new Date();
        Assert.assertThat((Object)this.factory.create(value), (Matcher)Is.is((Object)value.getTime()));
    }

    @Test
    public void shouldCreateLongFromCalendar() {
        Calendar value = Calendar.getInstance();
        Assert.assertThat((Object)this.factory.create(value), (Matcher)Is.is((Object)value.getTimeInMillis()));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateLongFromName() {
        this.factory.create((Name)Mockito.mock(Name.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateLongFromPath() {
        this.factory.create((Path)Mockito.mock(Path.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateLongFromReference() {
        this.factory.create((Reference)Mockito.mock(Reference.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateLongFromUri() throws Exception {
        this.factory.create(new URI("http://www.jboss.org"));
    }

    @Test
    public void shouldCreateLongFromByteArrayContainingUtf8EncodingOfStringWithLong() throws Exception {
        Assert.assertThat((Object)this.factory.create("0".getBytes("UTF-8")), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.factory.create("10".getBytes("UTF-8")), (Matcher)Is.is((Object)10L));
        Assert.assertThat((Object)this.factory.create("-103".getBytes("UTF-8")), (Matcher)Is.is((Object)-103L));
        Assert.assertThat((Object)this.factory.create("1003044".getBytes("UTF-8")), (Matcher)Is.is((Object)1003044L));
    }

    @Test
    public void shouldCreateLongFromInputStreamContainingUtf8EncodingOfStringWithLong() throws Exception {
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("0".getBytes("UTF-8"))), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("10".getBytes("UTF-8"))), (Matcher)Is.is((Object)10L));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("-103".getBytes("UTF-8"))), (Matcher)Is.is((Object)-103L));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("1003044".getBytes("UTF-8"))), (Matcher)Is.is((Object)1003044L));
    }

    @Test
    public void shouldCreateLongFromReaderContainingStringWithLong() {
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("0")), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("10")), (Matcher)Is.is((Object)10L));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("-103")), (Matcher)Is.is((Object)-103L));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("1003044")), (Matcher)Is.is((Object)1003044L));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateLongFromByteArrayContainingUtf8EncodingOfStringWithContentsOtherThanLong() throws Exception {
        this.factory.create("something".getBytes("UTF-8"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateLongFromInputStreamContainingUtf8EncodingOfStringWithContentsOtherThanLong() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateLongFromReaderContainingStringWithContentsOtherThanLong() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add(" " + i);
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.factory.create((String)valueIter.next())));
        }
    }
}

