/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.ChooseJoinAlgorithm;
import org.modeshape.graph.query.plan.JoinAlgorithm;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.Schemata;

public class ChooseJoinAlgorithmTest
extends AbstractQueryTest {
    private ChooseJoinAlgorithm bestRule;
    private ChooseJoinAlgorithm nestedRule;
    private QueryContext context;

    @Before
    public void beforeEach() {
        ExecutionContext execContext = new ExecutionContext();
        this.context = new QueryContext(execContext, (Schemata)Mockito.mock(Schemata.class), execContext.getValueFactories().getTypeSystem());
        this.bestRule = ChooseJoinAlgorithm.USE_BEST_JOIN_ALGORITHM;
        this.nestedRule = ChooseJoinAlgorithm.USE_ONLY_NESTED_JOIN_ALGORITHM;
    }

    @Test
    public void shouldHaveNestedRuleAlwaysSetJoinAlgorithmToNestedLoop() {
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, new SelectorName[]{this.selector("Selector1"), this.selector("Selector2")});
        PlanNode s1Source = new PlanNode(PlanNode.Type.SOURCE, join, new SelectorName[]{this.selector("Selector1")});
        PlanNode s2Source = new PlanNode(PlanNode.Type.SOURCE, join, new SelectorName[]{this.selector("Selector2")});
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        PlanNode result = this.nestedRule.execute(this.context, join, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)join)));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.INNER));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_ALGORITHM, JoinAlgorithm.class), (Matcher)Is.is((Object)JoinAlgorithm.NESTED_LOOP));
        this.assertChildren(join, s1Source, s2Source);
    }

    @Test
    public void shouldHaveBestRuleAlwaysSetJoinAlgorithmToNestedLoopIfConditionIsDescendantNode() {
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, new SelectorName[]{this.selector("Ancestor"), this.selector("Descendant")});
        PlanNode ancestorSource = new PlanNode(PlanNode.Type.SOURCE, join, new SelectorName[]{this.selector("Ancestor")});
        PlanNode descendantSource = new PlanNode(PlanNode.Type.SOURCE, join, new SelectorName[]{this.selector("Descendant")});
        DescendantNodeJoinCondition joinCondition = new DescendantNodeJoinCondition(this.selector("Ancestor"), this.selector("Descendant"));
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)joinCondition);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        PlanNode result = this.bestRule.execute(this.context, join, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)join)));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.INNER));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_ALGORITHM, JoinAlgorithm.class), (Matcher)Is.is((Object)JoinAlgorithm.NESTED_LOOP));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinCondition)));
        this.assertChildren(join, ancestorSource, descendantSource);
    }

    @Test
    public void shouldHaveBestRuleSetJoinAlgorithmToMergeIfConditionIsNotDescendantNode() {
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, new SelectorName[]{this.selector("Parent"), this.selector("Child")});
        PlanNode parentSource = new PlanNode(PlanNode.Type.SOURCE, join, new SelectorName[]{this.selector("Parent")});
        PlanNode childSource = new PlanNode(PlanNode.Type.SOURCE, join, new SelectorName[]{this.selector("Child")});
        ChildNodeJoinCondition joinCondition = new ChildNodeJoinCondition(this.selector("Parent"), this.selector("Child"));
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)joinCondition);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        PlanNode result = this.bestRule.execute(this.context, join, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)join)));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.INNER));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_ALGORITHM, JoinAlgorithm.class), (Matcher)Is.is((Object)JoinAlgorithm.MERGE));
        Assert.assertThat((Object)join.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinCondition)));
        PlanNode leftDup = join.getFirstChild();
        Assert.assertThat((Object)leftDup.getType(), (Matcher)Is.is((Object)PlanNode.Type.DUP_REMOVE));
        this.assertSelectors(leftDup, "Parent");
        PlanNode leftSort = leftDup.getFirstChild();
        Assert.assertThat((Object)leftSort.getType(), (Matcher)Is.is((Object)PlanNode.Type.SORT));
        this.assertSortOrderBy(leftSort, "Parent");
        this.assertSelectors(leftSort, "Parent");
        this.assertChildren(leftDup, leftSort);
        this.assertChildren(leftSort, parentSource);
        PlanNode rightDup = join.getLastChild();
        Assert.assertThat((Object)rightDup.getType(), (Matcher)Is.is((Object)PlanNode.Type.DUP_REMOVE));
        this.assertSelectors(rightDup, "Child");
        PlanNode rightSort = rightDup.getLastChild();
        Assert.assertThat((Object)rightSort.getType(), (Matcher)Is.is((Object)PlanNode.Type.SORT));
        this.assertSortOrderBy(rightSort, "Child");
        this.assertSelectors(rightSort, "Child");
        this.assertChildren(rightDup, rightSort);
        this.assertChildren(rightSort, childSource);
        this.assertChildren(join, leftDup, rightDup);
    }
}

