/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.optimize.RewriteAsRangeCriteria;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.Schemata;

public class RewriteAsRangeCriteriaTest
extends AbstractQueryTest {
    private RewriteAsRangeCriteria rule;
    private LinkedList<OptimizerRule> rules;
    private QueryContext context;
    private boolean print = false;

    @Before
    public void beforeEach() {
        this.rule = RewriteAsRangeCriteria.INSTANCE;
        this.rules = new LinkedList();
        this.rules.add((OptimizerRule)this.rule);
        ExecutionContext execContext = new ExecutionContext();
        this.context = new QueryContext(execContext, (Schemata)Mockito.mock(Schemata.class), execContext.getValueFactories().getTypeSystem());
        this.print = false;
    }

    protected void print(PlanNode node) {
        if (this.print) {
            System.out.println(node);
        }
    }

    @Test
    public void shouldReplaceComparisonsSpecifyingExclusiveRangeWithBetweenConstraint() {
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("t1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("t1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c2"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)100L)));
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.GREATER_THAN, (StaticOperand)new Literal((Object)1L)));
        this.print(access);
        PlanNode result = this.executeRules(access);
        this.print(result);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)access)));
        this.assertChildren(access, project);
        PlanNode newSelect = project.getFirstChild();
        Assert.assertThat((Object)newSelect.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)newSelect.getSelectors(), (Matcher)Is.is((Object)access.getSelectors()));
        Assert.assertThat((Object)newSelect.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)project)));
        Between between = (Between)newSelect.getProperty(PlanNode.Property.SELECT_CRITERIA, Between.class);
        Assert.assertThat((Object)between.operand(), (Matcher)Is.is((Object)((Comparison)select2.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand1()));
        Assert.assertThat((Object)between.lowerBound(), (Matcher)Is.is((Object)((Comparison)select3.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand2()));
        Assert.assertThat((Object)between.upperBound(), (Matcher)Is.is((Object)((Comparison)select2.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand2()));
        Assert.assertThat((Object)between.isLowerBoundIncluded(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)between.isUpperBoundIncluded(), (Matcher)Is.is((Object)false));
        this.assertChildren(newSelect, select1);
        this.assertChildren(select1, source);
    }

    @Test
    public void shouldReplaceComparisonsSpecifyingInclusiveRangeWithBetweenConstraint() {
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("t1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("t1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c2"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)100L)));
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.LESS_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)3L)));
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.GREATER_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)1L)));
        this.print(access);
        PlanNode result = this.executeRules(access);
        this.print(result);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)access)));
        this.assertChildren(access, project);
        PlanNode newSelect = project.getFirstChild();
        Assert.assertThat((Object)newSelect.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)newSelect.getSelectors(), (Matcher)Is.is((Object)access.getSelectors()));
        Assert.assertThat((Object)newSelect.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)project)));
        Between between = (Between)newSelect.getProperty(PlanNode.Property.SELECT_CRITERIA, Between.class);
        Assert.assertThat((Object)between.operand(), (Matcher)Is.is((Object)((Comparison)select2.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand1()));
        Assert.assertThat((Object)between.lowerBound(), (Matcher)Is.is((Object)((Comparison)select3.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand2()));
        Assert.assertThat((Object)between.upperBound(), (Matcher)Is.is((Object)((Comparison)select2.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand2()));
        Assert.assertThat((Object)between.isLowerBoundIncluded(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)between.isUpperBoundIncluded(), (Matcher)Is.is((Object)true));
        this.assertChildren(newSelect, select1);
        this.assertChildren(select1, source);
    }

    @Test
    public void shouldReplaceComparisonsSpecifyingExclusiveRangeWithNotBetweenConstraint() {
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("t1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("t1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c2"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)100L)));
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.GREATER_THAN, (StaticOperand)new Literal((Object)3L)));
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)1L)));
        this.print(access);
        PlanNode result = this.executeRules(access);
        this.print(result);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)access)));
        this.assertChildren(access, project);
        Assert.assertThat((Object)access.getProperty(PlanNode.Property.ACCESS_NO_RESULTS, Boolean.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReplaceComparisonsSpecifyingInclusiveRangeWithNotBetweenConstraint() {
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("t1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("t1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c2"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)100L)));
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.GREATER_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)3L)));
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.LESS_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)1L)));
        this.print(access);
        PlanNode result = this.executeRules(access);
        this.print(result);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)access)));
        this.assertChildren(access, project);
        Assert.assertThat((Object)access.getProperty(PlanNode.Property.ACCESS_NO_RESULTS, Boolean.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReplaceComparisonsSpecifyingInclusiveRangeWithOverlappingBoundaryEqualityComparison() {
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("t1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("t1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c2"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)100L)));
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.LESS_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)3L)));
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.GREATER_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)3L)));
        this.print(access);
        PlanNode result = this.executeRules(access);
        this.print(result);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)access)));
        Assert.assertThat((Object)access.getProperty(PlanNode.Property.ACCESS_NO_RESULTS, Boolean.class), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.assertChildren(access, project);
        PlanNode newSelect = project.getFirstChild();
        Assert.assertThat((Object)newSelect.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)newSelect.getSelectors(), (Matcher)Is.is((Object)access.getSelectors()));
        Assert.assertThat((Object)newSelect.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)project)));
        Comparison equality = (Comparison)newSelect.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class);
        Assert.assertThat((Object)equality.operand1(), (Matcher)Is.is((Object)((Comparison)select2.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand1()));
        Assert.assertThat((Object)equality.operator(), (Matcher)Is.is((Object)Operator.EQUAL_TO));
        Assert.assertThat((Object)equality.operand2(), (Matcher)Is.is((Object)((Comparison)select2.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class)).operand2()));
        this.assertChildren(newSelect, select1);
        this.assertChildren(select1, source);
    }

    @Test
    public void shouldMarkAsHavingNoResultsWhenComparisonsSpecifyRangeWithNonOverlappingBoundary() {
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("t1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("t1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c2"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)100L)));
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c1"), Operator.GREATER_THAN, (StaticOperand)new Literal((Object)3L)));
        this.print(access);
        PlanNode result = this.executeRules(access);
        this.print(result);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)access)));
        this.assertChildren(access, project);
        Assert.assertThat((Object)access.getProperty(PlanNode.Property.ACCESS_NO_RESULTS, Boolean.class), (Matcher)Is.is((Object)true));
    }

    protected PlanNode executeRules(PlanNode node) {
        while (!this.rules.isEmpty()) {
            OptimizerRule rule = this.rules.poll();
            assert (rule != null);
            node = rule.execute(this.context, node, this.rules);
        }
        return node;
    }
}

