/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.process.AbstractQueryResultsTest;
import org.modeshape.graph.query.process.ExceptComponent;
import org.modeshape.graph.query.process.IntersectComponent;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.SelectComponent;
import org.modeshape.graph.query.process.SetOperationComponent;
import org.modeshape.graph.query.process.UnionComponent;
import org.modeshape.graph.query.validate.Schemata;

public class SetOperationComponentsTest
extends AbstractQueryResultsTest {
    private SetOperationComponent component;
    private List<ProcessingComponent> selects;
    private QueryContext context;
    private QueryResults.Columns columns;
    private List<Object[]> tuplesA;
    private List<Object[]> tuplesB;

    @Before
    public void beforeEach() {
        this.context = new QueryContext(new ExecutionContext(), (Schemata)Mockito.mock(Schemata.class), this.typeSystem);
        this.tuplesA = new ArrayList<Object[]>();
        this.tuplesB = new ArrayList<Object[]>();
        this.columns = this.resultColumns("Selector1", new String[]{"ColA", "ColB", "ColC"}, PropertyType.STRING, PropertyType.STRING, PropertyType.STRING);
        ProcessingComponent delegateA = new ProcessingComponent(this.context, this.columns){

            public List<Object[]> execute() {
                return new ArrayList<Object[]>(SetOperationComponentsTest.this.tuplesA);
            }
        };
        ProcessingComponent delegateB = new ProcessingComponent(this.context, this.columns){

            public List<Object[]> execute() {
                return new ArrayList<Object[]>(SetOperationComponentsTest.this.tuplesB);
            }
        };
        PropertyExistence constraint = new PropertyExistence(this.selector("Selector1"), "ColA");
        this.selects = new ArrayList<ProcessingComponent>();
        this.selects.add((ProcessingComponent)new SelectComponent(delegateA, (Constraint)constraint, null));
        this.selects.add((ProcessingComponent)new SelectComponent(delegateB, (Constraint)constraint, null));
    }

    @Test
    public void shouldUnionResultsForCompatibleSets() {
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c3", "v4", "v5", "v6"));
        this.component = new UnionComponent(this.context, this.columns, this.selects, false, false);
        List results = this.component.execute();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldUnionAllResultsForCompatibleSets() {
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c3", "v4", "v5", "v6"));
        this.component = new UnionComponent(this.context, this.columns, this.selects, false, true);
        List results = this.component.execute();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldIntersectResultsForCompatibleSets() {
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c3", "v4", "v5", "v6"));
        this.component = new IntersectComponent(this.context, this.columns, this.selects, false, false);
        List results = this.component.execute();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldIntersectAllResultsForCompatibleSets() {
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c2", "v4", "v5", "v6"));
        this.component = new IntersectComponent(this.context, this.columns, this.selects, false, true);
        List results = this.component.execute();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldExceptResultsForCompatibleSets() {
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c3", "v4", "v5", "v6"));
        this.component = new ExceptComponent(this.context, this.columns, this.selects, false, false);
        List results = this.component.execute();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldExceptAllResultsForCompatibleSets() {
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesA.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.tuplesB.add(this.tuple(this.columns, "/a/b/c3", "v4", "v5", "v6"));
        this.component = new ExceptComponent(this.context, this.columns, this.selects, false, true);
        List results = this.component.execute();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)2));
    }
}

