/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.web.jcr.rest.AbstractHandler;

@Immutable
public class QueryHandler
extends AbstractHandler {
    private static final String[] SKIP_QUERY_PARAMETER_VALUES = new String[]{"offset", "limit"};
    protected static final Set<String> SKIP_QUERY_PARAMETERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SKIP_QUERY_PARAMETER_VALUES)));

    public String postItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String language, String statement, long offset, long limit, UriInfo uriInfo) throws InvalidQueryException, RepositoryException, JSONException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (language != null);
        assert (statement != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(statement, language);
        if (uriInfo != null) {
            for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
                String variableName = (String)entry.getKey();
                List variableValues = (List)entry.getValue();
                if (variableValues == null || variableValues.isEmpty() || SKIP_QUERY_PARAMETERS.contains(variableName)) continue;
                Iterator iter = variableValues.iterator();
                String variableValue = null;
                while (iter.hasNext() && variableValue == null) {
                    variableValue = (String)iter.next();
                }
                if (variableValue == null) continue;
                query.bindValue(variableName, session.getValueFactory().createValue(variableValue));
            }
        }
        javax.jcr.query.QueryResult result = query.execute();
        String[] columnNames = result.getColumnNames();
        LinkedList<JSONObject> jsonRows = new LinkedList<JSONObject>();
        RowIterator resultRows = result.getRows();
        if (offset > 0L) {
            resultRows.skip(offset);
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        while (resultRows.hasNext() && limit > 0L) {
            --limit;
            Row resultRow = resultRows.nextRow();
            JSONObject jsonRow = new JSONObject();
            for (String columnName : columnNames) {
                Value value = resultRow.getValue(columnName);
                if (value == null) continue;
                if (value.getType() == 2) {
                    jsonRow.put(columnName + "/base64/", (Object)this.jsonEncodedStringFor(value));
                    continue;
                }
                jsonRow.put(columnName, (Object)value.getString());
            }
            jsonRows.add(jsonRow);
        }
        JSONObject results = new JSONObject();
        if (result instanceof QueryResult) {
            QueryResult modeShapeResult = (QueryResult)result;
            JSONObject columnTypeMap = new JSONObject();
            String[] columnTypes = modeShapeResult.getColumnTypes();
            assert (columnTypes.length == columnNames.length);
            for (int i = 0; i < columnNames.length; ++i) {
                columnTypeMap.put(columnNames[i], (Object)columnTypes[i]);
            }
            results.put("types", (Object)columnTypeMap);
        }
        results.put("rows", (Object)new JSONArray(jsonRows));
        return results.toString();
    }
}

