/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.connector.infinispan.RemoteInfinispanSource;
import org.modeshape.connector.infinispan.RemoteInfinispanTestHelper;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;

public class RemoteInfinispanConnectorReadWriteTest {
    private ExecutionContext context;
    private RemoteInfinispanSource source;
    private RepositoryContext mockRepositoryContext;
    private Graph graph;

    @BeforeClass
    public static void createContainer() throws Exception {
        RemoteInfinispanTestHelper.createServer();
    }

    @AfterClass
    public static void closeConnection() throws Exception {
        RemoteInfinispanTestHelper.releaseServer();
    }

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.mockRepositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)this.mockRepositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        String[] predefinedWorkspaceNames = new String[]{"default"};
        this.source = new RemoteInfinispanSource();
        this.source.setName("Test Repository");
        this.source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        this.source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        this.source.setCreatingWorkspacesAllowed(true);
        this.source.initialize(this.mockRepositoryContext);
        this.source.setRemoteInfinispanServerList(String.format("%s:%s", RemoteInfinispanTestHelper.hostAddress(), RemoteInfinispanTestHelper.hostPort()));
    }

    @After
    public void afterEach() throws Exception {
        this.graph = null;
        this.source.close();
    }

    protected Graph graph() {
        if (this.graph == null) {
            this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        }
        return this.graph;
    }

    private void testWriteAndRead() {
        Subgraph subgraph = (Subgraph)this.graph().getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph.getNode("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.graph().create("/a").with("prop1", new Object[]{"value1"}).and();
        subgraph = (Subgraph)this.graph().getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph.getNode("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a")).getProperty("prop1").getFirstValue(), (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void shouldShutdownWithoutOpeningConnections() throws Exception {
        this.source.close();
    }

    @Test
    public void shouldShutdownAfterOpeningConnections() throws Exception {
        RepositoryConnection connection = this.source.getConnection();
        connection.close();
    }

    @Test
    public void shouldHaveRootNode() throws Exception {
        Assert.assertThat((Object)this.graph().getNodeAt("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAllowCreatingAndReReadingNodesFromJndiCache() throws Exception {
        this.testWriteAndRead();
    }

    @Test
    public void shouldAllowCreatingAndReReadingNodesFromClasspathConfig() throws Exception {
        this.testWriteAndRead();
    }

    @Test
    public void shouldAllowCreatingAndReReadingNodesFromFileConfig() throws Exception {
        this.testWriteAndRead();
    }
}

