/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.connector.disk.DiskNode;
import org.modeshape.connector.disk.DiskSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.BasicCachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.base.cache.InMemoryNodeCache;
import org.modeshape.graph.connector.base.cache.NodeCachePolicy;

public class DiskSourceTest {
    private ExecutionContext context;
    private DiskSource source;
    private RepositoryConnection connection;
    private String validName;
    private String repositoryRootPath;
    private UUID validRootNodeUuid;
    @Mock
    private RepositoryContext repositoryContext;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.validName = "disk source";
        this.validRootNodeUuid = UUID.randomUUID();
        this.repositoryRootPath = "target/root";
        this.source = new DiskSource();
        this.source.setRepositoryRootPath(this.repositoryRootPath);
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldReturnNonNullCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldSupportSameNameSiblings() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsSameNameSiblings(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSupportUpdates() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveNullSourceNameUponConstruction() {
        this.source = new DiskSource();
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowSettingName() {
        this.source.setName("Something");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"Something"));
        this.source.setName("another name");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"another name"));
    }

    @Test
    public void shouldAllowSettingNameToNull() {
        this.source.setName("some name");
        this.source.setName(null);
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldHaveDefaultRetryLimit() {
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSetRetryLimitToZeroWhenSetWithNonPositiveValue() {
        this.source.setRetryLimit(0);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-1);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-100);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAllowRetryLimitToBeSet() {
        for (int i = 0; i != 100; ++i) {
            this.source.setRetryLimit(i);
            Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReference() throws Exception {
        InMemoryNodeCache.MapCachePolicy cachePolicy = new InMemoryNodeCache.MapCachePolicy(1000L);
        this.convertToAndFromJndiReference(this.validName, this.validRootNodeUuid, this.repositoryRootPath, (NodeCachePolicy<UUID, DiskNode>)cachePolicy, 100);
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReferenceWithNullProperties() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference("some source", null, null, null, 100);
        this.convertToAndFromJndiReference(null, null, null, null, 100);
    }

    private void convertToAndFromJndiReference(String sourceName, UUID rootNodeUuid, String repositoryRootPath, NodeCachePolicy<UUID, DiskNode> cachePolicy, int retryLimit) throws Exception {
        this.source.setRetryLimit(retryLimit);
        this.source.setName(sourceName);
        if (cachePolicy != null) {
            this.source.setCachePolicy(cachePolicy);
        }
        this.source.setRootNodeUuid(rootNodeUuid != null ? rootNodeUuid.toString() : null);
        this.source.setRepositoryRootPath(repositoryRootPath);
        Reference ref = this.source.getReference();
        Assert.assertThat((Object)ref.getClassName(), (Matcher)Is.is((Object)DiskSource.class.getName()));
        Assert.assertThat((Object)ref.getFactoryClassName(), (Matcher)Is.is((Object)DiskSource.class.getName()));
        HashMap<String, Object> refAttributes = new HashMap<String, Object>();
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr addr = enumeration.nextElement();
            refAttributes.put(addr.getType(), addr.getContent());
        }
        DiskSource factory = new DiskSource();
        Name name = (Name)Mockito.mock(Name.class);
        Context context = (Context)Mockito.mock(Context.class);
        Hashtable env = new Hashtable();
        DiskSource recoveredSource = (DiskSource)factory.getObjectInstance(ref, name, context, env);
        Assert.assertThat((Object)recoveredSource, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)recoveredSource.getName(), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)recoveredSource.getRootNodeUuid(), (Matcher)Is.is((Object)this.source.getRootNodeUuid()));
        Assert.assertThat((Object)recoveredSource.getRetryLimit(), (Matcher)Is.is((Object)this.source.getRetryLimit()));
        Assert.assertThat((Object)recoveredSource.getRepositoryRootPath(), (Matcher)Is.is((Object)this.source.getRepositoryRootPath()));
        if (this.source.getDefaultCachePolicy() == null) {
            Assert.assertThat((Object)recoveredSource.getDefaultCachePolicy(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        } else {
            Assert.assertThat((Object)recoveredSource.getDefaultCachePolicy().getClass().getName(), (Matcher)Is.is((Object)this.source.getDefaultCachePolicy().getClass().getName()));
        }
        Assert.assertThat((Object)recoveredSource.equals((Object)this.source), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.source.equals((Object)recoveredSource), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateCacheUsingDefaultCacheManagerWhenNoCacheOrCacheManagerOrCacheConfigurationNameIsFound() throws Exception {
        this.source.setName(this.validName);
        this.source.initialize(this.repositoryContext);
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }
}

