/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.Vehicles;
import org.modeshape.jcr.WorkspaceLockManager;
import org.modeshape.jcr.api.Workspace;

public abstract class AbstractJcrTest {
    protected static ExecutionContext context;
    protected static JcrRepository repository;
    protected static RepositoryLockManager repoLockManager;
    protected static RepositoryNodeTypeManager rntm;
    protected InMemoryRepositorySource source;
    protected Graph store;
    protected int numberOfConnections;
    protected SessionCache cache;
    protected JcrSession jcrSession;
    protected JcrNodeTypeManager nodeTypes;
    protected WorkspaceLockManager lockManager;
    protected JcrLockManager jcrLockManager;
    protected Workspace workspace;

    @BeforeClass
    public static void beforeAll() throws Exception {
        context = new ExecutionContext();
        context.getNamespaceRegistry().register("vehix", "http://example.com/vehicles");
        repository = (JcrRepository)Mockito.mock(JcrRepository.class);
        Mockito.when((Object)repository.getExecutionContext()).thenReturn((Object)context);
        repoLockManager = (RepositoryLockManager)Mockito.mock(RepositoryLockManager.class);
        Mockito.when((Object)repository.getRepositoryLockManager()).thenReturn((Object)repoLockManager);
        rntm = new RepositoryNodeTypeManager(repository, null, true, true);
        try {
            CndNodeTypeReader cndReader = new CndNodeTypeReader(context);
            cndReader.readBuiltInTypes();
            rntm.registerNodeTypes((Iterable)cndReader);
            rntm.registerNodeTypes(Vehicles.getNodeTypes(context));
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
    }

    @Before
    public void beforeEach() throws Exception {
        this.source = new InMemoryRepositorySource();
        this.source.setName("store");
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (AbstractJcrTest.this.source.getName().equals(sourceName)) {
                    ++AbstractJcrTest.this.numberOfConnections;
                    return AbstractJcrTest.this.source.getConnection();
                }
                return null;
            }
        };
        this.store = Graph.create((String)this.source.getName(), (RepositoryConnectionFactory)connectionFactory, (ExecutionContext)context);
        String xmlResourceName = this.getResourceNameOfXmlFileToImport();
        this.store.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream(xmlResourceName)).into("/");
        this.numberOfConnections = 0;
        this.jcrSession = (JcrSession)Mockito.mock(JcrSession.class);
        this.workspace = (Workspace)Mockito.mock(Workspace.class);
        String workspaceName = "workspace1";
        Mockito.when((Object)this.jcrSession.getExecutionContext()).thenReturn((Object)context);
        Mockito.when((Object)this.jcrSession.getWorkspace()).thenReturn((Object)this.workspace);
        Mockito.when((Object)this.jcrSession.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)this.workspace.getName()).thenReturn((Object)workspaceName);
        Mockito.when((Object)this.jcrSession.isLive()).thenReturn((Object)true);
        Mockito.when((Object)this.jcrSession.getUserID()).thenReturn((Object)"username");
        this.lockManager = new WorkspaceLockManager(context, repoLockManager, workspaceName, null);
        this.jcrLockManager = new JcrLockManager(this.jcrSession, this.lockManager);
        Mockito.when((Object)this.jcrSession.lockManager()).thenReturn((Object)this.jcrLockManager);
        JcrValueFactory valueFactory = new JcrValueFactory(this.jcrSession);
        Mockito.when((Object)this.jcrSession.getValueFactory()).thenReturn((Object)valueFactory);
        this.nodeTypes = new JcrNodeTypeManager(this.jcrSession, rntm);
        Mockito.when((Object)this.jcrSession.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        this.cache = new SessionCache(this.jcrSession, this.store.getCurrentWorkspaceName(), context, this.nodeTypes, this.store);
        Mockito.when((Object)this.jcrSession.getNodeByIdentifier(Matchers.anyString())).thenAnswer((Answer)new Answer<AbstractJcrNode>(){

            public AbstractJcrNode answer(InvocationOnMock invocation) throws Throwable {
                String uuidStr = invocation.getArguments()[0].toString();
                Location location = Location.create((UUID)UUID.fromString(uuidStr));
                return AbstractJcrTest.this.cache.findJcrNode(location);
            }
        });
    }

    protected String getResourceNameOfXmlFileToImport() {
        return "cars.xml";
    }

    protected Name name(String name) {
        return (Name)context.getValueFactories().getNameFactory().create(name);
    }

    protected Path relativePath(String relativePath) {
        return (Path)context.getValueFactories().getPathFactory().create(relativePath);
    }

    protected Path path(String absolutePath) {
        return (Path)context.getValueFactories().getPathFactory().create(absolutePath);
    }
}

