/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JndiRepositoryFactory;

public class JndiRepositoryFactoryTest {
    private static final String JCR_REPOSITORY_NAME = "Test Repository Source";
    private static final String REPOSITORY_SOURCE_NAME = "Store";
    private JndiRepositoryFactory factory = new JndiRepositoryFactory();
    private Reference reference = new Reference(JndiRepositoryFactory.class.getName());
    private RefAddr configFile;
    private RefAddr repositoryName = new StringRefAddr("repositoryName", "Test Repository Source");

    @Before
    public void beforeEach() {
        this.reference.add(this.repositoryName);
    }

    @Test
    public void shouldFindConfigFileOnClasspath() throws Exception {
        this.configFile = new StringRefAddr("configFile", "/tck/default/configRepository.xml");
        this.reference.add(this.configFile);
        JcrRepository repo = (JcrRepository)this.factory.getObjectInstance((Object)this.reference, null, null, null);
        Assert.assertThat((Object)repo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)repo.getRepositorySourceName(), (Matcher)CoreMatchers.is((Object)REPOSITORY_SOURCE_NAME));
    }

    @Test
    public void shouldFindConfigFileInFileSystem() throws Exception {
        this.configFile = new StringRefAddr("configFile", "./src/test/resources/tck/default/configRepository.xml");
        this.reference.add(this.configFile);
        JcrRepository repo = (JcrRepository)this.factory.getObjectInstance((Object)this.reference, null, null, null);
        Assert.assertThat((Object)repo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)repo.getRepositorySourceName(), (Matcher)CoreMatchers.is((Object)REPOSITORY_SOURCE_NAME));
    }

    @Test
    public void shouldReturnSameRepository() throws Exception {
        this.configFile = new StringRefAddr("configFile", "/tck/default/configRepository.xml");
        this.reference.add(this.configFile);
        JcrRepository repo1 = (JcrRepository)this.factory.getObjectInstance((Object)this.reference, null, null, null);
        JcrRepository repo2 = (JcrRepository)this.factory.getObjectInstance((Object)this.reference, null, null, null);
        Assert.assertThat((Object)(repo1 == repo2 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }
}

