/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.modeshape.jcr.api.NamedRepository;
import org.modeshape.jcr.api.Repositories;

public class JndiRepositoryFactory
implements RepositoryFactory {
    private static final Set<String> EMPTY_NAME_SET = Collections.emptySet();
    public static final String URL = "org.modeshape.jcr.URL";
    public static final String REPOSITORY_NAME = "org.modeshape.jcr.RepositoryName";
    public static final String REPOSITORY_NAME_PARAM = "repositoryName";

    @Override
    public Repository getRepository(Map parameters) throws RepositoryException {
        URL url = this.getUrlFrom(parameters);
        if (url == null) {
            return null;
        }
        if (!"jndi".equals(url.getProtocol())) {
            return null;
        }
        return this.getRepositoryFromJndi(url, parameters);
    }

    protected URL getUrlFrom(Map<String, Object> parameters) {
        if (parameters == null) {
            return null;
        }
        Object rawUrl = parameters.get(URL);
        if (rawUrl == null) {
            return null;
        }
        URL url = null;
        url = rawUrl instanceof URL ? (URL)rawUrl : this.urlFor(rawUrl.toString(), null);
        return url;
    }

    protected String getRepositoryNameFrom(URL url, Map<String, Object> parameters) {
        Object repoName;
        if (parameters != null && (repoName = parameters.get(REPOSITORY_NAME)) != null) {
            return repoName.toString();
        }
        String query = url.getQuery();
        if (query != null) {
            for (String keyValuePair : query.split("&")) {
                String[] splitPair = keyValuePair.split("=");
                if (splitPair.length != 2 || !REPOSITORY_NAME_PARAM.equals(splitPair[0])) continue;
                return splitPair[1];
            }
        }
        return null;
    }

    private URL urlFor(String jcrUrl, String repoName) {
        assert (jcrUrl != null);
        assert (!jcrUrl.isEmpty());
        try {
            if (repoName != null) {
                repoName = repoName.trim();
                String queryParam = "?repositoryName=";
                if (repoName.length() != 0 && !jcrUrl.contains(queryParam)) {
                    jcrUrl = jcrUrl + queryParam + repoName;
                }
            }
            return new URL(jcrUrl.toString());
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private Hashtable<String, String> hashtable(Map<String, Object> map) {
        assert (map != null);
        Hashtable<String, String> hash = new Hashtable<String, String>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            hash.put(entry.getKey(), value != null ? value.toString() : null);
        }
        return hash;
    }

    private Repository getRepositoryFromJndi(URL url, Map<String, Object> parameters) throws RepositoryException {
        String jndiName = url.getPath();
        if (jndiName == null) {
            return null;
        }
        try {
            InitialContext ic = new InitialContext(this.hashtable(parameters));
            Object ob = ic.lookup(jndiName);
            if (ob instanceof Repository) {
                return (Repository)ob;
            }
            if (ob instanceof Repositories) {
                Repositories repos = (Repositories)ob;
                String repositoryName = this.getRepositoryNameFrom(url, parameters);
                return repos.getRepository(repositoryName);
            }
            return null;
        }
        catch (NamingException ne) {
            return null;
        }
    }

    public Set<String> getRepositoryNames(Map<String, Object> parameters) throws RepositoryException {
        URL url = this.getUrlFrom(parameters);
        if (url == null) {
            return EMPTY_NAME_SET;
        }
        if (!"jndi".equals(url.getProtocol())) {
            return EMPTY_NAME_SET;
        }
        String jndiName = url.getPath();
        try {
            InitialContext ic = new InitialContext(this.hashtable(parameters));
            Object ob = ic.lookup(jndiName);
            if (ob instanceof NamedRepository) {
                return Collections.singleton(((NamedRepository)ob).getName());
            }
            if (ob instanceof Repositories) {
                Repositories repos = (Repositories)ob;
                return repos.getRepositoryNames();
            }
        }
        catch (NamingException ne) {
            // empty catch block
        }
        return EMPTY_NAME_SET;
    }
}

