/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jdbc.JdbcJcrValueFactory;
import org.modeshape.web.jcr.rest.client.domain.QueryRow;

public final class HttpQueryResult
implements QueryResult {
    private final List<HttpRow> rows = new ArrayList<HttpRow>();
    private final Map<String, String> columns = new LinkedHashMap<String, String>();

    HttpQueryResult(List<QueryRow> queryRows) {
        assert (queryRows != null);
        if (!queryRows.isEmpty()) {
            QueryRow firstQueryRow = queryRows.get(0);
            Collection<String> queryColumnNames = firstQueryRow.getColumnNames();
            for (String queryColumnName : queryColumnNames) {
                this.columns.put(queryColumnName, firstQueryRow.getColumnType(queryColumnName));
            }
        }
        for (QueryRow queryRow : queryRows) {
            this.rows.add(new HttpRow(queryRow));
        }
    }

    @Override
    public String[] getColumnNames() throws RepositoryException {
        return this.columns.keySet().toArray(new String[this.columns.size()]);
    }

    @Override
    public RowIterator getRows() throws RepositoryException {
        return new HttpRowIterator();
    }

    @Override
    public NodeIterator getNodes() throws RepositoryException {
        throw new UnsupportedOperationException("Method getNodes() not supported");
    }

    @Override
    public String[] getSelectorNames() throws RepositoryException {
        throw new UnsupportedOperationException("Method getSelectorNames() not supported");
    }

    @Override
    public String[] getColumnTypes() {
        return this.columns.values().toArray(new String[this.columns.size()]);
    }

    private class HttpRow
    implements Row {
        private final Map<String, Value> valuesMap = new LinkedHashMap<String, Value>();

        private HttpRow(QueryRow row) {
            assert (row != null);
            for (String columnName : HttpQueryResult.this.columns.keySet()) {
                Object queryRowValue = row.getValue(columnName);
                this.valuesMap.put(columnName, JdbcJcrValueFactory.createValue(queryRowValue));
            }
        }

        @Override
        public Node getNode() throws RepositoryException {
            throw new UnsupportedOperationException("Method getNode() not supported");
        }

        @Override
        public Value[] getValues() throws RepositoryException {
            return this.valuesMap.values().toArray(new Value[this.valuesMap.size()]);
        }

        @Override
        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            return this.valuesMap.get(columnName);
        }

        @Override
        public Node getNode(String selectorName) throws RepositoryException {
            throw new UnsupportedOperationException("Method getNode(selectorName) not supported");
        }

        @Override
        public String getPath() throws RepositoryException {
            throw new UnsupportedOperationException("Method getPath() not supported");
        }

        @Override
        public String getPath(String selectorName) throws RepositoryException {
            throw new UnsupportedOperationException("Method getPath(selectorName) not supported");
        }

        @Override
        public double getScore() throws RepositoryException {
            throw new UnsupportedOperationException("Method getScore() not supported");
        }

        @Override
        public double getScore(String selectorName) throws RepositoryException {
            throw new UnsupportedOperationException("Method getScore( String selectorName ) not supported");
        }
    }

    private class HttpRowIterator
    implements RowIterator {
        private static final int EMPTY_CURSOR = -1;
        private int cursor;

        private HttpRowIterator() {
            this.cursor = HttpQueryResult.this.rows.isEmpty() ? -1 : 0;
        }

        @Override
        public Row nextRow() {
            if (this.cursor == -1 || this.cursor >= HttpQueryResult.this.rows.size()) {
                throw new NoSuchElementException("No more rows to iterate over");
            }
            return (Row)HttpQueryResult.this.rows.get(this.cursor++);
        }

        @Override
        public void skip(long skipNum) {
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must be a positive value");
            }
            int availableRowsCount = HttpQueryResult.this.rows.size() - this.cursor;
            if (skipNum > (long)availableRowsCount) {
                throw new NoSuchElementException("Skip would go past collection end");
            }
            this.cursor = (int)((long)this.cursor + skipNum);
        }

        @Override
        public long getSize() {
            return HttpQueryResult.this.rows.size();
        }

        @Override
        public long getPosition() {
            return this.cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != -1 && this.cursor < HttpQueryResult.this.rows.size();
        }

        public Object next() {
            return this.nextRow();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method remove() not supported by this iterator");
        }
    }
}

