/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.postgres;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.ddl.AbstractDdlSequencerTest;

public class PostgresDdlSequencerTest
extends AbstractDdlSequencerTest {
    @Test
    public void shouldSequencePostgresDdlFile() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/dialect/postgres/postgres_test_statements.ddl");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)106L));
        Node node = this.findNode(statementsNode, "increment", "postgresddl:createFunctionStatement");
        this.verifyProperty(node, "ddl:startLineNumber", 214L);
        this.verifyProperty(node, "ddl:startCharIndex", 7604L);
        node = this.findNode(statementsNode, "my_function", "postgresddl:commentOnStatement");
        this.verifyProperty(node, "ddl:startLineNumber", 44L);
        this.verifyProperty(node, "ddl:startCharIndex", 1573L);
        this.verifyProperty(node, "postgresddl:comment", "'Returns Roman Numeral'");
        Node alterTableNode = this.findNode(statementsNode, "foreign_companies", "postgresddl:alterTableStatement");
        Node renameColNode = this.findNode(alterTableNode, "address", "postgresddl:renamedColumn");
        this.verifyProperty(renameColNode, "ddl:newName", "city");
        Node grantNode = this.findNode(statementsNode, "divideByTwo", "postgresddl:grantOnFunctionStatement");
        Node parameter_1 = this.findNode(grantNode, "numerator", "postgresddl:functionParameter");
        Assert.assertNotNull((Object)parameter_1);
        this.verifyProperty(parameter_1, "ddl:datatypeName", "int");
    }

    @Test
    public void shouldSequenceStatementsWithDoubleQuotes() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/d_quoted_statements.ddl");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "POSTGRES");
        Node firstNode = statementsNode.getNode("unknownStatement");
        Assert.assertNotNull((Object)firstNode);
        this.verifyBaseProperties(firstNode, "nt:unstructured", "1", "1", "0", 0L);
        this.verifyMixinType(firstNode, "ddl:unknownStatement");
        Node serverNode = statementsNode.getNode("CREATE SERVER");
        Assert.assertNotNull((Object)serverNode);
        this.verifyBaseProperties(serverNode, "nt:unstructured", "5", "1", "93", 0L);
        this.verifyMixinType(serverNode, "postgresddl:createServerStatement");
        Node ruleNode = statementsNode.getNode("_RETURN");
        Assert.assertNotNull((Object)ruleNode);
        this.verifyBaseProperties(ruleNode, "nt:unstructured", "7", "1", "144", 0L);
        this.verifyMixinType(ruleNode, "postgresddl:createRuleStatement");
    }
}

