/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.Immutables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@MBean(objectName="DistributionManager", description="Component that handles distribution of content across a cluster")
public class DistributionManagerImpl
implements DistributionManager {
    private static final Log log = LogFactory.getLog(DistributionManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private Configuration configuration;
    private RpcManager rpcManager;
    private CommandsFactory cf;
    private CacheNotifier cacheNotifier;
    private StateTransferManager stateTransferManager;
    private volatile ConsistentHash consistentHash;

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CommandsFactory cf, CacheNotifier cacheNotifier, StateTransferManager stateTransferManager) {
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.cf = cf;
        this.cacheNotifier = cacheNotifier;
        this.stateTransferManager = stateTransferManager;
    }

    @Start(priority=20)
    private void start() throws Exception {
        if (trace) {
            log.tracef("starting distribution manager on %s", this.getAddress());
        }
        this.consistentHash = ConsistentHashHelper.createConsistentHash(this.configuration, Collections.singleton(this.rpcManager.getAddress()));
    }

    private int getReplCount() {
        return this.configuration.getNumOwners();
    }

    private Address getAddress() {
        return this.rpcManager.getAddress();
    }

    @Override
    @Deprecated
    public boolean isLocal(Object key) {
        return this.getLocality(key).isLocal();
    }

    @Override
    public DataLocality getLocality(Object key) {
        boolean local = this.getConsistentHash().isKeyLocalToAddress(this.getAddress(), key, this.getReplCount());
        if (this.isRehashInProgress()) {
            if (local) {
                return DataLocality.LOCAL_UNCERTAIN;
            }
            return DataLocality.NOT_LOCAL_UNCERTAIN;
        }
        if (local) {
            return DataLocality.LOCAL;
        }
        return DataLocality.NOT_LOCAL;
    }

    @Override
    public List<Address> locate(Object key) {
        return this.getConsistentHash().locate(key, this.getReplCount());
    }

    @Override
    public Address getPrimaryLocation(Object key) {
        return this.getConsistentHash().primaryLocation(key);
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys) {
        return this.locateAll(keys, this.getReplCount());
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys, int numOwners) {
        return this.getConsistentHash().locateAll(keys, numOwners);
    }

    @Override
    public void transformForL1(CacheEntry entry) {
        if (entry.getLifespan() < 0L || entry.getLifespan() > this.configuration.getL1Lifespan()) {
            entry.setLifespan(this.configuration.getL1Lifespan());
        }
    }

    @Override
    public InternalCacheEntry retrieveFromRemoteSource(Object key, InvocationContext ctx, boolean acquireRemoteLock) throws Exception {
        GlobalTransaction gtx = acquireRemoteLock ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key, ctx.getFlags(), acquireRemoteLock, gtx);
        List<Address> targets = this.locate(key);
        targets.retainAll(this.rpcManager.getTransport().getMembers());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets, this.getAddress());
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(targets, get, ResponseMode.WAIT_FOR_VALID_RESPONSE, this.configuration.getSyncReplTimeout(), true, filter);
        if (!responses.isEmpty()) {
            for (Response r : responses.values()) {
                if (!(r instanceof SuccessfulResponse)) continue;
                InternalCacheValue cacheValue = (InternalCacheValue)((SuccessfulResponse)r).getResponseValue();
                return cacheValue.toInternalCacheEntry(key);
            }
        }
        return null;
    }

    @Override
    public ConsistentHash getConsistentHash() {
        return this.consistentHash;
    }

    @Override
    public ConsistentHash setConsistentHash(ConsistentHash newCH) {
        if (trace) {
            log.tracef("Installing new consistent hash %s", newCH);
        }
        ConsistentHash oldCH = this.consistentHash;
        this.cacheNotifier.notifyTopologyChanged(oldCH, newCH, true);
        this.consistentHash = newCH;
        this.cacheNotifier.notifyTopologyChanged(oldCH, newCH, false);
        return oldCH;
    }

    @Override
    @ManagedOperation(description="Determines whether a given key is affected by an ongoing rehash, if any.")
    @Operation(displayName="Could key be affected by rehash?")
    public boolean isAffectedByRehash(@Parameter(name="key", description="Key to check") Object key) {
        return this.stateTransferManager.isLocationInDoubt(key);
    }

    @Override
    public boolean isRehashInProgress() {
        return this.stateTransferManager.isStateTransferInProgress();
    }

    @Override
    public boolean isJoinComplete() {
        return this.stateTransferManager.isJoinComplete();
    }

    @Override
    public Collection<Address> getAffectedNodes(Collection<Object> affectedKeys) {
        if (affectedKeys == null || affectedKeys.isEmpty()) {
            if (trace) {
                log.trace("affected keys are empty");
            }
            return Collections.emptyList();
        }
        HashSet<Address> an = new HashSet<Address>();
        for (List<Address> addresses : this.locateAll(affectedKeys).values()) {
            an.addAll(addresses);
        }
        return Immutables.immutableListConvert(an);
    }

    @ManagedOperation(description="Tells you whether a given key is local to this instance of the cache.  Only works with String keys.")
    @Operation(displayName="Is key local?")
    public boolean isLocatedLocally(@Parameter(name="key", description="Key to query") String key) {
        return this.getLocality(key).isLocal();
    }

    @ManagedOperation(description="Locates an object in a cluster.  Only works with String keys.")
    @Operation(displayName="Locate key")
    public List<String> locateKey(@Parameter(name="key", description="Key to locate") String key) {
        LinkedList<String> l = new LinkedList<String>();
        for (Address a : this.locate(key)) {
            l.add(a.toString());
        }
        return l;
    }

    public String toString() {
        return "DistributionManagerImpl[consistentHash=" + this.consistentHash + "]";
    }
}

