/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Binary;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.query.model.AllNodes;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.ArithmeticOperand;
import org.modeshape.jcr.query.model.ArithmeticOperator;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DescendantNodeJoinCondition;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.Join;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.NamedSelector;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.Query;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.Selector;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.SetQuery;
import org.modeshape.jcr.query.model.Source;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Subquery;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

@NotThreadSafe
public class QueryBuilder {
    protected final TypeSystem typeSystem;
    protected Source source = new AllNodes();
    protected Constraint constraint;
    protected List<Column> columns = new LinkedList<Column>();
    protected List<Ordering> orderings = new LinkedList<Ordering>();
    protected Limit limit = Limit.NONE;
    protected boolean distinct;
    protected QueryCommand firstQuery;
    protected SetQuery.Operation firstQuerySetOperation;
    protected boolean firstQueryAll;

    public QueryBuilder(TypeSystem context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        this.typeSystem = context;
    }

    public QueryBuilder clear() {
        return this.clear(true);
    }

    protected QueryBuilder clear(boolean clearFirstQuery) {
        this.source = new AllNodes();
        this.constraint = null;
        this.columns = new LinkedList<Column>();
        this.orderings = new LinkedList<Ordering>();
        this.limit = Limit.NONE;
        this.distinct = false;
        if (clearFirstQuery) {
            this.firstQuery = null;
            this.firstQuerySetOperation = null;
        }
        return this;
    }

    protected SelectorName selector(String name) {
        return new SelectorName(name.trim());
    }

    protected NamedSelector namedSelector(String nameWithOptionalAlias) {
        String[] parts = nameWithOptionalAlias.split("\\s(AS|as)\\s");
        if (parts.length == 2) {
            return new NamedSelector(this.selector(parts[0]), this.selector(parts[1]));
        }
        return new NamedSelector(this.selector(parts[0]));
    }

    protected Column column(String nameExpression) {
        String[] parts = nameExpression.split("(?<!\\\\)\\.");
        for (int i = 0; i != parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        SelectorName name = null;
        String propertyName = null;
        String columnName = null;
        if (parts.length == 2) {
            name = this.selector(parts[0]);
            propertyName = parts[1];
            columnName = parts[1];
        } else if (this.source instanceof Selector) {
            Selector selector = (Selector)this.source;
            name = selector.hasAlias() ? selector.alias() : selector.name();
            propertyName = parts[0];
            columnName = parts[0];
        } else {
            throw new IllegalArgumentException(GraphI18n.columnMustBeScoped.text(new Object[]{parts[0]}));
        }
        return new Column(name, propertyName, columnName);
    }

    public QueryBuilder selectStar() {
        this.columns.clear();
        return this;
    }

    public QueryBuilder select(String ... columnNames) {
        for (String expression : columnNames) {
            this.columns.add(this.column(expression));
        }
        return this;
    }

    public QueryBuilder selectDistinctStar() {
        this.distinct = true;
        return this.selectStar();
    }

    public QueryBuilder selectDistinct(String ... columnNames) {
        this.distinct = true;
        return this.select(columnNames);
    }

    public QueryBuilder fromAllNodes() {
        this.source = new AllNodes();
        return this;
    }

    public QueryBuilder fromAllNodesAs(String alias) {
        AllNodes allNodes = new AllNodes(this.selector(alias));
        SelectorName oldName = this.source instanceof Selector ? ((Selector)this.source).name() : null;
        for (int i = 0; i != this.columns.size(); ++i) {
            Column old = this.columns.get(i);
            if (!old.selectorName().equals(oldName)) continue;
            this.columns.set(i, new Column(allNodes.aliasOrName(), old.getPropertyName(), old.getColumnName()));
        }
        this.source = allNodes;
        return this;
    }

    public QueryBuilder from(String tableNameWithOptionalAlias) {
        NamedSelector selector = this.namedSelector(tableNameWithOptionalAlias);
        SelectorName oldName = this.source instanceof Selector ? ((Selector)this.source).name() : null;
        for (int i = 0; i != this.columns.size(); ++i) {
            Column old = this.columns.get(i);
            if (!old.selectorName().equals(oldName)) continue;
            this.columns.set(i, new Column(selector.aliasOrName(), old.getPropertyName(), old.getColumnName()));
        }
        this.source = selector;
        return this;
    }

    public ConstraintBuilder where() {
        return new ConstraintBuilder(null);
    }

    public JoinClause join(String tableName) {
        return this.innerJoin(tableName);
    }

    public JoinClause innerJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.INNER);
    }

    public JoinClause crossJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.CROSS);
    }

    public JoinClause fullOuterJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.FULL_OUTER);
    }

    public JoinClause leftOuterJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.LEFT_OUTER);
    }

    public JoinClause rightOuterJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.RIGHT_OUTER);
    }

    public JoinClause joinAllNodesAs(String alias) {
        return this.innerJoinAllNodesAs(alias);
    }

    public JoinClause innerJoinAllNodesAs(String alias) {
        return new JoinClause(this.namedSelector(AllNodes.ALL_NODES_NAME + " AS " + alias), JoinType.INNER);
    }

    public JoinClause crossJoinAllNodesAs(String alias) {
        return new JoinClause(this.namedSelector(AllNodes.ALL_NODES_NAME + " AS " + alias), JoinType.CROSS);
    }

    public JoinClause fullOuterJoinAllNodesAs(String alias) {
        return new JoinClause(this.namedSelector(AllNodes.ALL_NODES_NAME + " AS " + alias), JoinType.FULL_OUTER);
    }

    public JoinClause leftOuterJoinAllNodesAs(String alias) {
        return new JoinClause(this.namedSelector(AllNodes.ALL_NODES_NAME + " AS " + alias), JoinType.LEFT_OUTER);
    }

    public JoinClause rightOuterJoinAllNodesAs(String alias) {
        return new JoinClause(this.namedSelector(AllNodes.ALL_NODES_NAME + " AS " + alias), JoinType.RIGHT_OUTER);
    }

    public QueryBuilder limit(int rowLimit) {
        this.limit.withRowLimit(rowLimit);
        return this;
    }

    public QueryBuilder offset(int offset) {
        this.limit.withOffset(offset);
        return this;
    }

    public QueryBuilder union() {
        this.firstQuery = this.query();
        this.firstQuerySetOperation = SetQuery.Operation.UNION;
        this.firstQueryAll = false;
        this.clear(false);
        return this;
    }

    public QueryBuilder unionAll() {
        this.firstQuery = this.query();
        this.firstQuerySetOperation = SetQuery.Operation.UNION;
        this.firstQueryAll = true;
        this.clear(false);
        return this;
    }

    public QueryBuilder intersect() {
        this.firstQuery = this.query();
        this.firstQuerySetOperation = SetQuery.Operation.INTERSECT;
        this.firstQueryAll = false;
        this.clear(false);
        return this;
    }

    public QueryBuilder intersectAll() {
        this.firstQuery = this.query();
        this.firstQuerySetOperation = SetQuery.Operation.INTERSECT;
        this.firstQueryAll = true;
        this.clear(false);
        return this;
    }

    public QueryBuilder except() {
        this.firstQuery = this.query();
        this.firstQuerySetOperation = SetQuery.Operation.EXCEPT;
        this.firstQueryAll = false;
        this.clear(false);
        return this;
    }

    public QueryBuilder exceptAll() {
        this.firstQuery = this.query();
        this.firstQuerySetOperation = SetQuery.Operation.EXCEPT;
        this.firstQueryAll = true;
        this.clear(false);
        return this;
    }

    public OrderByBuilder orderBy() {
        return new OrderByBuilder();
    }

    public QueryCommand query() {
        QueryCommand result = new Query(this.source, this.constraint, this.orderings, this.columns, this.limit, this.distinct);
        if (this.firstQuery != null) {
            if (this.firstQuery instanceof SetQuery && this.firstQuerySetOperation == SetQuery.Operation.EXCEPT) {
                SetQuery setQuery = (SetQuery)this.firstQuery;
                QueryCommand left = setQuery.getLeft();
                QueryCommand right = setQuery.getRight();
                SetQuery exceptQuery = new SetQuery(right, SetQuery.Operation.EXCEPT, result, this.firstQueryAll);
                result = new SetQuery(left, setQuery.operation(), exceptQuery, setQuery.isAll());
            } else {
                result = new SetQuery(this.firstQuery, this.firstQuerySetOperation, result, this.firstQueryAll);
            }
        }
        return result;
    }

    public class AndBuilder<T> {
        private final T object;

        protected AndBuilder(T object) {
            assert (object != null);
            this.object = object;
        }

        public T and() {
            return this.object;
        }
    }

    public class ComparisonBuilder {
        protected final DynamicOperand left;
        protected final ConstraintBuilder constraintBuilder;

        protected ComparisonBuilder(ConstraintBuilder constraintBuilder, DynamicOperand left) {
            this.left = left;
            this.constraintBuilder = constraintBuilder;
        }

        public ConstraintBuilder isInSubquery(QueryCommand subquery) {
            CheckArg.isNotNull((Object)subquery, (String)"subquery");
            return this.constraintBuilder.setConstraint(new SetCriteria(this.left, new Subquery(subquery)));
        }

        public ConstraintBuilder isInSubquery(Subquery subquery) {
            CheckArg.isNotNull((Object)subquery, (String)"subquery");
            return this.constraintBuilder.setConstraint(new SetCriteria(this.left, subquery));
        }

        public ConstraintBuilder isIn(Object ... literals) {
            CheckArg.isNotNull((Object)literals, (String)"literals");
            ArrayList<Literal> right = new ArrayList<Literal>();
            for (Object literal : literals) {
                right.add(literal instanceof Literal ? (Literal)literal : new Literal(literal));
            }
            return this.constraintBuilder.setConstraint(new SetCriteria(this.left, right));
        }

        public ConstraintBuilder isIn(Iterable<Object> literals) {
            CheckArg.isNotNull(literals, (String)"literals");
            ArrayList<Literal> right = new ArrayList<Literal>();
            for (Object literal : literals) {
                right.add(literal instanceof Literal ? (Literal)literal : new Literal(literal));
            }
            return this.constraintBuilder.setConstraint(new SetCriteria(this.left, right));
        }

        public ArithmeticBuilder plus() {
            return new ArithmeticBuilder(ArithmeticOperator.ADD, this, this.left, null);
        }

        public ArithmeticBuilder minus() {
            return new ArithmeticBuilder(ArithmeticOperator.SUBTRACT, this, this.left, null);
        }

        public RightHandSide is(Operator operator) {
            CheckArg.isNotNull((Object)operator, (String)"operator");
            return new RightHandSide(this, operator);
        }

        public RightHandSide isEqualTo() {
            return this.is(Operator.EQUAL_TO);
        }

        public RightHandSide isNotEqualTo() {
            return this.is(Operator.NOT_EQUAL_TO);
        }

        public RightHandSide isGreaterThan() {
            return this.is(Operator.GREATER_THAN);
        }

        public RightHandSide isGreaterThanOrEqualTo() {
            return this.is(Operator.GREATER_THAN_OR_EQUAL_TO);
        }

        public RightHandSide isLessThan() {
            return this.is(Operator.LESS_THAN);
        }

        public RightHandSide isLessThanOrEqualTo() {
            return this.is(Operator.LESS_THAN_OR_EQUAL_TO);
        }

        public RightHandSide isLike() {
            return this.is(Operator.LIKE);
        }

        public ConstraintBuilder isVariable(Operator operator, String variableName) {
            CheckArg.isNotNull((Object)operator, (String)"operator");
            return this.constraintBuilder.setConstraint(new Comparison(this.left, operator, new BindVariableName(variableName)));
        }

        public ConstraintBuilder is(Operator operator, QueryCommand subquery) {
            assert (operator != null);
            return this.is(operator, subquery);
        }

        public ConstraintBuilder is(Operator operator, Subquery subquery) {
            assert (operator != null);
            return this.is(operator, subquery);
        }

        public ConstraintBuilder is(Operator operator, Object literalOrSubquery) {
            assert (operator != null);
            return this.constraintBuilder.setConstraint(new Comparison(this.left, operator, this.adapt(literalOrSubquery)));
        }

        protected StaticOperand adapt(Object literalOrSubquery) {
            if (literalOrSubquery instanceof QueryCommand) {
                return new Subquery((QueryCommand)literalOrSubquery);
            }
            if (literalOrSubquery instanceof Subquery) {
                return (Subquery)literalOrSubquery;
            }
            if (literalOrSubquery instanceof Literal) {
                return (Literal)literalOrSubquery;
            }
            return new Literal(literalOrSubquery);
        }

        public ConstraintBuilder isBetween(Object lowerBoundLiteral, Object upperBoundLiteral) {
            assert (lowerBoundLiteral != null);
            assert (upperBoundLiteral != null);
            return this.constraintBuilder.setConstraint(new Between(this.left, this.adapt(lowerBoundLiteral), this.adapt(upperBoundLiteral)));
        }

        public ConstraintBuilder isEqualToVariable(String variableName) {
            return this.isVariable(Operator.EQUAL_TO, variableName);
        }

        public ConstraintBuilder isGreaterThanVariable(String variableName) {
            return this.isVariable(Operator.GREATER_THAN, variableName);
        }

        public ConstraintBuilder isGreaterThanOrEqualToVariable(String variableName) {
            return this.isVariable(Operator.GREATER_THAN_OR_EQUAL_TO, variableName);
        }

        public ConstraintBuilder isLessThanVariable(String variableName) {
            return this.isVariable(Operator.LESS_THAN, variableName);
        }

        public ConstraintBuilder isLessThanOrEqualToVariable(String variableName) {
            return this.isVariable(Operator.LESS_THAN_OR_EQUAL_TO, variableName);
        }

        public ConstraintBuilder isLikeVariable(String variableName) {
            return this.isVariable(Operator.LIKE, variableName);
        }

        public ConstraintBuilder isNotEqualToVariable(String variableName) {
            return this.isVariable(Operator.NOT_EQUAL_TO, variableName);
        }

        public ConstraintBuilder isEqualTo(Object literalOrSubquery) {
            return this.is(Operator.EQUAL_TO, literalOrSubquery);
        }

        public ConstraintBuilder isGreaterThan(Object literalOrSubquery) {
            return this.is(Operator.GREATER_THAN, literalOrSubquery);
        }

        public ConstraintBuilder isGreaterThanOrEqualTo(Object literalOrSubquery) {
            return this.is(Operator.GREATER_THAN_OR_EQUAL_TO, literalOrSubquery);
        }

        public ConstraintBuilder isLessThan(Object literalOrSubquery) {
            return this.is(Operator.LESS_THAN, literalOrSubquery);
        }

        public ConstraintBuilder isLessThanOrEqualTo(Object literalOrSubquery) {
            return this.is(Operator.LESS_THAN_OR_EQUAL_TO, literalOrSubquery);
        }

        public ConstraintBuilder isLike(Object literalOrSubquery) {
            return this.is(Operator.LIKE, literalOrSubquery);
        }

        public ConstraintBuilder isNotEqualTo(Object literalOrSubquery) {
            return this.is(Operator.NOT_EQUAL_TO, literalOrSubquery);
        }

        public LowerBoundary isBetween() {
            return new LowerBoundary(this);
        }
    }

    public class ArithmeticBuilder {
        protected final ArithmeticBuilder parent;
        protected final ArithmeticOperator operator;
        protected DynamicOperand left;
        protected final ComparisonBuilder comparisonBuilder;

        protected ArithmeticBuilder(ArithmeticOperator operator, ComparisonBuilder comparisonBuilder, DynamicOperand left, ArithmeticBuilder parent) {
            this.operator = operator;
            this.left = left;
            this.comparisonBuilder = comparisonBuilder;
            this.parent = parent;
        }

        public ComparisonBuilder length(String table, String property) {
            return this.comparisonBuilder(new Length(new PropertyValue(QueryBuilder.this.selector(table), property)));
        }

        public ComparisonBuilder propertyValue(String table, String property) {
            return this.comparisonBuilder(new PropertyValue(QueryBuilder.this.selector(table), property));
        }

        public ComparisonBuilder referenceValue(String table) {
            return this.comparisonBuilder(new ReferenceValue(QueryBuilder.this.selector(table)));
        }

        public ComparisonBuilder referenceValue(String table, String property) {
            return this.comparisonBuilder(new ReferenceValue(QueryBuilder.this.selector(table), property));
        }

        public ComparisonBuilder fullTextSearchScore(String table) {
            return this.comparisonBuilder(new FullTextSearchScore(QueryBuilder.this.selector(table)));
        }

        public ComparisonBuilder depth(String table) {
            return this.comparisonBuilder(new NodeDepth(QueryBuilder.this.selector(table)));
        }

        protected ComparisonBuilder comparisonBuilder(DynamicOperand right) {
            ArithmeticOperand leftOperand = null;
            if (this.left instanceof ArithmeticOperand) {
                ArithmeticOperand leftArith = (ArithmeticOperand)this.left;
                ArithmeticOperator operator = leftArith.operator();
                if (this.operator.precedes(operator)) {
                    ArithmeticOperand inner = new ArithmeticOperand(leftArith.getRight(), this.operator, right);
                    leftOperand = new ArithmeticOperand(leftArith.getLeft(), operator, inner);
                } else {
                    leftOperand = new ArithmeticOperand(leftArith, operator, right);
                }
            } else {
                leftOperand = new ArithmeticOperand(this.left, this.operator, right);
            }
            return new ComparisonBuilder(this.comparisonBuilder.constraintBuilder, leftOperand);
        }
    }

    public class LowerBoundary {
        protected final ComparisonBuilder comparisonBuilder;

        protected LowerBoundary(ComparisonBuilder comparisonBuilder) {
            this.comparisonBuilder = comparisonBuilder;
        }

        public AndBuilder<UpperBoundary> literal(String literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(int literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(long literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(float literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(Float.valueOf(literal))));
        }

        public AndBuilder<UpperBoundary> literal(double literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(DateTime literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(Path literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(Name literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(URI literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(UUID literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(Binary literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(BigDecimal literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> literal(boolean literal) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new Literal(literal)));
        }

        public AndBuilder<UpperBoundary> variable(String variableName) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, new BindVariableName(variableName)));
        }

        public AndBuilder<UpperBoundary> subquery(Subquery subquery) {
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.comparisonBuilder, subquery));
        }

        public AndBuilder<UpperBoundary> subquery(QueryCommand subquery) {
            return this.subquery(new Subquery(subquery));
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(int literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(String literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(boolean literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(long literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(double literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(BigDecimal literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(DateTime literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(Name literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(Path literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(UUID literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }

        public CastAs<AndBuilder<UpperBoundary>> cast(URI literal) {
            return new CastAsLowerBoundary(this.comparisonBuilder, literal);
        }
    }

    public class UpperBoundary {
        protected final StaticOperand lowerBound;
        protected final ComparisonBuilder comparisonBuilder;

        protected UpperBoundary(ComparisonBuilder comparisonBuilder, StaticOperand lowerBound) {
            this.lowerBound = lowerBound;
            this.comparisonBuilder = comparisonBuilder;
        }

        public ConstraintBuilder literal(String literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(int literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(long literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(float literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, Float.valueOf(literal));
        }

        public ConstraintBuilder literal(double literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(DateTime literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(Path literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(Name literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(URI literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(UUID literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(Binary literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(BigDecimal literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, literal);
        }

        public ConstraintBuilder literal(boolean literal) {
            return this.comparisonBuilder.isBetween(this.lowerBound, new Literal(literal));
        }

        public ConstraintBuilder variable(String variableName) {
            return this.comparisonBuilder.constraintBuilder.setConstraint(new Between(this.comparisonBuilder.left, this.lowerBound, new BindVariableName(variableName)));
        }

        public ConstraintBuilder subquery(Subquery subquery) {
            return this.comparisonBuilder.constraintBuilder.setConstraint(new Between(this.comparisonBuilder.left, this.lowerBound, subquery));
        }

        public ConstraintBuilder subquery(QueryCommand subquery) {
            return this.subquery(new Subquery(subquery));
        }

        public CastAs<ConstraintBuilder> cast(int literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(String literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(boolean literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(long literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(double literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(BigDecimal literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(DateTime literal) {
            return new CastAsUpperBoundary(this, literal.toUtcTimeZone());
        }

        public CastAs<ConstraintBuilder> cast(Name literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(Path literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(UUID literal) {
            return new CastAsUpperBoundary(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(URI literal) {
            return new CastAsUpperBoundary(this, literal);
        }
    }

    public class RightHandSide {
        protected final Operator operator;
        protected final ComparisonBuilder comparisonBuilder;

        protected RightHandSide(ComparisonBuilder comparisonBuilder, Operator operator) {
            this.operator = operator;
            this.comparisonBuilder = comparisonBuilder;
        }

        public ConstraintBuilder literal(String literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(int literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(long literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(float literal) {
            return this.comparisonBuilder.is(this.operator, Float.valueOf(literal));
        }

        public ConstraintBuilder literal(double literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(DateTime literal) {
            return this.comparisonBuilder.is(this.operator, literal.toUtcTimeZone());
        }

        public ConstraintBuilder literal(Path literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(Name literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(URI literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(UUID literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(Binary literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(BigDecimal literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(boolean literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(QueryCommand subquery) {
            return this.comparisonBuilder.is(this.operator, subquery);
        }

        public ConstraintBuilder variable(String variableName) {
            return this.comparisonBuilder.is(this.operator, variableName);
        }

        public CastAs<ConstraintBuilder> cast(int literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(String literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(boolean literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(long literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(double literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(BigDecimal literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(DateTime literal) {
            return new CastAsRightHandSide(this, literal.toUtcTimeZone());
        }

        public CastAs<ConstraintBuilder> cast(Name literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(Path literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(UUID literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(URI literal) {
            return new CastAsRightHandSide(this, literal);
        }
    }

    public class CastAsLowerBoundary
    extends CastAs<AndBuilder<UpperBoundary>> {
        private final ComparisonBuilder builder;

        protected CastAsLowerBoundary(ComparisonBuilder builder, Object value) {
            super(value);
            this.builder = builder;
        }

        @Override
        public AndBuilder<UpperBoundary> as(String type) {
            Object literal = QueryBuilder.this.typeSystem.getTypeFactory(type).create(this.value);
            return new AndBuilder<UpperBoundary>(new UpperBoundary(this.builder, new Literal(literal)));
        }
    }

    public class CastAsUpperBoundary
    extends CastAs<ConstraintBuilder> {
        private final UpperBoundary upperBoundary;

        protected CastAsUpperBoundary(UpperBoundary upperBoundary, Object value) {
            super(value);
            this.upperBoundary = upperBoundary;
        }

        @Override
        public ConstraintBuilder as(String type) {
            return this.upperBoundary.comparisonBuilder.isBetween(this.upperBoundary.lowerBound, QueryBuilder.this.typeSystem.getTypeFactory(type).create(this.value));
        }
    }

    public class CastAsRightHandSide
    extends CastAs<ConstraintBuilder> {
        private final RightHandSide rhs;

        protected CastAsRightHandSide(RightHandSide rhs, Object value) {
            super(value);
            this.rhs = rhs;
        }

        @Override
        public ConstraintBuilder as(String type) {
            return this.rhs.comparisonBuilder.is(this.rhs.operator, QueryBuilder.this.typeSystem.getTypeFactory(type).create(this.value));
        }
    }

    public abstract class CastAs<ReturnType> {
        protected final Object value;

        protected CastAs(Object value) {
            this.value = value;
        }

        public abstract ReturnType as(String var1);

        public ReturnType asString() {
            return this.as(QueryBuilder.this.typeSystem.getStringFactory().getTypeName());
        }

        public ReturnType asBoolean() {
            return this.as(QueryBuilder.this.typeSystem.getBooleanFactory().getTypeName());
        }

        public ReturnType asLong() {
            return this.as(QueryBuilder.this.typeSystem.getLongFactory().getTypeName());
        }

        public ReturnType asDouble() {
            return this.as(QueryBuilder.this.typeSystem.getDoubleFactory().getTypeName());
        }

        public ReturnType asDate() {
            return this.as(QueryBuilder.this.typeSystem.getDateTimeFactory().getTypeName());
        }

        public ReturnType asPath() {
            return this.as(QueryBuilder.this.typeSystem.getPathFactory().getTypeName());
        }
    }

    protected class LowerCaser
    extends ConstraintBuilder {
        private final ConstraintBuilder delegate;

        protected LowerCaser(ConstraintBuilder delegate) {
            super(null);
            this.delegate = delegate;
        }

        @Override
        protected ConstraintBuilder setConstraint(Constraint constraint) {
            Comparison comparison = (Comparison)constraint;
            return this.delegate.setConstraint(new Comparison(new LowerCase(comparison.getOperand1()), comparison.operator(), comparison.getOperand2()));
        }
    }

    protected class UpperCaser
    extends ConstraintBuilder {
        private final ConstraintBuilder delegate;

        protected UpperCaser(ConstraintBuilder delegate) {
            super(null);
            this.delegate = delegate;
        }

        @Override
        protected ConstraintBuilder setConstraint(Constraint constraint) {
            Comparison comparison = (Comparison)constraint;
            return this.delegate.setConstraint(new Comparison(new UpperCase(comparison.getOperand1()), comparison.operator(), comparison.getOperand2()));
        }
    }

    public class ConstraintBuilder
    implements DynamicOperandBuilder {
        private final ConstraintBuilder parent;
        private Constraint constraint;
        private Constraint left;
        private boolean and;
        private boolean negateConstraint;
        private boolean implicitParentheses = true;

        protected ConstraintBuilder(ConstraintBuilder parent) {
            this.parent = parent;
        }

        public QueryBuilder end() {
            this.buildLogicalConstraint();
            QueryBuilder.this.constraint = this.constraint;
            return QueryBuilder.this;
        }

        public ConstraintBuilder openParen() {
            return new ConstraintBuilder(this);
        }

        public ConstraintBuilder closeParen() {
            if (this.parent == null) {
                throw new IllegalStateException(GraphI18n.unexpectedClosingParenthesis.text(new Object[0]));
            }
            this.buildLogicalConstraint();
            this.parent.implicitParentheses = false;
            return this.parent.setConstraint(this.constraint);
        }

        public ConstraintBuilder and() {
            this.buildLogicalConstraint();
            this.left = this.constraint;
            this.constraint = null;
            this.and = true;
            return this;
        }

        public ConstraintBuilder or() {
            this.buildLogicalConstraint();
            this.left = this.constraint;
            this.constraint = null;
            this.and = false;
            return this;
        }

        public ConstraintBuilder not() {
            this.negateConstraint = true;
            return this;
        }

        protected ConstraintBuilder buildLogicalConstraint() {
            if (this.negateConstraint && this.constraint != null) {
                this.constraint = new Not(this.constraint);
                this.negateConstraint = false;
            }
            if (this.left != null && this.constraint != null) {
                if (this.and) {
                    if (this.left instanceof Or && this.implicitParentheses) {
                        Or previous = (Or)this.left;
                        this.constraint = new Or(previous.left(), new And(previous.right(), this.constraint));
                    } else {
                        this.constraint = new And(this.left, this.constraint);
                    }
                } else {
                    this.constraint = new Or(this.left, this.constraint);
                }
                this.left = null;
            }
            return this;
        }

        public ConstraintBuilder isSameNode(String table, String asNodeAtPath) {
            return this.setConstraint(new SameNode(QueryBuilder.this.selector(table), asNodeAtPath));
        }

        public ConstraintBuilder isChild(String childTable, String parentPath) {
            return this.setConstraint(new ChildNode(QueryBuilder.this.selector(childTable), parentPath));
        }

        public ConstraintBuilder isBelowPath(String descendantTable, String ancestorPath) {
            return this.setConstraint(new DescendantNode(QueryBuilder.this.selector(descendantTable), ancestorPath));
        }

        public ConstraintBuilder hasProperty(String table, String propertyName) {
            return this.setConstraint(new PropertyExistence(QueryBuilder.this.selector(table), propertyName));
        }

        public ConstraintBuilder search(String table, String searchExpression) {
            return this.setConstraint(new FullTextSearch(QueryBuilder.this.selector(table), searchExpression));
        }

        public ConstraintBuilder search(String table, String propertyName, String searchExpression) {
            return this.setConstraint(new FullTextSearch(QueryBuilder.this.selector(table), propertyName, searchExpression));
        }

        protected ComparisonBuilder comparisonBuilder(DynamicOperand operand) {
            return new ComparisonBuilder(this, operand);
        }

        @Override
        public ComparisonBuilder length(String table, String property) {
            return this.comparisonBuilder(new Length(new PropertyValue(QueryBuilder.this.selector(table), property)));
        }

        @Override
        public ComparisonBuilder propertyValue(String table, String property) {
            return this.comparisonBuilder(new PropertyValue(QueryBuilder.this.selector(table), property));
        }

        @Override
        public ComparisonBuilder strongReferenceValue(String table) {
            return this.comparisonBuilder(new ReferenceValue(QueryBuilder.this.selector(table), null, false));
        }

        @Override
        public ComparisonBuilder referenceValue(String table) {
            return this.comparisonBuilder(new ReferenceValue(QueryBuilder.this.selector(table)));
        }

        @Override
        public ComparisonBuilder referenceValue(String table, String property) {
            return this.comparisonBuilder(new ReferenceValue(QueryBuilder.this.selector(table), property));
        }

        @Override
        public ComparisonBuilder fullTextSearchScore(String table) {
            return this.comparisonBuilder(new FullTextSearchScore(QueryBuilder.this.selector(table)));
        }

        @Override
        public ComparisonBuilder depth(String table) {
            return this.comparisonBuilder(new NodeDepth(QueryBuilder.this.selector(table)));
        }

        @Override
        public ComparisonBuilder path(String table) {
            return this.comparisonBuilder(new NodePath(QueryBuilder.this.selector(table)));
        }

        @Override
        public ComparisonBuilder nodeLocalName(String table) {
            return this.comparisonBuilder(new NodeLocalName(QueryBuilder.this.selector(table)));
        }

        @Override
        public ComparisonBuilder nodeName(String table) {
            return this.comparisonBuilder(new NodeName(QueryBuilder.this.selector(table)));
        }

        @Override
        public DynamicOperandBuilder upperCaseOf() {
            return new UpperCaser(this);
        }

        @Override
        public DynamicOperandBuilder lowerCaseOf() {
            return new LowerCaser(this);
        }

        protected ConstraintBuilder setConstraint(Constraint constraint) {
            if (this.constraint != null && this.left == null) {
                this.and();
            }
            this.constraint = constraint;
            return this.buildLogicalConstraint();
        }
    }

    public static interface DynamicOperandBuilder {
        public ComparisonBuilder length(String var1, String var2);

        public ComparisonBuilder propertyValue(String var1, String var2);

        public ComparisonBuilder referenceValue(String var1);

        public ComparisonBuilder referenceValue(String var1, String var2);

        public ComparisonBuilder strongReferenceValue(String var1);

        public ComparisonBuilder fullTextSearchScore(String var1);

        public ComparisonBuilder depth(String var1);

        public ComparisonBuilder path(String var1);

        public ComparisonBuilder nodeLocalName(String var1);

        public ComparisonBuilder nodeName(String var1);

        public DynamicOperandBuilder upperCaseOf();

        public DynamicOperandBuilder lowerCaseOf();
    }

    public class JoinClause {
        private final NamedSelector rightSource;
        private final JoinType type;

        protected JoinClause(NamedSelector rightTable, JoinType type) {
            this.rightSource = rightTable;
            this.type = type;
        }

        protected SelectorName nameOf(String tableName) {
            final SelectorName name = new SelectorName(tableName);
            if (this.rightSource.aliasOrName().equals(name)) {
                return name;
            }
            final AtomicBoolean notFound = new AtomicBoolean(true);
            Visitors.visitAll(QueryBuilder.this.source, new Visitors.AbstractVisitor(){

                @Override
                public void visit(AllNodes selector) {
                    if (notFound.get() && selector.aliasOrName().equals(name)) {
                        notFound.set(false);
                    }
                }

                @Override
                public void visit(NamedSelector selector) {
                    if (notFound.get() && selector.aliasOrName().equals(name)) {
                        notFound.set(false);
                    }
                }
            });
            if (notFound.get()) {
                throw new IllegalArgumentException("Expected \"" + tableName + "\" to be a valid table name or alias");
            }
            return name;
        }

        public QueryBuilder on(String columnEqualExpression) {
            String[] parts = columnEqualExpression.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Expected equality expression for columns, but found \"" + columnEqualExpression + "\"");
            }
            return this.createJoin(new EquiJoinCondition(QueryBuilder.this.column(parts[0]), QueryBuilder.this.column(parts[1])));
        }

        public QueryBuilder onSameNode(String table1, String table2) {
            return this.createJoin(new SameNodeJoinCondition(this.nameOf(table1), this.nameOf(table2)));
        }

        public QueryBuilder onDescendant(String ancestorTable, String descendantTable) {
            return this.createJoin(new DescendantNodeJoinCondition(this.nameOf(ancestorTable), this.nameOf(descendantTable)));
        }

        public QueryBuilder onChildNode(String parentTable, String childTable) {
            return this.createJoin(new ChildNodeJoinCondition(this.nameOf(parentTable), this.nameOf(childTable)));
        }

        protected QueryBuilder createJoin(JoinCondition condition) {
            if (this.type == JoinType.CROSS && QueryBuilder.this.source instanceof Join && ((Join)QueryBuilder.this.source).type() != JoinType.CROSS) {
                Join left = (Join)QueryBuilder.this.source;
                Join cross = new Join(left.getRight(), this.type, this.rightSource, condition);
                QueryBuilder.this.source = new Join(left.getLeft(), left.type(), cross, left.getJoinCondition());
            } else {
                QueryBuilder.this.source = new Join(QueryBuilder.this.source, this.type, this.rightSource, condition);
            }
            return QueryBuilder.this;
        }
    }

    protected class SingleOrderByOperandBuilder
    implements OrderByOperandBuilder {
        private final Order order;
        private final OrderByBuilder builder;

        protected SingleOrderByOperandBuilder(OrderByBuilder builder, Order order) {
            this.order = order;
            this.builder = builder;
        }

        protected OrderByBuilder addOrdering(DynamicOperand operand) {
            Ordering ordering = new Ordering(operand, this.order);
            QueryBuilder.this.orderings.add(ordering);
            return this.builder;
        }

        @Override
        public OrderByBuilder propertyValue(String table, String property) {
            return this.addOrdering(new PropertyValue(QueryBuilder.this.selector(table), property));
        }

        @Override
        public OrderByBuilder referenceValue(String table) {
            return this.addOrdering(new ReferenceValue(QueryBuilder.this.selector(table)));
        }

        @Override
        public OrderByBuilder referenceValue(String table, String property) {
            return this.addOrdering(new ReferenceValue(QueryBuilder.this.selector(table), property));
        }

        @Override
        public OrderByBuilder length(String table, String property) {
            return this.addOrdering(new Length(new PropertyValue(QueryBuilder.this.selector(table), property)));
        }

        @Override
        public OrderByBuilder fullTextSearchScore(String table) {
            return this.addOrdering(new FullTextSearchScore(QueryBuilder.this.selector(table)));
        }

        @Override
        public OrderByBuilder depth(String table) {
            return this.addOrdering(new NodeDepth(QueryBuilder.this.selector(table)));
        }

        @Override
        public OrderByBuilder path(String table) {
            return this.addOrdering(new NodePath(QueryBuilder.this.selector(table)));
        }

        @Override
        public OrderByBuilder nodeName(String table) {
            return this.addOrdering(new NodeName(QueryBuilder.this.selector(table)));
        }

        @Override
        public OrderByBuilder nodeLocalName(String table) {
            return this.addOrdering(new NodeLocalName(QueryBuilder.this.selector(table)));
        }

        @Override
        public OrderByOperandBuilder lowerCaseOf() {
            return new SingleOrderByOperandBuilder(this.builder, this.order){

                @Override
                protected OrderByBuilder addOrdering(DynamicOperand operand) {
                    return super.addOrdering(new LowerCase(operand));
                }
            };
        }

        @Override
        public OrderByOperandBuilder upperCaseOf() {
            return new SingleOrderByOperandBuilder(this.builder, this.order){

                @Override
                protected OrderByBuilder addOrdering(DynamicOperand operand) {
                    return super.addOrdering(new UpperCase(operand));
                }
            };
        }
    }

    public class OrderByBuilder {
        protected OrderByBuilder() {
        }

        public OrderByOperandBuilder ascending() {
            return new SingleOrderByOperandBuilder(this, Order.ASCENDING);
        }

        public OrderByOperandBuilder descending() {
            return new SingleOrderByOperandBuilder(this, Order.DESCENDING);
        }

        public OrderByBuilder then() {
            return this;
        }

        public QueryBuilder end() {
            return QueryBuilder.this;
        }
    }

    public static interface OrderByOperandBuilder {
        public OrderByBuilder length(String var1, String var2);

        public OrderByBuilder propertyValue(String var1, String var2);

        public OrderByBuilder referenceValue(String var1);

        public OrderByBuilder referenceValue(String var1, String var2);

        public OrderByBuilder fullTextSearchScore(String var1);

        public OrderByBuilder depth(String var1);

        public OrderByBuilder path(String var1);

        public OrderByBuilder nodeLocalName(String var1);

        public OrderByBuilder nodeName(String var1);

        public OrderByOperandBuilder upperCaseOf();

        public OrderByOperandBuilder lowerCaseOf();
    }
}

