/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.rest.AbstractHandler;

@Immutable
class RepositoryHandler
extends AbstractHandler {
    RepositoryHandler() {
    }

    public String getWorkspaces(HttpServletRequest request, String rawRepositoryName) throws JSONException, RepositoryException {
        assert (request != null);
        assert (rawRepositoryName != null);
        JSONObject workspaces = new JSONObject();
        Session session = this.getSession(request, rawRepositoryName, null);
        rawRepositoryName = URL_ENCODER.encode(rawRepositoryName);
        String uri = request.getRequestURI();
        uri = uri.substring(0, uri.length() - rawRepositoryName.length() - 1);
        for (String name : session.getWorkspace().getAccessibleWorkspaceNames()) {
            if (name.trim().length() == 0) {
                name = "<default>";
            }
            name = URL_ENCODER.encode(name);
            JSONObject workspace = new JSONObject();
            JSONObject resources = new JSONObject();
            String uriPrefix = uri + "/" + rawRepositoryName + "/" + name;
            resources.put("query", (Object)(uriPrefix + "/query"));
            resources.put("items", (Object)(uriPrefix + "/items"));
            workspace.put("name", (Object)name);
            workspace.put("resources", (Object)resources);
            JSONObject wrapper = new JSONObject();
            wrapper.put("workspace", (Object)workspace);
            workspaces.put(name, (Object)wrapper);
        }
        return this.responseString(workspaces, request);
    }
}

