/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.affinity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import junit.framework.Assert;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityServiceImpl;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;

public class BaseKeyAffinityServiceTest
extends BaseDistFunctionalTest {
    protected KeyAffinityServiceImpl<Object> keyAffinityService;

    protected void assertMapsToAddress(Object o, Address addr) {
        ConsistentHash hash = ((Cache)this.caches.get(0)).getAdvancedCache().getDistributionManager().getConsistentHash();
        List addresses = hash.locate(o, this.numOwners);
        Assert.assertEquals((String)("Expected key " + o + " to map to address " + addr + ". List of addresses is" + addresses), (boolean)true, (boolean)addresses.contains(addr));
    }

    protected List<Address> topology() {
        return this.topology((CacheContainer)((Cache)this.caches.get(0)).getCacheManager());
    }

    protected List<Address> topology(CacheContainer cm) {
        return cm.getCache(this.cacheName).getAdvancedCache().getRpcManager().getTransport().getMembers();
    }

    protected void assertEventualFullCapacity() throws InterruptedException {
        List<Address> addresses = this.topology();
        this.assertEventualFullCapacity(addresses);
    }

    protected void assertCorrectCapacity() throws InterruptedException {
        this.assertCorrectCapacity(this.topology());
    }

    protected void assertEventualFullCapacity(List<Address> addresses) throws InterruptedException {
        Map blockingQueueMap = this.keyAffinityService.getAddress2KeysMapping();
        long maxWaitTime = 1200000L;
        for (Address addr : addresses) {
            BlockingQueue queue = (BlockingQueue)blockingQueueMap.get(addr);
            long giveupTime = System.currentTimeMillis() + maxWaitTime;
            while (queue.size() != 100 && System.currentTimeMillis() < giveupTime) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((int)100, (int)queue.size());
        }
        Assert.assertEquals((int)this.keyAffinityService.getMaxNumberOfKeys(), (int)this.keyAffinityService.existingKeyCount.get());
        Assert.assertEquals((int)(addresses.size() * 100), (int)this.keyAffinityService.existingKeyCount.get());
        Assert.assertEquals((boolean)false, (boolean)this.keyAffinityService.isKeyGeneratorThreadActive());
    }

    protected void assertCorrectCapacity(List<Address> addresses) throws InterruptedException {
        Map blockingQueueMap = this.keyAffinityService.getAddress2KeysMapping();
        long maxWaitTime = 300000L;
        for (Address addr : addresses) {
            BlockingQueue queue = (BlockingQueue)blockingQueueMap.get(addr);
            long giveupTime = System.currentTimeMillis() + maxWaitTime;
            while ((float)queue.size() < 50.0f && System.currentTimeMillis() < giveupTime) {
                Thread.sleep(100L);
            }
            assert ((float)queue.size() >= 50.0f) : "Obtained " + queue.size();
        }
    }

    protected void assertKeyAffinityCorrectness() {
        List<Address> addressList = this.topology();
        this.assertKeyAffinityCorrectness(addressList);
    }

    protected void assertKeyAffinityCorrectness(Collection<Address> addressList) {
        Map blockingQueueMap = this.keyAffinityService.getAddress2KeysMapping();
        for (Address addr : addressList) {
            BlockingQueue queue = (BlockingQueue)blockingQueueMap.get(addr);
            Assert.assertEquals((int)100, (int)queue.size());
            for (Object o : queue) {
                this.assertMapsToAddress(o, addr);
            }
        }
    }

    protected void waitForClusterToResize() {
        TestingUtil.blockUntilViewsReceived(10000, false, this.caches);
        TestingUtil.waitForRehashToComplete(this.caches);
        Assert.assertEquals((int)this.caches.size(), (int)this.topology().size());
    }
}

