/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.affinity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import junit.framework.Assert;
import org.infinispan.Cache;
import org.infinispan.affinity.BaseKeyAffinityServiceTest;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyAffinityServiceImpl;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.RndKeyGenerator;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="affinity.KeyAffinityServiceTest")
public class KeyAffinityServiceTest
extends BaseKeyAffinityServiceTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.INIT_CLUSTER_SIZE = 2;
        super.createCacheManagers();
        Assert.assertEquals((int)2, (int)this.topology((CacheContainer)((Cache)this.caches.get(0)).getCacheManager()).size());
        Assert.assertEquals((int)2, (int)this.topology((CacheContainer)((Cache)this.caches.get(1)).getCacheManager()).size());
        this.cache(0, this.cacheName).put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)this.cache(0, this.cacheName).get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)this.cache(1, this.cacheName).get((Object)"k"));
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "KeyGeneratorThread");
            }
        };
        this.keyAffinityService = (KeyAffinityServiceImpl)KeyAffinityServiceFactory.newKeyAffinityService((Cache)this.manager(0).getCache(this.cacheName), (Executor)Executors.newSingleThreadExecutor(tf), (KeyGenerator)new RndKeyGenerator(), (int)100);
    }

    public void testKeysAreCorrectlyCreated() throws Exception {
        this.assertEventualFullCapacity();
        this.assertKeyAffinityCorrectness();
    }

    @Test(dependsOnMethods={"testKeysAreCorrectlyCreated"})
    public void testConcurrentConsumptionOfKeys() throws InterruptedException {
        ArrayList<KeyConsumer> consumers = new ArrayList<KeyConsumer>();
        int keysToConsume = 1000;
        CountDownLatch consumersStart = new CountDownLatch(1);
        for (int i = 0; i < 10; ++i) {
            consumers.add(new KeyConsumer(keysToConsume, consumersStart));
        }
        consumersStart.countDown();
        for (KeyConsumer kc : consumers) {
            kc.join();
        }
        for (KeyConsumer kc : consumers) {
            Assert.assertEquals(null, (Object)kc.exception);
        }
        this.assertCorrectCapacity();
    }

    @Test(dependsOnMethods={"testConcurrentConsumptionOfKeys"})
    public void testServerAdded() throws InterruptedException {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration(this.cacheName, this.configuration);
        Cache cache = cm.getCache(this.cacheName);
        this.caches.add(cache);
        this.waitForClusterToResize();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return KeyAffinityServiceTest.this.keyAffinityService.getAddress2KeysMapping().keySet().size() == 3;
            }
        });
        Assert.assertEquals((int)3, (int)this.keyAffinityService.getAddress2KeysMapping().keySet().size());
        this.assertEventualFullCapacity();
        this.assertKeyAffinityCorrectness();
    }

    @Test(dependsOnMethods={"testServerAdded"})
    public void testServersDropped() throws InterruptedException {
        ((Cache)this.caches.get(2)).getCacheManager().stop();
        this.caches.remove(2);
        this.waitForClusterToResize();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return KeyAffinityServiceTest.this.keyAffinityService.getAddress2KeysMapping().keySet().size() == 2;
            }
        });
        Assert.assertEquals((int)2, (int)this.keyAffinityService.getAddress2KeysMapping().keySet().size());
        this.assertEventualFullCapacity();
        this.assertKeyAffinityCorrectness();
    }

    @Test(dependsOnMethods={"testServersDropped"})
    public void testCollocatedKey() {
        ConsistentHash hash = this.manager(0).getCache(this.cacheName).getAdvancedCache().getDistributionManager().getConsistentHash();
        for (int i = 0; i < 1000; ++i) {
            List addresses = hash.locate((Object)i, this.numOwners);
            Object collocatedKey = this.keyAffinityService.getCollocatedKey((Object)i);
            List addressList = hash.locate(collocatedKey, this.numOwners);
            Assert.assertEquals((Object)addresses, (Object)addressList);
        }
    }

    public class KeyConsumer
    extends Thread {
        volatile Exception exception;
        private final int keysToConsume;
        private CountDownLatch consumersStart;
        private final List<Address> topology;
        private final Random rnd;

        public KeyConsumer(int keysToConsume, CountDownLatch consumersStart) {
            super("KeyConsumer");
            this.topology = KeyAffinityServiceTest.this.topology();
            this.rnd = new Random();
            this.keysToConsume = keysToConsume;
            this.consumersStart = consumersStart;
            this.start();
        }

        @Override
        public void run() {
            try {
                this.consumersStart.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            for (int i = 0; i < this.keysToConsume; ++i) {
                Address whichAddr = this.topology.get(this.rnd.nextInt(this.topology.size()));
                try {
                    Object keyForAddress = KeyAffinityServiceTest.this.keyAffinityService.getKeyForAddress(whichAddr);
                    KeyAffinityServiceTest.this.assertMapsToAddress(keyForAddress, whichAddr);
                    continue;
                }
                catch (Exception e) {
                    this.exception = e;
                    break;
                }
            }
        }
    }
}

