/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ObjectDuplicator;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.APINonTxTest")
public class APINonTxTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(false);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        cm.defineConfiguration("test", c);
        this.cache = cm.getCache("test");
        return cm;
    }

    public void testConvenienceMethods() {
        String key = "key";
        String value = "value";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        assert (this.cache.get((Object)key) == null);
        assert (this.cache.keySet().isEmpty());
        assert (this.cache.values().isEmpty());
        assert (this.cache.entrySet().isEmpty());
        this.cache.put((Object)key, (Object)value);
        assert (value.equals(this.cache.get((Object)key)));
        assert (1 == this.cache.keySet().size() && 1 == this.cache.values().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        this.cache.remove((Object)key);
        assert (this.cache.get((Object)key) == null);
        assert (this.cache.keySet().isEmpty());
        assert (this.cache.values().isEmpty());
        assert (this.cache.entrySet().isEmpty());
        this.cache.putAll(data);
        assert (value.equals(this.cache.get((Object)key)));
        assert (1 == this.cache.keySet().size() && 1 == this.cache.values().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
    }

    public void testStopClearsData() throws Exception {
        String key = "key";
        String value = "value";
        int size = 0;
        this.cache.put((Object)key, (Object)value);
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        this.cache.stop();
        assert (this.cache.getStatus() == ComponentStatus.TERMINATED);
        this.cache.start();
        assert (!this.cache.containsKey((Object)key));
        assert (this.cache.isEmpty());
        assert (!this.cache.keySet().contains(key));
        assert (this.cache.keySet().isEmpty());
        assert (!this.cache.values().contains(value));
        assert (this.cache.values().isEmpty());
        assert (this.cache.entrySet().isEmpty());
    }

    public void testEvict() {
        String key1 = "keyOne";
        String key2 = "keyTwo";
        String value = "value";
        int size = 0;
        this.cache.put((Object)key1, (Object)value);
        this.cache.put((Object)key2, (Object)value);
        assert (this.cache.containsKey((Object)key1));
        assert (this.cache.containsKey((Object)key2));
        size = 2;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key1));
        assert (this.cache.keySet().contains(key2));
        assert (this.cache.values().contains(value));
        this.cache.evict((Object)key2);
        assert (this.cache.containsKey((Object)key1));
        assert (!this.cache.containsKey((Object)key2));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key1));
        assert (!this.cache.keySet().contains(key2));
        assert (this.cache.values().contains(value));
        this.cache.evict((Object)key1);
        assert (!this.cache.containsKey((Object)key1));
        assert (!this.cache.containsKey((Object)key2));
        assert (this.cache.isEmpty());
        assert (!this.cache.keySet().contains(key1));
        assert (!this.cache.keySet().contains(key2));
        assert (this.cache.keySet().isEmpty());
        assert (!this.cache.values().contains(value));
        assert (this.cache.values().isEmpty());
        assert (this.cache.entrySet().isEmpty());
    }

    public void testImmutabilityOfKeyValueEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        Set keys = this.cache.keySet();
        Collection values = this.cache.values();
        Set entries = this.cache.entrySet();
        Collection[] collections = new Collection[]{keys, values, entries};
        Object newObj = new Object();
        ArrayList<Object> newObjCol = new ArrayList<Object>();
        newObjCol.add(newObj);
        for (Collection col : collections) {
            try {
                col.add(newObj);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                col.addAll(newObjCol);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.clear();
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.remove("1");
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.removeAll(newObjCol);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.retainAll(newObjCol);
                if ($assertionsDisabled) continue;
                throw new AssertionError((Object)"Should have thrown a UnsupportedOperationException");
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
        for (Map.Entry entry : entries) {
            try {
                entry.setValue(newObj);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
            }
        }
    }

    public void testKeyValueEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(key1, value1);
        m.put(key2, value2);
        m.put(key3, value3);
        this.cache.putAll(m);
        assert (3 == this.cache.size() && 3 == this.cache.keySet().size() && 3 == this.cache.values().size() && 3 == this.cache.entrySet().size());
        HashSet<String> expKeys = new HashSet<String>();
        expKeys.add(key1);
        expKeys.add(key2);
        expKeys.add(key3);
        HashSet<String> expValues = new HashSet<String>();
        expValues.add(value1);
        expValues.add(value2);
        expValues.add(value3);
        Set expKeyEntries = ObjectDuplicator.duplicateSet(expKeys);
        Set expValueEntries = ObjectDuplicator.duplicateSet(expValues);
        Set keys = this.cache.keySet();
        for (Object key : keys) {
            assert (expKeys.remove(key));
        }
        assert (expKeys.isEmpty()) : "Did not see keys " + expKeys + " in iterator!";
        Collection values = this.cache.values();
        for (Object value : values) {
            assert (expValues.remove(value));
        }
        assert (expValues.isEmpty()) : "Did not see keys " + expValues + " in iterator!";
        Set entries = this.cache.entrySet();
        for (Map.Entry entry : entries) {
            assert (expKeyEntries.remove(entry.getKey()));
            assert (expValueEntries.remove(entry.getValue()));
        }
        assert (expKeyEntries.isEmpty()) : "Did not see keys " + expKeyEntries + " in iterator!";
        assert (expValueEntries.isEmpty()) : "Did not see keys " + expValueEntries + " in iterator!";
    }

    public void testSizeAndContents() throws Exception {
        String key = "key";
        String value = "value";
        int size = 0;
        assert (this.cache.isEmpty());
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (!this.cache.containsKey((Object)key));
        assert (!this.cache.keySet().contains(key));
        assert (!this.cache.values().contains(value));
        this.cache.put((Object)key, (Object)value);
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.containsKey((Object)key));
        assert (!this.cache.isEmpty());
        assert (this.cache.containsKey((Object)key));
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        assert (this.cache.remove((Object)key).equals(value));
        assert (this.cache.isEmpty());
        size = 0;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (!this.cache.containsKey((Object)key));
        assert (!this.cache.keySet().contains(key));
        assert (!this.cache.values().contains(value));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        assert (this.cache.get((Object)"1").equals("one"));
        assert (this.cache.get((Object)"2").equals("two"));
        assert (this.cache.get((Object)"3").equals("three"));
        size = 3;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        m = new HashMap();
        m.put("1", "newvalue");
        m.put("4", "four");
        this.cache.putAll(m);
        assert (this.cache.get((Object)"1").equals("newvalue"));
        assert (this.cache.get((Object)"2").equals("two"));
        assert (this.cache.get((Object)"3").equals("three"));
        assert (this.cache.get((Object)"4").equals("four"));
        size = 4;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
    }

    public void testConcurrentMapMethods() {
        assert (this.cache.putIfAbsent((Object)"A", (Object)"B") == null);
        assert (this.cache.putIfAbsent((Object)"A", (Object)"C").equals("B"));
        assert (this.cache.get((Object)"A").equals("B"));
        assert (!this.cache.remove((Object)"A", (Object)"C"));
        assert (this.cache.containsKey((Object)"A"));
        assert (this.cache.remove((Object)"A", (Object)"B"));
        assert (!this.cache.containsKey((Object)"A"));
        this.cache.put((Object)"A", (Object)"B");
        assert (!this.cache.replace((Object)"A", (Object)"D", (Object)"C"));
        assert (this.cache.get((Object)"A").equals("B"));
        assert (this.cache.replace((Object)"A", (Object)"B", (Object)"C"));
        assert (this.cache.get((Object)"A").equals("C"));
        assert (this.cache.replace((Object)"A", (Object)"X").equals("C"));
        assert (this.cache.replace((Object)"X", (Object)"A") == null);
        assert (!this.cache.containsKey((Object)"X"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullKeyParameter() {
        this.cache.put(null, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullValueParameter() {
        this.cache.put((Object)"hello", null);
    }
}

