/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.batch;

import org.infinispan.Cache;
import org.infinispan.api.batch.AbstractBatchTest;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.batch.BatchWithoutTMTest")
public class BatchWithoutTMTest
extends AbstractBatchTest {
    EmbeddedCacheManager cm;
    private static final Log log = LogFactory.getLog(BatchWithoutTMTest.class);

    @BeforeClass
    public void createCacheManager() {
        Configuration defaultConfiguration = TestCacheManagerFactory.getDefaultConfiguration(true);
        defaultConfiguration.fluent().invocationBatching();
        defaultConfiguration.fluent().transaction().autoCommit(false);
        this.cm = TestCacheManagerFactory.createCacheManager(defaultConfiguration);
    }

    @AfterClass
    public void destroyCacheManager() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
    }

    public void testBatchWithoutCfg() {
        Cache<String, String> cache = null;
        cache = this.createCache(false, "testBatchWithoutCfg");
        try {
            cache.startBatch();
            assert (false) : "Should have failed";
        }
        catch (ConfigurationException good) {
            // empty catch block
        }
        try {
            cache.endBatch(true);
            assert (false) : "Should have failed";
        }
        catch (ConfigurationException good) {
            // empty catch block
        }
        try {
            cache.endBatch(false);
            assert (false) : "Should have failed";
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testEndBatchWithoutStartBatch() {
        Cache<String, String> cache = null;
        cache = this.createCache(true, "testEndBatchWithoutStartBatch");
        cache.endBatch(true);
        cache.endBatch(false);
    }

    public void testStartBatchIdempotency() {
        Cache<String, String> cache = null;
        cache = this.createCache(true, "testStartBatchIdempotency");
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        cache.startBatch();
        cache.put((Object)"k2", (Object)"v2");
        cache.endBatch(true);
        assert ("v".equals(cache.get((Object)"k")));
        assert ("v2".equals(cache.get((Object)"k2")));
    }

    public void testBatchVisibility() throws InterruptedException {
        Cache<String, String> cache = null;
        cache = this.createCache(true, "testBatchVisibility");
        log.info((Object)"Here it starts...");
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        Assert.assertEquals((String)this.getOnDifferentThread(cache, "k"), null, (String)"Other thread should not see batch update till batch completes!");
        cache.endBatch(true);
        Assert.assertEquals((String)"v", (String)this.getOnDifferentThread(cache, "k"));
    }

    public void testBatchRollback() throws Exception {
        Cache<String, String> cache = null;
        cache = this.createCache(true, "testBatchRollback");
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        cache.put((Object)"k2", (Object)"v2");
        assert (this.getOnDifferentThread(cache, "k") == null);
        assert (this.getOnDifferentThread(cache, "k2") == null);
        cache.endBatch(false);
        assert (this.getOnDifferentThread(cache, "k") == null);
        assert (this.getOnDifferentThread(cache, "k2") == null);
    }

    private Cache<String, String> createCache(boolean enableBatch, String name) {
        Configuration c = new Configuration();
        c.setInvocationBatchingEnabled(enableBatch);
        this.cm.defineConfiguration(name, c);
        return this.cm.getCache(name);
    }
}

